/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.collections.ReferenceMap;

public class ChatManager {
    private static long id;
    private static String prefix;
    private Set<ChatManagerListener> chatManagerListeners;
    private Connection connection;
    private Map<PacketInterceptor, PacketFilter> interceptors;
    private Map<String, Chat> jidChats;
    private Map<String, Chat> threadChats = new ReferenceMap<String, Chat>(0, 2);

    static {
        prefix = StringUtils.randomString(5);
        id = 0L;
    }

    ChatManager(Connection connection) {
        this.jidChats = new ReferenceMap<String, Chat>(0, 2);
        this.chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
        this.interceptors = new WeakHashMap<PacketInterceptor, PacketFilter>();
        this.connection = connection;
        PacketFilter packetFilter = new PacketFilter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean accept(Packet object) {
                Message.Type type;
                return object instanceof Message && (type = ((Message)object).getType()) != Message.Type.groupchat && type != Message.Type.headline;
            }
        };
        connection.addPacketListener(new PacketListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void processPacket(Packet object) {
                Object object2;
                Message message = (Message)object;
                if (message.getThread() == null) {
                    object = ChatManager.this.getUserChat(message.getFrom());
                } else {
                    object = object2 = ChatManager.this.getThreadChat(message.getThread());
                    if (object2 == null) {
                        object = ChatManager.this.getUserChat(message.getFrom());
                    }
                }
                object2 = object;
                if (object == null) {
                    object2 = ChatManager.this.createChat(message);
                }
                ChatManager.this.deliverMessage((Chat)object2, message);
            }
        }, packetFilter);
    }

    private Chat createChat(String object, String string2, boolean bl) {
        Chat chat = new Chat(this, (String)object, string2);
        this.threadChats.put(string2, chat);
        this.jidChats.put((String)object, chat);
        object = this.chatManagerListeners.iterator();
        while (object.hasNext()) {
            ((ChatManagerListener)object.next()).chatCreated(chat, bl);
        }
        return chat;
    }

    private Chat createChat(Message message) {
        String string2;
        String string3 = string2 = message.getThread();
        if (string2 == null) {
            string3 = ChatManager.nextID();
        }
        return this.createChat(message.getFrom(), string3, false);
    }

    private void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    private Chat getUserChat(String string2) {
        return this.jidChats.get(string2);
    }

    private static String nextID() {
        synchronized (ChatManager.class) {
            CharSequence charSequence = new StringBuilder(String.valueOf(prefix));
            long l2 = id;
            id = 1L + l2;
            charSequence = charSequence.append(Long.toString(l2)).toString();
            return charSequence;
        }
    }

    public void addChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.add(chatManagerListener);
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor) {
        this.addOutgoingMessageInterceptor(packetInterceptor, null);
    }

    public void addOutgoingMessageInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (packetInterceptor != null) {
            this.interceptors.put(packetInterceptor, packetFilter);
        }
    }

    public Chat createChat(String object, String string2, MessageListener messageListener) {
        String string3 = string2;
        if (string2 == null) {
            string3 = ChatManager.nextID();
        }
        if (this.threadChats.get(string3) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        object = this.createChat((String)object, string3, true);
        ((Chat)object).addMessageListener(messageListener);
        return object;
    }

    public Chat createChat(String string2, MessageListener messageListener) {
        String string3;
        while (this.threadChats.get(string3 = ChatManager.nextID()) != null) {
        }
        return this.createChat(string2, string3, messageListener);
    }

    PacketCollector createPacketCollector(Chat chat) {
        return this.connection.createPacketCollector(new AndFilter(new ThreadFilter(chat.getThreadID()), new FromContainsFilter(chat.getParticipant())));
    }

    public Collection<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableCollection(this.chatManagerListeners);
    }

    public Chat getThreadChat(String string2) {
        return this.threadChats.get(string2);
    }

    public void removeChatListener(ChatManagerListener chatManagerListener) {
        this.chatManagerListeners.remove(chatManagerListener);
    }

    void sendMessage(Chat object, Message message) {
        object = this.interceptors.entrySet().iterator();
        while (true) {
            if (!object.hasNext()) {
                if (message.getFrom() == null) {
                    message.setFrom(this.connection.getUser());
                }
                this.connection.sendPacket(message);
                return;
            }
            Map.Entry entry = (Map.Entry)object.next();
            PacketFilter packetFilter = (PacketFilter)entry.getValue();
            if (packetFilter == null || !packetFilter.accept(message)) continue;
            ((PacketInterceptor)entry.getKey()).interceptPacket(message);
        }
    }
}

