/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;

public class Chat {
    private ChatManager chatManager;
    private final Set<MessageListener> listeners = new CopyOnWriteArraySet<MessageListener>();
    private String participant;
    private String threadID;

    Chat(ChatManager chatManager, String string2, String string3) {
        this.chatManager = chatManager;
        this.participant = string2;
        this.threadID = string3;
    }

    public void addMessageListener(MessageListener messageListener) {
        if (messageListener == null) {
            return;
        }
        this.listeners.add(messageListener);
    }

    public PacketCollector createCollector() {
        return this.chatManager.createPacketCollector(this);
    }

    void deliver(Message message) {
        message.setThread(this.threadID);
        Iterator<MessageListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().processMessage(this, message);
        }
        return;
    }

    public boolean equals(Object object) {
        return object instanceof Chat && this.threadID.equals(((Chat)object).getThreadID()) && this.participant.equals(((Chat)object).getParticipant());
    }

    public Collection<MessageListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public String getParticipant() {
        return this.participant;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.listeners.remove(messageListener);
    }

    public void sendMessage(String string2) throws XMPPException {
        Message message = new Message(this.participant, Message.Type.chat);
        message.setThread(this.threadID);
        message.setBody(string2);
        this.chatManager.sendMessage(this, message);
    }

    public void sendMessage(Message message) throws XMPPException {
        message.setTo(this.participant);
        message.setType(Message.Type.chat);
        message.setThread(this.threadID);
        this.chatManager.sendMessage(this, message);
    }
}

