/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;

public class AccountManager {
    private boolean accountCreationSupported = false;
    private Connection connection;
    private Registration info = null;

    public AccountManager(Connection connection) {
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getRegistrationInfo() throws XMPPException {
        synchronized (this) {
            IQ iQ = new Registration();
            iQ.setTo(this.connection.getServiceName());
            Object object = new AndFilter(new PacketIDFilter(iQ.getPacketID()), new PacketTypeFilter(IQ.class));
            object = this.connection.createPacketCollector((PacketFilter)object);
            this.connection.sendPacket(iQ);
            iQ = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
            ((PacketCollector)object).cancel();
            if (iQ == null) {
                throw new XMPPException("No response from server.");
            }
            if (iQ.getType() == IQ.Type.ERROR) {
                throw new XMPPException(iQ.getError());
            }
            this.info = (Registration)iQ;
            return;
        }
    }

    public void changePassword(String object) throws XMPPException {
        IQ iQ = new Registration();
        iQ.setType(IQ.Type.SET);
        iQ.setTo(this.connection.getServiceName());
        ((Registration)iQ).setUsername(StringUtils.parseName(this.connection.getUser()));
        ((Registration)iQ).setPassword((String)object);
        object = new AndFilter(new PacketIDFilter(iQ.getPacketID()), new PacketTypeFilter(IQ.class));
        object = this.connection.createPacketCollector((PacketFilter)object);
        this.connection.sendPacket(iQ);
        iQ = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
        ((PacketCollector)object).cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    public void createAccount(String string2, String string3) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator<String> iterator = this.getAccountAttributes().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.createAccount(string2, string3, hashMap);
                return;
            }
            hashMap.put(iterator.next(), "");
        }
    }

    public void createAccount(String object, String object2, Map<String, String> map) throws XMPPException {
        if (!this.supportsAccountCreation()) {
            throw new XMPPException("Server does not support account creation.");
        }
        Registration registration = new Registration();
        registration.setType(IQ.Type.SET);
        registration.setTo(this.connection.getServiceName());
        registration.setUsername((String)object);
        registration.setPassword((String)object2);
        object = map.keySet().iterator();
        while (true) {
            if (!object.hasNext()) {
                object = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
                object = this.connection.createPacketCollector((PacketFilter)object);
                this.connection.sendPacket(registration);
                object2 = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
                ((PacketCollector)object).cancel();
                if (object2 != null) break;
                throw new XMPPException("No response from server.");
            }
            object2 = (String)object.next();
            registration.addAttribute((String)object2, map.get(object2));
        }
        if (((IQ)object2).getType() == IQ.Type.ERROR) {
            throw new XMPPException(((Packet)object2).getError());
        }
    }

    public void deleteAccount() throws XMPPException {
        if (!this.connection.isAuthenticated()) {
            throw new IllegalStateException("Must be logged in to delete a account.");
        }
        IQ iQ = new Registration();
        iQ.setType(IQ.Type.SET);
        iQ.setTo(this.connection.getServiceName());
        ((Registration)iQ).setRemove(true);
        Object object = new AndFilter(new PacketIDFilter(iQ.getPacketID()), new PacketTypeFilter(IQ.class));
        object = this.connection.createPacketCollector((PacketFilter)object);
        this.connection.sendPacket(iQ);
        iQ = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
        ((PacketCollector)object).cancel();
        if (iQ == null) {
            throw new XMPPException("No response from server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
    }

    public String getAccountAttribute(String string2) {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            string2 = this.info.getAttributes().get(string2);
            return string2;
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
            return null;
        }
    }

    public Collection<String> getAccountAttributes() {
        try {
            Collection<String> collection;
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            if ((collection = this.info.getRequiredFields()).size() > 0) {
                collection = Collections.unmodifiableSet(new HashSet<String>(collection));
                return collection;
            }
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return Collections.emptySet();
    }

    public String getAccountInstructions() {
        try {
            if (this.info == null) {
                this.getRegistrationInfo();
            }
            String string2 = this.info.getInstructions();
            return string2;
        }
        catch (XMPPException xMPPException) {
            return null;
        }
    }

    void setSupportsAccountCreation(boolean bl) {
        this.accountCreationSupported = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean supportsAccountCreation() {
        boolean bl = true;
        if (this.accountCreationSupported) {
            return true;
        }
        try {
            if (this.info != null) return this.accountCreationSupported;
            this.getRegistrationInfo();
            if (this.info.getType() == IQ.Type.ERROR) {
                bl = false;
            }
            this.accountCreationSupported = bl;
            return this.accountCreationSupported;
        }
        catch (XMPPException xMPPException) {
            return false;
        }
    }
}

