/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.plugin;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.util.Log;

public class PluginWrapper {
    private static final String TAG = "PluginWrapper";
    protected static Context sContext = null;
    protected static GLSurfaceView sGLSurfaceView = null;
    protected static Handler sMainThreadHandler = null;

    public static Context getContext() {
        return sContext;
    }

    protected static int getPluginType(Object object) {
        try {
            int n2 = (Integer)object.getClass().getField("PluginType").get(object);
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static void init(Context context) {
        sContext = context;
        if (sMainThreadHandler == null) {
            sMainThreadHandler = new Handler();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Object initPlugin(String string2) {
        Class<?> clazz;
        Log.i((String)TAG, (String)("class name : ----" + string2 + "----"));
        try {
            clazz = Class.forName(string2.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)TAG, (String)("Class " + string2 + " not found."));
            classNotFoundException.printStackTrace();
            return null;
        }
        try {}
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Context context = PluginWrapper.getContext();
        if (context != null) {
            return clazz.getDeclaredConstructor(Context.class).newInstance(context);
        }
        Log.e((String)TAG, (String)("Plugin " + string2 + " wasn't initialized."));
        return null;
    }

    public static void runOnGLThread(Runnable runnable) {
        if (sGLSurfaceView != null) {
            sGLSurfaceView.queueEvent(runnable);
            return;
        }
        Log.i((String)TAG, (String)"runOnGLThread sGLSurfaceView is null");
        runnable.run();
    }

    public static void runOnMainThread(Runnable runnable) {
        if (sMainThreadHandler == null) {
            return;
        }
        sMainThreadHandler.post(runnable);
    }

    public static void setGLSurfaceView(GLSurfaceView gLSurfaceView) {
        sGLSurfaceView = gLSurfaceView;
    }
}

