/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.chukong.cocosplay.client.CocosPlayClient;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.cocos2dx.lib.Cocos2dxActivity;
import org.cocos2dx.lib.Cocos2dxWebView;

public class Cocos2dxWebViewHelper {
    private static final String TAG = Cocos2dxWebViewHelper.class.getSimpleName();
    private static Cocos2dxActivity sCocos2dxActivity;
    private static Handler sHandler;
    private static FrameLayout sLayout;
    private static int viewTag;
    private static SparseArray<Cocos2dxWebView> webViews;

    static {
        viewTag = 0;
    }

    public Cocos2dxWebViewHelper(FrameLayout frameLayout) {
        sLayout = frameLayout;
        sHandler = new Handler(Looper.myLooper());
        sCocos2dxActivity = (Cocos2dxActivity)Cocos2dxActivity.getContext();
        webViews = new SparseArray();
    }

    public static void _didFailLoading(int n2, String string2) {
        Cocos2dxWebViewHelper.didFailLoading(n2, string2);
    }

    public static void _didFinishLoading(int n2, String string2) {
        Cocos2dxWebViewHelper.didFinishLoading(n2, string2);
    }

    public static void _onJsCallback(int n2, String string2) {
        Cocos2dxWebViewHelper.onJsCallback(n2, string2);
    }

    public static boolean _shouldStartLoading(int n2, String string2) {
        return !Cocos2dxWebViewHelper.shouldStartLoading(n2, string2);
    }

    public static <T> T callInMainThread(Callable<T> object) throws ExecutionException, InterruptedException {
        object = new FutureTask<T>(object);
        sHandler.post((Runnable)object);
        return (T)((FutureTask)object).get();
    }

    public static boolean canGoBack(final int n2) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                boolean bl;
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null && cocos2dxWebView.canGoBack()) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        };
        try {
            boolean bl = Cocos2dxWebViewHelper.callInMainThread(callable);
            return bl;
        }
        catch (ExecutionException executionException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public static boolean canGoForward(final int n2) {
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Boolean call() throws Exception {
                boolean bl;
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null && cocos2dxWebView.canGoForward()) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        };
        try {
            boolean bl = Cocos2dxWebViewHelper.callInMainThread(callable);
            return bl;
        }
        catch (ExecutionException executionException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public static int createWebView() {
        final int n2 = viewTag;
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = new Cocos2dxWebView((Context)sCocos2dxActivity, n2);
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                sLayout.addView((View)cocos2dxWebView, (ViewGroup.LayoutParams)layoutParams);
                webViews.put(n2, (Object)cocos2dxWebView);
            }
        });
        n2 = viewTag;
        viewTag = n2 + 1;
        return n2;
    }

    private static native void didFailLoading(int var0, String var1);

    private static native void didFinishLoading(int var0, String var1);

    public static void evaluateJS(final int n2, final String string2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.loadUrl("javascript:" + string2);
                }
            }
        });
    }

    public static void goBack(final int n2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.goBack();
                }
            }
        });
    }

    public static void goForward(final int n2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.goForward();
                }
            }
        });
    }

    public static void loadData(final int n2, final String string2, final String string3, final String string4, final String string5) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.loadDataWithBaseURL(string5, string2, string3, string4, null);
                }
            }
        });
    }

    public static void loadFile(final int n2, final String string2) {
        if (CocosPlayClient.isEnabled() && !CocosPlayClient.isDemo()) {
            CocosPlayClient.updateAssets(string2);
        }
        CocosPlayClient.notifyFileLoaded(string2);
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.loadUrl(string2);
                }
            }
        });
    }

    public static void loadHTMLString(final int n2, final String string2, final String string3) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.loadDataWithBaseURL(string3, string2, null, null, null);
                }
            }
        });
    }

    public static void loadUrl(final int n2, final String string2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.loadUrl(string2);
                }
            }
        });
    }

    private static native void onJsCallback(int var0, String var1);

    public static void reload(final int n2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.reload();
                }
            }
        });
    }

    public static void removeWebView(final int n2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    webViews.remove(n2);
                    sLayout.removeView((View)cocos2dxWebView);
                }
            }
        });
    }

    public static void setJavascriptInterfaceScheme(final int n2, final String string2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.setJavascriptInterfaceScheme(string2);
                }
            }
        });
    }

    public static void setScalesPageToFit(final int n2, final boolean bl) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.setScalesPageToFit(bl);
                }
            }
        });
    }

    public static void setVisible(final int n2, final boolean bl) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    int n22 = bl ? 0 : 8;
                    cocos2dxWebView.setVisibility(n22);
                }
            }
        });
    }

    public static void setWebViewRect(final int n2, final int n3, final int n4, final int n5, final int n6) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.setWebViewRect(n3, n4, n5, n6);
                }
            }
        });
    }

    private static native boolean shouldStartLoading(int var0, String var1);

    public static void stopLoading(final int n2) {
        sCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxWebView cocos2dxWebView = (Cocos2dxWebView)((Object)webViews.get(n2));
                if (cocos2dxWebView != null) {
                    cocos2dxWebView.stopLoading();
                }
            }
        });
    }
}

