/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import com.chukong.cocosplay.client.CocosPlayClient;
import java.io.IOException;
import java.util.Map;
import org.cocos2dx.lib.Cocos2dxActivity;

public class Cocos2dxVideoView
extends SurfaceView
implements MediaController.MediaPlayerControl {
    private static final String AssetResourceRoot = "assets/";
    private static final int EVENT_COMPLETED = 3;
    private static final int EVENT_PAUSED = 1;
    private static final int EVENT_PLAYING = 0;
    private static final int EVENT_STOPPED = 2;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PREPARING = 1;
    private String TAG = "Cocos2dxVideoView";
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener;
    protected Cocos2dxActivity mCocos2dxActivity = null;
    private MediaPlayer.OnCompletionListener mCompletionListener;
    private int mCurrentBufferPercentage;
    private int mCurrentState = 0;
    private int mDuration;
    private MediaPlayer.OnErrorListener mErrorListener;
    protected boolean mFullScreenEnabled = false;
    protected int mFullScreenHeight = 0;
    protected int mFullScreenWidth = 0;
    private boolean mIsAssetRouse = false;
    private boolean mKeepRatio = false;
    private MediaPlayer mMediaPlayer = null;
    private boolean mNeedResume = false;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private OnVideoEventListener mOnVideoEventListener;
    MediaPlayer.OnPreparedListener mPreparedListener;
    SurfaceHolder.Callback mSHCallback;
    private int mSeekWhenPrepared;
    protected MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n2, int n3) {
            Cocos2dxVideoView.access$002(Cocos2dxVideoView.this, mediaPlayer.getVideoWidth());
            Cocos2dxVideoView.access$102(Cocos2dxVideoView.this, mediaPlayer.getVideoHeight());
            if (Cocos2dxVideoView.this.mVideoWidth != 0 && Cocos2dxVideoView.this.mVideoHeight != 0) {
                Cocos2dxVideoView.this.getHolder().setFixedSize(Cocos2dxVideoView.this.mVideoWidth, Cocos2dxVideoView.this.mVideoHeight);
            }
        }
    };
    private SurfaceHolder mSurfaceHolder = null;
    private int mTargetState = 0;
    private String mVideoFilePath = null;
    private int mVideoHeight = 0;
    private Uri mVideoUri;
    private int mVideoWidth = 0;
    protected int mViewHeight = 0;
    protected int mViewLeft = 0;
    private int mViewTag = 0;
    protected int mViewTop = 0;
    protected int mViewWidth = 0;
    protected int mVisibleHeight = 0;
    protected int mVisibleLeft = 0;
    protected int mVisibleTop = 0;
    protected int mVisibleWidth = 0;

    public Cocos2dxVideoView(Cocos2dxActivity cocos2dxActivity, int n2) {
        super((Context)cocos2dxActivity);
        this.mPreparedListener = new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                Cocos2dxVideoView.access$202(Cocos2dxVideoView.this, 2);
                if (Cocos2dxVideoView.this.mOnPreparedListener != null) {
                    Cocos2dxVideoView.this.mOnPreparedListener.onPrepared(Cocos2dxVideoView.this.mMediaPlayer);
                }
                Cocos2dxVideoView.access$002(Cocos2dxVideoView.this, mediaPlayer.getVideoWidth());
                Cocos2dxVideoView.access$102(Cocos2dxVideoView.this, mediaPlayer.getVideoHeight());
                int n2 = Cocos2dxVideoView.this.mSeekWhenPrepared;
                if (n2 != 0) {
                    Cocos2dxVideoView.this.seekTo(n2);
                }
                if (Cocos2dxVideoView.this.mVideoWidth != 0 && Cocos2dxVideoView.this.mVideoHeight != 0) {
                    Cocos2dxVideoView.this.fixSize();
                }
                if (Cocos2dxVideoView.this.mTargetState == 3) {
                    Cocos2dxVideoView.this.start();
                }
            }
        };
        this.mCompletionListener = new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                Cocos2dxVideoView.access$202(Cocos2dxVideoView.this, 5);
                Cocos2dxVideoView.access$602(Cocos2dxVideoView.this, 5);
                Cocos2dxVideoView.this.release(true);
                if (Cocos2dxVideoView.this.mOnVideoEventListener != null) {
                    Cocos2dxVideoView.this.mOnVideoEventListener.onVideoEvent(Cocos2dxVideoView.this.mViewTag, 3);
                }
            }
        };
        this.mErrorListener = new MediaPlayer.OnErrorListener(){

            /*
             * Enabled aggressive block sorting
             */
            public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                Log.d((String)Cocos2dxVideoView.this.TAG, (String)("Error: " + n2 + "," + n3));
                Cocos2dxVideoView.access$202(Cocos2dxVideoView.this, -1);
                Cocos2dxVideoView.access$602(Cocos2dxVideoView.this, -1);
                if (Cocos2dxVideoView.this.mOnErrorListener != null && Cocos2dxVideoView.this.mOnErrorListener.onError(Cocos2dxVideoView.this.mMediaPlayer, n2, n3) || Cocos2dxVideoView.this.getWindowToken() == null) {
                    return true;
                }
                mediaPlayer = Cocos2dxVideoView.this.mCocos2dxActivity.getResources();
                n2 = n2 == 200 ? mediaPlayer.getIdentifier("VideoView_error_text_invalid_progressive_playback", "string", "android") : mediaPlayer.getIdentifier("VideoView_error_text_unknown", "string", "android");
                n3 = mediaPlayer.getIdentifier("VideoView_error_title", "string", "android");
                int n4 = mediaPlayer.getIdentifier("VideoView_error_button", "string", "android");
                new AlertDialog.Builder((Context)Cocos2dxVideoView.this.mCocos2dxActivity).setTitle((CharSequence)mediaPlayer.getString(n3)).setMessage(n2).setPositiveButton((CharSequence)mediaPlayer.getString(n4), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n2) {
                        if (Cocos2dxVideoView.this.mOnVideoEventListener != null) {
                            Cocos2dxVideoView.this.mOnVideoEventListener.onVideoEvent(Cocos2dxVideoView.this.mViewTag, 3);
                        }
                    }
                }).setCancelable(false).show();
                return true;
            }
        };
        this.mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

            public void onBufferingUpdate(MediaPlayer mediaPlayer, int n2) {
                Cocos2dxVideoView.access$1202(Cocos2dxVideoView.this, n2);
            }
        };
        this.mSHCallback = new SurfaceHolder.Callback(){

            /*
             * Enabled aggressive block sorting
             */
            public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
                n2 = Cocos2dxVideoView.this.mTargetState == 3 ? 1 : 0;
                n3 = Cocos2dxVideoView.this.mVideoWidth == n3 && Cocos2dxVideoView.this.mVideoHeight == n4 ? 1 : 0;
                if (Cocos2dxVideoView.this.mMediaPlayer != null && n2 != 0 && n3 != 0) {
                    if (Cocos2dxVideoView.this.mSeekWhenPrepared != 0) {
                        Cocos2dxVideoView.this.seekTo(Cocos2dxVideoView.this.mSeekWhenPrepared);
                    }
                    Cocos2dxVideoView.this.start();
                }
            }

            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                Cocos2dxVideoView.access$1302(Cocos2dxVideoView.this, surfaceHolder);
                Cocos2dxVideoView.this.openVideo();
            }

            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                Cocos2dxVideoView.access$1302(Cocos2dxVideoView.this, null);
                Cocos2dxVideoView.this.release(true);
            }
        };
        this.mViewTag = n2;
        this.mCocos2dxActivity = cocos2dxActivity;
        this.initVideoView();
    }

    static /* synthetic */ int access$002(Cocos2dxVideoView cocos2dxVideoView, int n2) {
        cocos2dxVideoView.mVideoWidth = n2;
        return n2;
    }

    static /* synthetic */ int access$102(Cocos2dxVideoView cocos2dxVideoView, int n2) {
        cocos2dxVideoView.mVideoHeight = n2;
        return n2;
    }

    static /* synthetic */ int access$1202(Cocos2dxVideoView cocos2dxVideoView, int n2) {
        cocos2dxVideoView.mCurrentBufferPercentage = n2;
        return n2;
    }

    static /* synthetic */ SurfaceHolder access$1302(Cocos2dxVideoView cocos2dxVideoView, SurfaceHolder surfaceHolder) {
        cocos2dxVideoView.mSurfaceHolder = surfaceHolder;
        return surfaceHolder;
    }

    static /* synthetic */ int access$202(Cocos2dxVideoView cocos2dxVideoView, int n2) {
        cocos2dxVideoView.mCurrentState = n2;
        return n2;
    }

    static /* synthetic */ int access$602(Cocos2dxVideoView cocos2dxVideoView, int n2) {
        cocos2dxVideoView.mTargetState = n2;
        return n2;
    }

    private void initVideoView() {
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().addCallback(this.mSHCallback);
        this.getHolder().setType(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mCurrentState = 0;
        this.mTargetState = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openVideo() {
        block11: {
            block10: {
                block9: {
                    if (this.mSurfaceHolder == null) break block9;
                    if (!this.mIsAssetRouse) break block10;
                    if (this.mVideoFilePath != null) break block11;
                }
                return;
            }
            if (this.mVideoUri == null) {
                return;
            }
        }
        Intent intent = new Intent("com.android.music.musicservicecommand");
        intent.putExtra("command", "pause");
        this.mCocos2dxActivity.sendBroadcast(intent);
        this.release(false);
        try {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mDuration = -1;
            this.mCurrentBufferPercentage = 0;
            if (this.mIsAssetRouse) {
                intent = this.mCocos2dxActivity.getAssets().openFd(this.mVideoFilePath);
                this.mMediaPlayer.setDataSource(intent.getFileDescriptor(), intent.getStartOffset(), intent.getLength());
            } else {
                this.mMediaPlayer.setDataSource((Context)this.mCocos2dxActivity, this.mVideoUri);
            }
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            return;
        }
        catch (IOException iOException) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mVideoUri), (Throwable)iOException);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)this.TAG, (String)("Unable to open content: " + this.mVideoUri), (Throwable)illegalArgumentException);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
    }

    private void release(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            if (bl) {
                this.mTargetState = 0;
            }
        }
    }

    private void setVideoURI(Uri uri, Map<String, String> map) {
        this.mVideoUri = uri;
        this.mSeekWhenPrepared = 0;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return true;
    }

    public boolean canSeekForward() {
        return true;
    }

    public void fixSize() {
        if (this.mFullScreenEnabled) {
            this.fixSize(0, 0, this.mFullScreenWidth, this.mFullScreenHeight);
            return;
        }
        this.fixSize(this.mViewLeft, this.mViewTop, this.mViewWidth, this.mViewHeight);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fixSize(int n2, int n3, int n4, int n5) {
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            this.mVisibleLeft = n2;
            this.mVisibleTop = n3;
            this.mVisibleWidth = n4;
            this.mVisibleHeight = n5;
        } else if (n4 != 0 && n5 != 0) {
            if (this.mKeepRatio) {
                if (this.mVideoWidth * n5 > this.mVideoHeight * n4) {
                    this.mVisibleWidth = n4;
                    this.mVisibleHeight = this.mVideoHeight * n4 / this.mVideoWidth;
                } else if (this.mVideoWidth * n5 < this.mVideoHeight * n4) {
                    this.mVisibleWidth = this.mVideoWidth * n5 / this.mVideoHeight;
                    this.mVisibleHeight = n5;
                }
                this.mVisibleLeft = (n4 - this.mVisibleWidth) / 2 + n2;
                this.mVisibleTop = (n5 - this.mVisibleHeight) / 2 + n3;
            } else {
                this.mVisibleLeft = n2;
                this.mVisibleTop = n3;
                this.mVisibleWidth = n4;
                this.mVisibleHeight = n5;
            }
        } else {
            this.mVisibleLeft = n2;
            this.mVisibleTop = n3;
            this.mVisibleWidth = this.mVideoWidth;
            this.mVisibleHeight = this.mVideoHeight;
        }
        this.getHolder().setFixedSize(this.mVisibleWidth, this.mVisibleHeight);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = this.mVisibleLeft;
        layoutParams.topMargin = this.mVisibleTop;
        layoutParams.gravity = 51;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public int getAudioSessionId() {
        return this.mMediaPlayer.getAudioSessionId();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            if (this.mDuration > 0) {
                return this.mDuration;
            }
            this.mDuration = this.mMediaPlayer.getDuration();
            return this.mDuration;
        }
        this.mDuration = -1;
        return this.mDuration;
    }

    public boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    protected void onMeasure(int n2, int n3) {
        if (this.mVideoWidth == 0 || this.mVideoHeight == 0) {
            this.setMeasuredDimension(this.mViewWidth, this.mViewHeight);
            Log.i((String)this.TAG, (String)("" + this.mViewWidth + ":" + this.mViewHeight));
            return;
        }
        this.setMeasuredDimension(this.mVisibleWidth, this.mVisibleHeight);
        Log.i((String)this.TAG, (String)("" + this.mVisibleWidth + ":" + this.mVisibleHeight));
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if ((motionEvent.getAction() & 0xFF) != 1) return true;
        if (this.isPlaying()) {
            this.pause();
            return true;
        } else {
            if (this.mCurrentState != 4) return true;
            this.resume();
            return true;
        }
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
            if (this.mOnVideoEventListener != null) {
                this.mOnVideoEventListener.onVideoEvent(this.mViewTag, 1);
            }
        }
        this.mTargetState = 4;
    }

    public int resolveAdjustedSize(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n3);
        n3 = View.MeasureSpec.getSize((int)n3);
        switch (n4) {
            default: {
                return n2;
            }
            case 0: {
                return n2;
            }
            case -2147483648: {
                return Math.min(n2, n3);
            }
            case 0x40000000: 
        }
        return n3;
    }

    public void restart() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(0);
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            this.mTargetState = 3;
        }
    }

    public void resume() {
        if (this.isInPlaybackState() && this.mCurrentState == 4) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            if (this.mOnVideoEventListener != null) {
                this.mOnVideoEventListener.onVideoEvent(this.mViewTag, 0);
            }
        }
    }

    public void seekTo(int n2) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(n2);
            this.mSeekWhenPrepared = 0;
            return;
        }
        this.mSeekWhenPrepared = n2;
    }

    public void setFullScreenEnabled(boolean bl, int n2, int n3) {
        if (this.mFullScreenEnabled != bl) {
            this.mFullScreenEnabled = bl;
            if (n2 != 0 && n3 != 0) {
                this.mFullScreenWidth = n2;
                this.mFullScreenHeight = n3;
            }
            this.fixSize();
        }
    }

    public void setKeepRatio(boolean bl) {
        this.mKeepRatio = bl;
        this.fixSize();
    }

    public void setOnCompletionListener(OnVideoEventListener onVideoEventListener) {
        this.mOnVideoEventListener = onVideoEventListener;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setVideoFileName(String string2) {
        String string3 = string2;
        if (string2.startsWith(AssetResourceRoot)) {
            string3 = string2.substring(AssetResourceRoot.length());
        }
        if (CocosPlayClient.isEnabled() && !CocosPlayClient.isDemo()) {
            CocosPlayClient.updateAssets(string3);
        }
        CocosPlayClient.notifyFileLoaded(string3);
        if (string3.startsWith("/")) {
            this.mIsAssetRouse = false;
            this.setVideoURI(Uri.parse((String)string3), null);
            return;
        }
        this.mVideoFilePath = string3;
        this.mIsAssetRouse = true;
        this.setVideoURI(Uri.parse((String)string3), null);
    }

    public void setVideoRect(int n2, int n3, int n4, int n5) {
        this.mViewLeft = n2;
        this.mViewTop = n3;
        this.mViewWidth = n4;
        this.mViewHeight = n5;
        this.fixSize(this.mViewLeft, this.mViewTop, this.mViewWidth, this.mViewHeight);
    }

    public void setVideoURL(String string2) {
        this.mIsAssetRouse = false;
        this.setVideoURI(Uri.parse((String)string2), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setVisibility(int n2) {
        if (n2 == 4) {
            this.mNeedResume = this.isPlaying();
            if (this.mNeedResume) {
                this.mSeekWhenPrepared = this.getCurrentPosition();
            }
        } else if (this.mNeedResume) {
            this.start();
            this.mNeedResume = false;
        }
        super.setVisibility(n2);
    }

    public void start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
            if (this.mOnVideoEventListener != null) {
                this.mOnVideoEventListener.onVideoEvent(this.mViewTag, 0);
            }
        }
        this.mTargetState = 3;
    }

    public void stop() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.stopPlayback();
            if (this.mOnVideoEventListener != null) {
                this.mOnVideoEventListener.onVideoEvent(this.mViewTag, 2);
            }
        }
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
    }

    public void suspend() {
        this.release(false);
    }

    public static interface OnVideoEventListener {
        public void onVideoEvent(int var1, int var2);
    }
}

