/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.lang.ref.WeakReference;
import org.cocos2dx.lib.Cocos2dxActivity;
import org.cocos2dx.lib.Cocos2dxVideoView;

public class Cocos2dxVideoHelper {
    static final int KeyEventBack = 1000;
    private static final int VideoTaskCreate = 0;
    private static final int VideoTaskFullScreen = 12;
    private static final int VideoTaskKeepRatio = 11;
    private static final int VideoTaskPause = 5;
    private static final int VideoTaskRemove = 1;
    private static final int VideoTaskRestart = 10;
    private static final int VideoTaskResume = 6;
    private static final int VideoTaskSeek = 8;
    private static final int VideoTaskSetRect = 3;
    private static final int VideoTaskSetSource = 2;
    private static final int VideoTaskSetVisible = 9;
    private static final int VideoTaskStart = 4;
    private static final int VideoTaskStop = 7;
    static VideoHandler mVideoHandler = null;
    private static int videoTag = 0;
    private Cocos2dxActivity mActivity = null;
    private FrameLayout mLayout = null;
    private SparseArray<Cocos2dxVideoView> sVideoViews = null;
    Cocos2dxVideoView.OnVideoEventListener videoEventListener = new Cocos2dxVideoView.OnVideoEventListener(){

        @Override
        public void onVideoEvent(int n2, int n3) {
            Cocos2dxVideoHelper.this.mActivity.runOnGLThread(new VideoEventRunnable(n2, n3));
        }
    };

    Cocos2dxVideoHelper(Cocos2dxActivity cocos2dxActivity, FrameLayout frameLayout) {
        this.mActivity = cocos2dxActivity;
        this.mLayout = frameLayout;
        mVideoHandler = new VideoHandler(this);
        this.sVideoViews = new SparseArray();
    }

    private void _createVideoView(int n2) {
        Cocos2dxVideoView cocos2dxVideoView = new Cocos2dxVideoView(this.mActivity, n2);
        this.sVideoViews.put(n2, (Object)cocos2dxVideoView);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        this.mLayout.addView((View)cocos2dxVideoView, (ViewGroup.LayoutParams)layoutParams);
        cocos2dxVideoView.setZOrderOnTop(true);
        cocos2dxVideoView.setOnCompletionListener(this.videoEventListener);
    }

    private void _pauseVideo(int n2) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.pause();
        }
    }

    private void _removeVideoView(int n2) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.stopPlayback();
            this.sVideoViews.remove(n2);
            this.mLayout.removeView((View)cocos2dxVideoView);
        }
    }

    private void _restartVideo(int n2) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.restart();
        }
    }

    private void _resumeVideo(int n2) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.resume();
        }
    }

    private void _seekVideoTo(int n2, int n3) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.seekTo(n3);
        }
    }

    private void _setFullScreenEnabled(int n2, boolean bl, int n3, int n4) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.setFullScreenEnabled(bl, n3, n4);
        }
    }

    private void _setVideoKeepRatio(int n2, boolean bl) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.setKeepRatio(bl);
        }
    }

    private void _setVideoRect(int n2, int n3, int n4, int n5, int n6) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.setVideoRect(n3, n4, n5, n6);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _setVideoURL(int n2, int n3, String string2) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView == null) return;
        switch (n3) {
            default: {
                return;
            }
            case 0: {
                cocos2dxVideoView.setVideoFileName(string2);
                return;
            }
            case 1: 
        }
        cocos2dxVideoView.setVideoURL(string2);
    }

    private void _setVideoVisible(int n2, boolean bl) {
        Cocos2dxVideoView cocos2dxVideoView;
        block3: {
            block2: {
                cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
                if (cocos2dxVideoView == null) break block2;
                if (!bl) break block3;
                cocos2dxVideoView.fixSize();
                cocos2dxVideoView.setVisibility(0);
            }
            return;
        }
        cocos2dxVideoView.setVisibility(4);
    }

    private void _startVideo(int n2) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.start();
        }
    }

    private void _stopVideo(int n2) {
        Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n2));
        if (cocos2dxVideoView != null) {
            cocos2dxVideoView.stop();
        }
    }

    public static int createVideoWidget() {
        Message message = new Message();
        message.what = 0;
        message.arg1 = videoTag;
        mVideoHandler.sendMessage(message);
        int n2 = videoTag;
        videoTag = n2 + 1;
        return n2;
    }

    public static native void nativeExecuteVideoCallback(int var0, int var1);

    private void onBackKeyEvent() {
        int n2 = this.sVideoViews.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.sVideoViews.keyAt(i2);
            Cocos2dxVideoView cocos2dxVideoView = (Cocos2dxVideoView)((Object)this.sVideoViews.get(n3));
            if (cocos2dxVideoView == null) continue;
            cocos2dxVideoView.setFullScreenEnabled(false, 0, 0);
            this.mActivity.runOnGLThread(new VideoEventRunnable(n3, 1000));
        }
    }

    public static void pauseVideo(int n2) {
        Message message = new Message();
        message.what = 5;
        message.arg1 = n2;
        mVideoHandler.sendMessage(message);
    }

    public static void removeVideoWidget(int n2) {
        Message message = new Message();
        message.what = 1;
        message.arg1 = n2;
        mVideoHandler.sendMessage(message);
    }

    public static void restartVideo(int n2) {
        Message message = new Message();
        message.what = 10;
        message.arg1 = n2;
        mVideoHandler.sendMessage(message);
    }

    public static void resumeVideo(int n2) {
        Message message = new Message();
        message.what = 6;
        message.arg1 = n2;
        mVideoHandler.sendMessage(message);
    }

    public static void seekVideoTo(int n2, int n3) {
        Message message = new Message();
        message.what = 8;
        message.arg1 = n2;
        message.arg2 = n3;
        mVideoHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setFullScreenEnabled(int n2, boolean bl, int n3, int n4) {
        Message message = new Message();
        message.what = 12;
        message.arg1 = n2;
        message.arg2 = bl ? 1 : 0;
        message.obj = new Rect(0, 0, n3, n4);
        mVideoHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setVideoKeepRatioEnabled(int n2, boolean bl) {
        Message message = new Message();
        message.what = 11;
        message.arg1 = n2;
        message.arg2 = bl ? 1 : 0;
        mVideoHandler.sendMessage(message);
    }

    public static void setVideoRect(int n2, int n3, int n4, int n5, int n6) {
        Message message = new Message();
        message.what = 3;
        message.arg1 = n2;
        message.obj = new Rect(n3, n4, n5, n6);
        mVideoHandler.sendMessage(message);
    }

    public static void setVideoUrl(int n2, int n3, String string2) {
        Message message = new Message();
        message.what = 2;
        message.arg1 = n2;
        message.arg2 = n3;
        message.obj = string2;
        mVideoHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setVideoVisible(int n2, boolean bl) {
        Message message = new Message();
        message.what = 9;
        message.arg1 = n2;
        message.arg2 = bl ? 1 : 0;
        mVideoHandler.sendMessage(message);
    }

    public static void startVideo(int n2) {
        Message message = new Message();
        message.what = 4;
        message.arg1 = n2;
        mVideoHandler.sendMessage(message);
    }

    public static void stopVideo(int n2) {
        Message message = new Message();
        message.what = 7;
        message.arg1 = n2;
        mVideoHandler.sendMessage(message);
    }

    private class VideoEventRunnable
    implements Runnable {
        private int mVideoEvent;
        private int mVideoTag;

        public VideoEventRunnable(int n2, int n3) {
            this.mVideoTag = n2;
            this.mVideoEvent = n3;
        }

        @Override
        public void run() {
            Cocos2dxVideoHelper.nativeExecuteVideoCallback(this.mVideoTag, this.mVideoEvent);
        }
    }

    static class VideoHandler
    extends Handler {
        WeakReference<Cocos2dxVideoHelper> mReference;

        VideoHandler(Cocos2dxVideoHelper cocos2dxVideoHelper) {
            this.mReference = new WeakReference<Cocos2dxVideoHelper>(cocos2dxVideoHelper);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._createVideoView(message.arg1);
                    break;
                }
                case 1: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._removeVideoView(message.arg1);
                    break;
                }
                case 2: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._setVideoURL(message.arg1, message.arg2, (String)message.obj);
                    break;
                }
                case 4: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._startVideo(message.arg1);
                    break;
                }
                case 3: {
                    Cocos2dxVideoHelper cocos2dxVideoHelper = (Cocos2dxVideoHelper)this.mReference.get();
                    Rect rect = (Rect)message.obj;
                    cocos2dxVideoHelper._setVideoRect(message.arg1, rect.left, rect.top, rect.right, rect.bottom);
                    break;
                }
                case 12: {
                    Cocos2dxVideoHelper cocos2dxVideoHelper = (Cocos2dxVideoHelper)this.mReference.get();
                    Rect rect = (Rect)message.obj;
                    if (message.arg2 == 1) {
                        cocos2dxVideoHelper._setFullScreenEnabled(message.arg1, true, rect.right, rect.bottom);
                        break;
                    }
                    cocos2dxVideoHelper._setFullScreenEnabled(message.arg1, false, rect.right, rect.bottom);
                    break;
                }
                case 5: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._pauseVideo(message.arg1);
                    break;
                }
                case 6: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._resumeVideo(message.arg1);
                    break;
                }
                case 7: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._stopVideo(message.arg1);
                    break;
                }
                case 8: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._seekVideoTo(message.arg1, message.arg2);
                    break;
                }
                case 9: {
                    Cocos2dxVideoHelper cocos2dxVideoHelper = (Cocos2dxVideoHelper)this.mReference.get();
                    if (message.arg2 == 1) {
                        cocos2dxVideoHelper._setVideoVisible(message.arg1, true);
                        break;
                    }
                    cocos2dxVideoHelper._setVideoVisible(message.arg1, false);
                    break;
                }
                case 10: {
                    ((Cocos2dxVideoHelper)this.mReference.get())._restartVideo(message.arg1);
                    break;
                }
                case 11: {
                    Cocos2dxVideoHelper cocos2dxVideoHelper = (Cocos2dxVideoHelper)this.mReference.get();
                    if (message.arg2 == 1) {
                        cocos2dxVideoHelper._setVideoKeepRatio(message.arg1, true);
                        break;
                    }
                    cocos2dxVideoHelper._setVideoKeepRatio(message.arg1, false);
                    break;
                }
                case 1000: {
                    ((Cocos2dxVideoHelper)this.mReference.get()).onBackKeyEvent();
                    break;
                }
            }
            super.handleMessage(message);
        }
    }
}

