/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.content.Context;
import android.media.SoundPool;
import android.util.Log;
import com.chukong.cocosplay.client.CocosPlayClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cocos2dx.lib.Cocos2dxHelper;

public class Cocos2dxSound {
    private static final int INVALID_SOUND_ID = -1;
    private static final int INVALID_STREAM_ID = -1;
    private static int LOAD_TIME_OUT = 0;
    private static final int MAX_SIMULTANEOUS_STREAMS_DEFAULT = 5;
    private static final int MAX_SIMULTANEOUS_STREAMS_I9100 = 3;
    private static final int SOUND_PRIORITY = 1;
    private static final int SOUND_QUALITY = 5;
    private static final float SOUND_RATE = 1.0f;
    private static final String TAG = "Cocos2dxSound";
    private final Context mContext;
    private float mLeftVolume;
    private final HashMap<String, Integer> mPathSoundIDMap;
    private final HashMap<String, ArrayList<Integer>> mPathStreamIDsMap = new HashMap();
    private ConcurrentHashMap<Integer, SoundInfoForLoadedCompleted> mPlayWhenLoadedEffects;
    private float mRightVolume;
    private SoundPool mSoundPool;

    static {
        LOAD_TIME_OUT = 500;
    }

    public Cocos2dxSound(Context context) {
        this.mPathSoundIDMap = new HashMap();
        this.mPlayWhenLoadedEffects = new ConcurrentHashMap();
        this.mContext = context;
        this.initData();
    }

    private float clamp(float f2, float f3, float f4) {
        return Math.max(f3, Math.min(f2, f4));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private int doPlayEffect(String string2, int n2, boolean bl, float f2, float f3, float f4) {
        void var11_13;
        ArrayList<Integer> arrayList;
        float f5 = this.mLeftVolume;
        float f6 = this.clamp(f3, 0.0f, 1.0f);
        float f7 = this.mRightVolume;
        f3 = this.clamp(-f3, 0.0f, 1.0f);
        f2 = this.clamp(1.0f * f2, 0.5f, 2.0f);
        SoundPool soundPool = this.mSoundPool;
        f5 = this.clamp(f5 * f4 * (1.0f - f6), 0.0f, 1.0f);
        f3 = this.clamp(f7 * f4 * (1.0f - f3), 0.0f, 1.0f);
        int n3 = bl ? -1 : 0;
        n2 = soundPool.play(n2, f5, f3, 1, n3, f2);
        ArrayList<Integer> arrayList2 = arrayList = this.mPathStreamIDsMap.get(string2);
        if (arrayList == null) {
            ArrayList arrayList3 = new ArrayList();
            this.mPathStreamIDsMap.put(string2, arrayList3);
        }
        var11_13.add(n2);
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initData() {
        this.mSoundPool = Cocos2dxHelper.getDeviceModel().contains("GT-I9100") ? new SoundPool(3, 3, 5) : new SoundPool(5, 3, 5);
        this.mSoundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)new OnLoadCompletedListener());
        this.mLeftVolume = 0.5f;
        this.mRightVolume = 0.5f;
    }

    public int createSoundIDFromAsset(String string2) {
        int n2;
        try {
            n2 = string2.startsWith("/") ? this.mSoundPool.load(string2, 0) : this.mSoundPool.load(this.mContext.getAssets().openFd(string2), 0);
        }
        catch (Exception exception) {
            n2 = -1;
            Log.e((String)TAG, (String)("error: " + exception.getMessage()), (Throwable)exception);
        }
        int n3 = n2;
        if (n2 == 0) {
            n3 = -1;
        }
        return n3;
    }

    public void end() {
        this.mSoundPool.release();
        this.mPathStreamIDsMap.clear();
        this.mPathSoundIDMap.clear();
        this.mPlayWhenLoadedEffects.clear();
        this.mLeftVolume = 0.5f;
        this.mRightVolume = 0.5f;
        this.initData();
    }

    public float getEffectsVolume() {
        return (this.mLeftVolume + this.mRightVolume) / 2.0f;
    }

    public void onEnterBackground() {
        this.mSoundPool.autoPause();
    }

    public void onEnterForeground() {
        this.mSoundPool.autoResume();
    }

    public void pauseAllEffects() {
        if (!this.mPathStreamIDsMap.isEmpty()) {
            Iterator<Map.Entry<String, ArrayList<Integer>>> iterator = this.mPathStreamIDsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                for (int n2 : iterator.next().getValue()) {
                    this.mSoundPool.pause(n2);
                }
            }
        }
    }

    public void pauseEffect(int n2) {
        this.mSoundPool.pause(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int playEffect(String object, boolean bl, float f2, float f3, float f4) {
        int n2 = -1;
        Integer n3 = this.mPathSoundIDMap.get(object);
        if (n3 != null) {
            return this.doPlayEffect((String)object, n3, bl, f2, f3, f4);
        }
        n3 = this.preloadEffect((String)object);
        if (n3 == -1) return n2;
        object = new SoundInfoForLoadedCompleted((String)object, bl, f2, f3, f4);
        this.mPlayWhenLoadedEffects.putIfAbsent(n3, (SoundInfoForLoadedCompleted)object);
        synchronized (object) {
            try {
                object.wait(LOAD_TIME_OUT);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        n2 = ((SoundInfoForLoadedCompleted)object).effectID;
        this.mPlayWhenLoadedEffects.remove(n3);
        return n2;
    }

    public int preloadEffect(String string2) {
        Integer n2;
        if (CocosPlayClient.isEnabled() && !CocosPlayClient.isDemo()) {
            CocosPlayClient.updateAssets(string2);
        }
        CocosPlayClient.notifyFileLoaded(string2);
        Integer n3 = n2 = this.mPathSoundIDMap.get(string2);
        if (n2 == null) {
            n3 = n2 = Integer.valueOf(this.createSoundIDFromAsset(string2));
            if (n2 != -1) {
                this.mPathSoundIDMap.put(string2, n2);
                n3 = n2;
            }
        }
        return n3;
    }

    public void resumeAllEffects() {
        if (!this.mPathStreamIDsMap.isEmpty()) {
            Iterator<Map.Entry<String, ArrayList<Integer>>> iterator = this.mPathStreamIDsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                for (int n2 : iterator.next().getValue()) {
                    this.mSoundPool.resume(n2);
                }
            }
        }
    }

    public void resumeEffect(int n2) {
        this.mSoundPool.resume(n2);
    }

    public void setEffectsVolume(float f2) {
        float f3 = f2;
        if (f2 < 0.0f) {
            f3 = 0.0f;
        }
        f2 = f3;
        if (f3 > 1.0f) {
            f2 = 1.0f;
        }
        this.mRightVolume = f2;
        this.mLeftVolume = f2;
        if (!this.mPathStreamIDsMap.isEmpty()) {
            Iterator<Map.Entry<String, ArrayList<Integer>>> iterator = this.mPathStreamIDsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                for (int n2 : iterator.next().getValue()) {
                    this.mSoundPool.setVolume(n2, this.mLeftVolume, this.mRightVolume);
                }
            }
        }
    }

    public void stopAllEffects() {
        if (!this.mPathStreamIDsMap.isEmpty()) {
            Iterator<Map.Entry<String, ArrayList<Integer>>> iterator = this.mPathStreamIDsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                for (int n2 : iterator.next().getValue()) {
                    this.mSoundPool.stop(n2);
                }
            }
        }
        this.mPathStreamIDsMap.clear();
    }

    public void stopEffect(int n2) {
        this.mSoundPool.stop(n2);
        for (String string2 : this.mPathStreamIDsMap.keySet()) {
            if (!this.mPathStreamIDsMap.get(string2).contains(n2)) continue;
            this.mPathStreamIDsMap.get(string2).remove(this.mPathStreamIDsMap.get(string2).indexOf(n2));
            break;
        }
    }

    public void unloadEffect(String string2) {
        ArrayList<Integer> arrayList = this.mPathStreamIDsMap.get(string2);
        if (arrayList != null) {
            for (Integer n2 : arrayList) {
                this.mSoundPool.stop(n2.intValue());
            }
        }
        this.mPathStreamIDsMap.remove(string2);
        arrayList = this.mPathSoundIDMap.get(string2);
        if (arrayList != null) {
            this.mSoundPool.unload(((Integer)((Object)arrayList)).intValue());
            this.mPathSoundIDMap.remove(string2);
        }
    }

    public class OnLoadCompletedListener
    implements SoundPool.OnLoadCompleteListener {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onLoadComplete(SoundPool object, int n2, int n3) {
            if (n3 == 0 && (object = (SoundInfoForLoadedCompleted)Cocos2dxSound.this.mPlayWhenLoadedEffects.get(n2)) != null) {
                ((SoundInfoForLoadedCompleted)object).effectID = Cocos2dxSound.this.doPlayEffect(((SoundInfoForLoadedCompleted)object).path, n2, ((SoundInfoForLoadedCompleted)object).isLoop, ((SoundInfoForLoadedCompleted)object).pitch, ((SoundInfoForLoadedCompleted)object).pan, ((SoundInfoForLoadedCompleted)object).gain);
                synchronized (object) {
                    object.notifyAll();
                    return;
                }
            }
        }
    }

    public class SoundInfoForLoadedCompleted {
        public int effectID;
        public float gain;
        public boolean isLoop;
        public float pan;
        public String path;
        public float pitch;

        public SoundInfoForLoadedCompleted(String string2, boolean bl, float f2, float f3, float f4) {
            this.path = string2;
            this.isLoop = bl;
            this.pitch = f2;
            this.pan = f3;
            this.gain = f4;
            this.effectID = -1;
        }
    }
}

