/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.cocos2dx.lib.Cocos2dxHelper;

public class Cocos2dxRenderer
implements GLSurfaceView.Renderer {
    private static final long NANOSECONDSPERMICROSECOND = 1000000L;
    private static final long NANOSECONDSPERSECOND = 1000000000L;
    private static long sAnimationInterval = 16666666L;
    private long mLastTickInNanoSeconds;
    private boolean mNativeInitCompleted = false;
    private int mScreenHeight;
    private int mScreenWidth;

    private static native void nativeDeleteBackward();

    private static native String nativeGetContentText();

    private static native void nativeInit(int var0, int var1);

    private static native void nativeInsertText(String var0);

    private static native boolean nativeKeyEvent(int var0, boolean var1);

    private static native void nativeOnPause();

    private static native void nativeOnResume();

    private static native void nativeOnSurfaceChanged(int var0, int var1);

    private static native void nativeRender();

    private static native void nativeTouchesBegin(int var0, float var1, float var2);

    private static native void nativeTouchesCancel(int[] var0, float[] var1, float[] var2);

    private static native void nativeTouchesEnd(int var0, float var1, float var2);

    private static native void nativeTouchesMove(int[] var0, float[] var1, float[] var2);

    public static void setAnimationInterval(float f2) {
        sAnimationInterval = (long)(1.0E9f * f2);
    }

    public String getContentText() {
        return Cocos2dxRenderer.nativeGetContentText();
    }

    public void handleActionCancel(int[] nArray, float[] fArray, float[] fArray2) {
        Cocos2dxRenderer.nativeTouchesCancel(nArray, fArray, fArray2);
    }

    public void handleActionDown(int n2, float f2, float f3) {
        Cocos2dxRenderer.nativeTouchesBegin(n2, f2, f3);
    }

    public void handleActionMove(int[] nArray, float[] fArray, float[] fArray2) {
        Cocos2dxRenderer.nativeTouchesMove(nArray, fArray, fArray2);
    }

    public void handleActionUp(int n2, float f2, float f3) {
        Cocos2dxRenderer.nativeTouchesEnd(n2, f2, f3);
    }

    public void handleDeleteBackward() {
        Cocos2dxRenderer.nativeDeleteBackward();
    }

    public void handleInsertText(String string2) {
        Cocos2dxRenderer.nativeInsertText(string2);
    }

    public void handleKeyDown(int n2) {
        Cocos2dxRenderer.nativeKeyEvent(n2, true);
    }

    public void handleKeyUp(int n2) {
        Cocos2dxRenderer.nativeKeyEvent(n2, false);
    }

    public void handleOnPause() {
        if (!this.mNativeInitCompleted) {
            return;
        }
        Cocos2dxHelper.onEnterBackground();
        Cocos2dxRenderer.nativeOnPause();
    }

    public void handleOnResume() {
        Cocos2dxHelper.onEnterForeground();
        Cocos2dxRenderer.nativeOnResume();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDrawFrame(GL10 gL10) {
        if ((double)sAnimationInterval <= 1.6666666666666666E7) {
            Cocos2dxRenderer.nativeRender();
            return;
        }
        long l2 = System.nanoTime() - this.mLastTickInNanoSeconds;
        if (l2 < sAnimationInterval) {
            try {
                Thread.sleep((sAnimationInterval - l2) / 1000000L);
            }
            catch (Exception exception) {}
        }
        this.mLastTickInNanoSeconds = System.nanoTime();
        Cocos2dxRenderer.nativeRender();
    }

    public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
        Cocos2dxRenderer.nativeOnSurfaceChanged(n2, n3);
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        Cocos2dxRenderer.nativeInit(this.mScreenWidth, this.mScreenHeight);
        this.mLastTickInNanoSeconds = System.nanoTime();
        this.mNativeInitCompleted = true;
    }

    public void setScreenWidthAndHeight(int n2, int n3) {
        this.mScreenWidth = n2;
        this.mScreenHeight = n3;
    }
}

