/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.content.Context;
import android.media.MediaPlayer;
import android.util.Log;
import com.chukong.cocosplay.client.CocosPlayClient;
import java.io.FileInputStream;

public class Cocos2dxMusic {
    private static final String TAG = Cocos2dxMusic.class.getSimpleName();
    private MediaPlayer mBackgroundMediaPlayer;
    private final Context mContext;
    private String mCurrentPath;
    private boolean mIsLoop = false;
    private float mLeftVolume;
    private boolean mManualPaused = false;
    private boolean mPaused;
    private float mRightVolume;

    public Cocos2dxMusic(Context context) {
        this.mContext = context;
        this.initData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MediaPlayer createMediaplayer(String object) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            if (CocosPlayClient.isEnabled() && !CocosPlayClient.isDemo()) {
                CocosPlayClient.updateAssets((String)object);
            }
            CocosPlayClient.notifyFileLoaded((String)object);
            if (((String)object).startsWith("/")) {
                object = new FileInputStream((String)object);
                mediaPlayer.setDataSource(((FileInputStream)object).getFD());
                ((FileInputStream)object).close();
            } else {
                object = this.mContext.getAssets().openFd((String)object);
                mediaPlayer.setDataSource(object.getFileDescriptor(), object.getStartOffset(), object.getLength());
            }
            mediaPlayer.prepare();
            mediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
            return mediaPlayer;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("error: " + exception.getMessage()), (Throwable)exception);
            return null;
        }
    }

    private void initData() {
        this.mLeftVolume = 0.5f;
        this.mRightVolume = 0.5f;
        this.mBackgroundMediaPlayer = null;
        this.mPaused = false;
        this.mCurrentPath = null;
    }

    public void end() {
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.release();
        }
        this.initData();
    }

    public float getBackgroundVolume() {
        if (this.mBackgroundMediaPlayer != null) {
            return (this.mLeftVolume + this.mRightVolume) / 2.0f;
        }
        return 0.0f;
    }

    public boolean isBackgroundMusicPlaying() {
        if (this.mBackgroundMediaPlayer == null) {
            return false;
        }
        return this.mBackgroundMediaPlayer.isPlaying();
    }

    public void onEnterBackground() {
        if (this.mBackgroundMediaPlayer != null && this.mBackgroundMediaPlayer.isPlaying()) {
            this.mBackgroundMediaPlayer.pause();
            this.mPaused = true;
        }
    }

    public void onEnterForeground() {
        if (!this.mManualPaused && this.mBackgroundMediaPlayer != null && this.mPaused) {
            this.mBackgroundMediaPlayer.start();
            this.mPaused = false;
        }
    }

    public void pauseBackgroundMusic() {
        if (this.mBackgroundMediaPlayer != null && this.mBackgroundMediaPlayer.isPlaying()) {
            this.mBackgroundMediaPlayer.pause();
            this.mPaused = true;
            this.mManualPaused = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void playBackgroundMusic(String string2, boolean bl) {
        block9: {
            block10: {
                if (this.mCurrentPath == null) {
                    this.mBackgroundMediaPlayer = this.createMediaplayer(string2);
                    this.mCurrentPath = string2;
                } else if (!this.mCurrentPath.equals(string2)) {
                    if (this.mBackgroundMediaPlayer != null) {
                        this.mBackgroundMediaPlayer.release();
                    }
                    this.mBackgroundMediaPlayer = this.createMediaplayer(string2);
                    this.mCurrentPath = string2;
                }
                if (this.mBackgroundMediaPlayer == null) {
                    Log.e((String)TAG, (String)"playBackgroundMusic: background media player is null");
                    return;
                }
                try {
                    if (this.mPaused) {
                        this.mBackgroundMediaPlayer.seekTo(0);
                        this.mBackgroundMediaPlayer.start();
                        break block9;
                    }
                    if (!this.mBackgroundMediaPlayer.isPlaying()) break block10;
                    this.mBackgroundMediaPlayer.seekTo(0);
                    break block9;
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)"playBackgroundMusic: error state");
                    return;
                }
            }
            this.mBackgroundMediaPlayer.start();
        }
        this.mBackgroundMediaPlayer.setLooping(bl);
        this.mPaused = false;
        this.mIsLoop = bl;
    }

    public void preloadBackgroundMusic(String string2) {
        if (this.mCurrentPath == null || !this.mCurrentPath.equals(string2)) {
            if (this.mBackgroundMediaPlayer != null) {
                this.mBackgroundMediaPlayer.release();
            }
            this.mBackgroundMediaPlayer = this.createMediaplayer(string2);
            this.mCurrentPath = string2;
        }
    }

    public void resumeBackgroundMusic() {
        if (this.mBackgroundMediaPlayer != null && this.mPaused) {
            this.mBackgroundMediaPlayer.start();
            this.mPaused = false;
            this.mManualPaused = false;
        }
    }

    public void rewindBackgroundMusic() {
        if (this.mBackgroundMediaPlayer != null) {
            this.playBackgroundMusic(this.mCurrentPath, this.mIsLoop);
        }
    }

    public void setBackgroundVolume(float f2) {
        float f3 = f2;
        if (f2 < 0.0f) {
            f3 = 0.0f;
        }
        f2 = f3;
        if (f3 > 1.0f) {
            f2 = 1.0f;
        }
        this.mRightVolume = f2;
        this.mLeftVolume = f2;
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
        }
    }

    public void stopBackgroundMusic() {
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.release();
            this.mBackgroundMediaPlayer = this.createMediaplayer(this.mCurrentPath);
            this.mPaused = false;
        }
    }
}

