/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.os.Process;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.chukong.cocosplay.client.CocosPlayClient;
import com.enhance.gameservice.IGameTuningService;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.cocos2dx.lib.Cocos2dxAccelerometer;
import org.cocos2dx.lib.Cocos2dxActivity;
import org.cocos2dx.lib.Cocos2dxBitmap;
import org.cocos2dx.lib.Cocos2dxMusic;
import org.cocos2dx.lib.Cocos2dxSound;

public class Cocos2dxHelper {
    private static final int BOOST_TIME = 7;
    private static final String PREFS_NAME = "Cocos2dxPrefsFile";
    private static final int RUNNABLES_PER_FRAME = 5;
    private static ServiceConnection connection;
    private static IGameTuningService mGameServiceBinder;
    private static Set<PreferenceManager.OnActivityResultListener> onActivityResultListeners;
    private static boolean sAccelerometerEnabled;
    private static Activity sActivity;
    private static boolean sActivityVisible;
    private static AssetManager sAssetManager;
    private static Cocos2dxMusic sCocos2dMusic;
    private static Cocos2dxSound sCocos2dSound;
    private static Cocos2dxAccelerometer sCocos2dxAccelerometer;
    private static Cocos2dxHelperListener sCocos2dxHelperListener;
    private static String sFileDirectory;
    private static boolean sInited;
    private static String sPackageName;
    private static Vibrator sVibrateService;

    static {
        sActivity = null;
        onActivityResultListeners = new LinkedHashSet<PreferenceManager.OnActivityResultListener>();
        sVibrateService = null;
        mGameServiceBinder = null;
        sInited = false;
        connection = new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Cocos2dxHelper.access$002(IGameTuningService.Stub.asInterface(iBinder));
                Cocos2dxHelper.fastLoading(7);
            }

            public void onServiceDisconnected(ComponentName componentName) {
                sActivity.getApplicationContext().unbindService(connection);
            }
        };
    }

    static /* synthetic */ IGameTuningService access$002(IGameTuningService iGameTuningService) {
        mGameServiceBinder = iGameTuningService;
        return iGameTuningService;
    }

    public static void addOnActivityResultListener(PreferenceManager.OnActivityResultListener onActivityResultListener) {
        onActivityResultListeners.add(onActivityResultListener);
    }

    public static void cancelVibrate() {
        sVibrateService.cancel();
    }

    public static byte[] conversionEncoding(byte[] byArray, String string2, String string3) {
        try {
            byArray = new String(byArray, string2).getBytes(string3);
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static void deleteValueForKey(String string2) {
        SharedPreferences.Editor editor = sActivity.getSharedPreferences(PREFS_NAME, 0).edit();
        editor.remove(string2);
        editor.commit();
    }

    public static void disableAccelerometer() {
        sAccelerometerEnabled = false;
        sCocos2dxAccelerometer.disable();
    }

    public static void enableAccelerometer() {
        sAccelerometerEnabled = true;
        sCocos2dxAccelerometer.enable();
    }

    public static void end() {
        sCocos2dMusic.end();
        sCocos2dSound.end();
    }

    public static int fastLoading(int n2) {
        int n3 = -1;
        try {
            if (mGameServiceBinder != null) {
                n3 = mGameServiceBinder.boostUp(n2);
            }
            return n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static Activity getActivity() {
        return sActivity;
    }

    public static AssetManager getAssetManager() {
        return sAssetManager;
    }

    public static float getBackgroundMusicVolume() {
        return sCocos2dMusic.getBackgroundVolume();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getBoolForKey(String string2, boolean bl) {
        boolean bl2 = true;
        SharedPreferences sharedPreferences = sActivity.getSharedPreferences(PREFS_NAME, 0);
        try {
            return sharedPreferences.getBoolean(string2, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = sharedPreferences.getAll().get(string2);
            if (string2 instanceof String) {
                return Boolean.parseBoolean(string2.toString());
            }
            if (string2 instanceof Integer) {
                bl = bl2;
                if ((Integer)((Object)string2) != 0) return bl;
                return false;
            }
            if (!(string2 instanceof Float)) return false;
            bl = bl2;
            if (((Float)((Object)string2)).floatValue() != 0.0f) return bl;
            return false;
        }
    }

    public static String getCocos2dxPackageName() {
        return sPackageName;
    }

    public static String getCocos2dxWritablePath() {
        return sFileDirectory;
    }

    public static String getCurrentLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static int getDPI() {
        if (sActivity != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = sActivity.getWindowManager();
            if (windowManager != null && (windowManager = windowManager.getDefaultDisplay()) != null) {
                windowManager.getMetrics(displayMetrics);
                return (int)(displayMetrics.density * 160.0f);
            }
        }
        return -1;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static double getDoubleForKey(String string2, double d2) {
        return Cocos2dxHelper.getFloatForKey(string2, (float)d2);
    }

    public static float getEffectsVolume() {
        return sCocos2dSound.getEffectsVolume();
    }

    public static float getFloatForKey(String string2, float f2) {
        SharedPreferences sharedPreferences = sActivity.getSharedPreferences(PREFS_NAME, 0);
        try {
            f2 = sharedPreferences.getFloat(string2, f2);
            return f2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = sharedPreferences.getAll().get(string2);
            if (string2 instanceof String) {
                return Float.parseFloat(string2.toString());
            }
            if (string2 instanceof Integer) {
                return ((Integer)((Object)string2)).floatValue();
            }
            if (string2 instanceof Boolean && ((Boolean)((Object)string2)).booleanValue()) {
                return 1.0f;
            }
            return 0.0f;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getIntegerForKey(String string2, int n2) {
        int n3 = 0;
        SharedPreferences sharedPreferences = sActivity.getSharedPreferences(PREFS_NAME, 0);
        try {
            return sharedPreferences.getInt(string2, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = sharedPreferences.getAll().get(string2);
            if (string2 instanceof String) {
                return Integer.parseInt(string2.toString());
            }
            if (string2 instanceof Float) {
                return ((Float)((Object)string2)).intValue();
            }
            n2 = n3;
            if (!(string2 instanceof Boolean)) return n2;
            n2 = n3;
            if ((Boolean)((Object)string2) == false) return n2;
            return 1;
        }
    }

    public static Set<PreferenceManager.OnActivityResultListener> getOnActivityResultListeners() {
        return onActivityResultListeners;
    }

    public static String getStringForKey(String string2, String string3) {
        SharedPreferences sharedPreferences = sActivity.getSharedPreferences(PREFS_NAME, 0);
        try {
            string3 = sharedPreferences.getString(string2, string3);
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return sharedPreferences.getAll().get(string2).toString();
        }
    }

    public static int getTemperature() {
        int n2 = -1;
        try {
            if (mGameServiceBinder != null) {
                n2 = mGameServiceBinder.getAbstractTemperature();
            }
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void init(Activity activity) {
        sActivity = activity;
        sCocos2dxHelperListener = (Cocos2dxHelperListener)activity;
        if (!sInited) {
            ApplicationInfo applicationInfo = activity.getApplicationInfo();
            sPackageName = applicationInfo.packageName;
            sFileDirectory = CocosPlayClient.isEnabled() && !CocosPlayClient.isDemo() ? CocosPlayClient.getGameRoot() : activity.getFilesDir().getAbsolutePath();
            Cocos2dxHelper.nativeSetApkPath(applicationInfo.sourceDir);
            sCocos2dxAccelerometer = new Cocos2dxAccelerometer((Context)activity);
            sCocos2dMusic = new Cocos2dxMusic((Context)activity);
            sCocos2dSound = new Cocos2dxSound((Context)activity);
            sAssetManager = activity.getAssets();
            Cocos2dxHelper.nativeSetContext((Context)activity, sAssetManager);
            Cocos2dxBitmap.setContext((Context)activity);
            sVibrateService = (Vibrator)activity.getSystemService("vibrator");
            sInited = true;
            applicationInfo = new Intent(IGameTuningService.class.getName());
            applicationInfo.setPackage("com.enhance.gameservice");
            activity.getApplicationContext().bindService((Intent)applicationInfo, connection, 1);
        }
    }

    public static boolean isActivityVisible() {
        return sActivityVisible;
    }

    public static boolean isBackgroundMusicPlaying() {
        return sCocos2dMusic.isBackgroundMusicPlaying();
    }

    private static native void nativeSetApkPath(String var0);

    private static native void nativeSetContext(Context var0, AssetManager var1);

    private static native void nativeSetEditTextDialogResult(byte[] var0);

    public static void onEnterBackground() {
        sCocos2dSound.onEnterBackground();
        sCocos2dMusic.onEnterBackground();
    }

    public static void onEnterForeground() {
        sCocos2dSound.onEnterForeground();
        sCocos2dMusic.onEnterForeground();
    }

    public static void onPause() {
        sActivityVisible = false;
        if (sAccelerometerEnabled) {
            sCocos2dxAccelerometer.disable();
        }
    }

    public static void onResume() {
        sActivityVisible = true;
        if (sAccelerometerEnabled) {
            sCocos2dxAccelerometer.enable();
        }
    }

    public static boolean openURL(String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            sActivity.startActivity(intent);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void pauseAllEffects() {
        sCocos2dSound.pauseAllEffects();
    }

    public static void pauseBackgroundMusic() {
        sCocos2dMusic.pauseBackgroundMusic();
    }

    public static void pauseEffect(int n2) {
        sCocos2dSound.pauseEffect(n2);
    }

    public static void playBackgroundMusic(String string2, boolean bl) {
        sCocos2dMusic.playBackgroundMusic(string2, bl);
    }

    public static int playEffect(String string2, boolean bl, float f2, float f3, float f4) {
        return sCocos2dSound.playEffect(string2, bl, f2, f3, f4);
    }

    public static void preloadBackgroundMusic(String string2) {
        sCocos2dMusic.preloadBackgroundMusic(string2);
    }

    public static void preloadEffect(String string2) {
        sCocos2dSound.preloadEffect(string2);
    }

    public static void resumeAllEffects() {
        sCocos2dSound.resumeAllEffects();
    }

    public static void resumeBackgroundMusic() {
        sCocos2dMusic.resumeBackgroundMusic();
    }

    public static void resumeEffect(int n2) {
        sCocos2dSound.resumeEffect(n2);
    }

    public static void rewindBackgroundMusic() {
        sCocos2dMusic.rewindBackgroundMusic();
    }

    public static void runOnGLThread(Runnable runnable) {
        ((Cocos2dxActivity)sActivity).runOnGLThread(runnable);
    }

    public static void setAccelerometerInterval(float f2) {
        sCocos2dxAccelerometer.setInterval(f2);
    }

    public static void setBackgroundMusicVolume(float f2) {
        sCocos2dMusic.setBackgroundVolume(f2);
    }

    public static void setBoolForKey(String string2, boolean bl) {
        SharedPreferences.Editor editor = sActivity.getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putBoolean(string2, bl);
        editor.commit();
    }

    public static void setDoubleForKey(String string2, double d2) {
        SharedPreferences.Editor editor = sActivity.getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putFloat(string2, (float)d2);
        editor.commit();
    }

    public static void setEditTextDialogResult(String object) {
        try {
            object = ((String)object).getBytes("UTF8");
            sCocos2dxHelperListener.runOnGLThread(new Runnable((byte[])object){
                final /* synthetic */ byte[] val$bytesUTF8;
                {
                    this.val$bytesUTF8 = byArray;
                }

                @Override
                public void run() {
                    Cocos2dxHelper.nativeSetEditTextDialogResult(this.val$bytesUTF8);
                }
            });
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    public static void setEffectsVolume(float f2) {
        sCocos2dSound.setEffectsVolume(f2);
    }

    public static int setFPS(int n2) {
        int n3 = -1;
        try {
            if (mGameServiceBinder != null) {
                n3 = mGameServiceBinder.setFramePerSecond(n2);
            }
            return n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static void setFloatForKey(String string2, float f2) {
        SharedPreferences.Editor editor = sActivity.getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putFloat(string2, f2);
        editor.commit();
    }

    public static void setIntegerForKey(String string2, int n2) {
        SharedPreferences.Editor editor = sActivity.getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putInt(string2, n2);
        editor.commit();
    }

    public static void setKeepScreenOn(boolean bl) {
        ((Cocos2dxActivity)sActivity).setKeepScreenOn(bl);
    }

    public static int setLowPowerMode(boolean bl) {
        int n2 = -1;
        try {
            if (mGameServiceBinder != null) {
                n2 = mGameServiceBinder.setGamePowerSaving(bl);
            }
            return n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static int setResolutionPercent(int n2) {
        int n3 = -1;
        try {
            if (mGameServiceBinder != null) {
                n3 = mGameServiceBinder.setPreferredResolution(n2);
            }
            return n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static void setStringForKey(String string2, String string3) {
        SharedPreferences.Editor editor = sActivity.getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putString(string2, string3);
        editor.commit();
    }

    private static void showDialog(String string2, String string3) {
        sCocos2dxHelperListener.showDialog(string2, string3);
    }

    public static void stopAllEffects() {
        sCocos2dSound.stopAllEffects();
    }

    public static void stopBackgroundMusic() {
        sCocos2dMusic.stopBackgroundMusic();
    }

    public static void stopEffect(int n2) {
        sCocos2dSound.stopEffect(n2);
    }

    public static void terminateProcess() {
        Process.killProcess((int)Process.myPid());
    }

    public static void unloadEffect(String string2) {
        sCocos2dSound.unloadEffect(string2);
    }

    public static void vibrate(int n2) {
        sVibrateService.vibrate((long)n2);
    }

    public static interface Cocos2dxHelperListener {
        public void runOnGLThread(Runnable var1);

        public void showDialog(String var1, String var2);
    }
}

