/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.app.Activity;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import org.cocos2dx.lib.Cocos2dxAccelerometer;
import org.cocos2dx.lib.Cocos2dxEditBox;
import org.cocos2dx.lib.Cocos2dxRenderer;
import org.cocos2dx.lib.Cocos2dxTextInputWraper;
import org.cocos2dx.lib.Cocos2dxVideoHelper;

public class Cocos2dxGLSurfaceView
extends GLSurfaceView {
    private static final int HANDLER_CLOSE_IME_KEYBOARD = 3;
    private static final int HANDLER_OPEN_IME_KEYBOARD = 2;
    private static final String TAG = Cocos2dxGLSurfaceView.class.getSimpleName();
    private static Cocos2dxGLSurfaceView mCocos2dxGLSurfaceView;
    private static Cocos2dxTextInputWraper sCocos2dxTextInputWraper;
    private static Handler sHandler;
    private Cocos2dxEditBox mCocos2dxEditText;
    private Cocos2dxRenderer mCocos2dxRenderer;
    private boolean mSoftKeyboardShown = false;

    public Cocos2dxGLSurfaceView(Context context) {
        super(context);
        this.initView();
    }

    public Cocos2dxGLSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView();
    }

    public static void closeIMEKeyboard() {
        Message message = new Message();
        message.what = 3;
        sHandler.sendMessage(message);
    }

    private static void dumpMotionEvent(MotionEvent motionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = motionEvent.getAction();
        int n3 = n2 & 0xFF;
        stringBuilder.append("event ACTION_").append((new String[]{"DOWN", "UP", "MOVE", "CANCEL", "OUTSIDE", "POINTER_DOWN", "POINTER_UP", "7?", "8?", "9?"})[n3]);
        if (n3 == 5 || n3 == 6) {
            stringBuilder.append("(pid ").append(n2 >> 8);
            stringBuilder.append(")");
        }
        stringBuilder.append("[");
        for (n2 = 0; n2 < motionEvent.getPointerCount(); ++n2) {
            stringBuilder.append("#").append(n2);
            stringBuilder.append("(pid ").append(motionEvent.getPointerId(n2));
            stringBuilder.append(")=").append((int)motionEvent.getX(n2));
            stringBuilder.append(",").append((int)motionEvent.getY(n2));
            if (n2 + 1 >= motionEvent.getPointerCount()) continue;
            stringBuilder.append(";");
        }
        stringBuilder.append("]");
        Log.d((String)TAG, (String)stringBuilder.toString());
    }

    private String getContentText() {
        return this.mCocos2dxRenderer.getContentText();
    }

    public static Cocos2dxGLSurfaceView getInstance() {
        return mCocos2dxGLSurfaceView;
    }

    public static void openIMEKeyboard() {
        Message message = new Message();
        message.what = 2;
        message.obj = mCocos2dxGLSurfaceView.getContentText();
        sHandler.sendMessage(message);
    }

    public static void queueAccelerometer(final float f2, final float f3, final float f4, final long l2) {
        mCocos2dxGLSurfaceView.queueEvent(new Runnable(){

            @Override
            public void run() {
                Cocos2dxAccelerometer.onSensorChanged(f2, f3, f4, l2);
            }
        });
    }

    public void deleteBackward() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleDeleteBackward();
            }
        });
    }

    public Cocos2dxEditBox getCocos2dxEditText() {
        return this.mCocos2dxEditText;
    }

    protected void initView() {
        this.setEGLContextClientVersion(2);
        this.setFocusableInTouchMode(true);
        mCocos2dxGLSurfaceView = this;
        sCocos2dxTextInputWraper = new Cocos2dxTextInputWraper(this);
        sHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            public void handleMessage(Message object) {
                switch (object.what) {
                    case 2: {
                        if (Cocos2dxGLSurfaceView.this.mCocos2dxEditText == null || !Cocos2dxGLSurfaceView.this.mCocos2dxEditText.requestFocus()) return;
                        Cocos2dxGLSurfaceView.this.mCocos2dxEditText.removeTextChangedListener(sCocos2dxTextInputWraper);
                        Cocos2dxGLSurfaceView.this.mCocos2dxEditText.setText("");
                        String string2 = (String)object.obj;
                        Cocos2dxGLSurfaceView.this.mCocos2dxEditText.append(string2);
                        sCocos2dxTextInputWraper.setOriginText(string2);
                        Cocos2dxGLSurfaceView.this.mCocos2dxEditText.addTextChangedListener(sCocos2dxTextInputWraper);
                        ((InputMethodManager)mCocos2dxGLSurfaceView.getContext().getSystemService("input_method")).showSoftInput((View)Cocos2dxGLSurfaceView.this.mCocos2dxEditText, 0);
                        Log.d((String)"GLSurfaceView", (String)"showSoftInput");
                        return;
                    }
                    default: {
                        return;
                    }
                    case 3: {
                        if (Cocos2dxGLSurfaceView.this.mCocos2dxEditText == null) return;
                        Cocos2dxGLSurfaceView.this.mCocos2dxEditText.removeTextChangedListener(sCocos2dxTextInputWraper);
                        ((InputMethodManager)mCocos2dxGLSurfaceView.getContext().getSystemService("input_method")).hideSoftInputFromWindow(Cocos2dxGLSurfaceView.this.mCocos2dxEditText.getWindowToken(), 0);
                        Cocos2dxGLSurfaceView.this.requestFocus();
                        Log.d((String)"GLSurfaceView", (String)"HideSoftInput");
                        return;
                    }
                }
            }
        };
    }

    public void insertText(final String string2) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleInsertText(string2);
            }
        });
    }

    public boolean isSoftKeyboardShown() {
        return this.mSoftKeyboardShown;
    }

    public boolean onKeyDown(final int n2, KeyEvent keyEvent) {
        switch (n2) {
            default: {
                return super.onKeyDown(n2, keyEvent);
            }
            case 4: {
                Cocos2dxVideoHelper.mVideoHandler.sendEmptyMessage(1000);
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: 
            case 82: 
            case 85: 
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleKeyDown(n2);
            }
        });
        return true;
    }

    public boolean onKeyUp(final int n2, KeyEvent keyEvent) {
        switch (n2) {
            default: {
                return super.onKeyUp(n2, keyEvent);
            }
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 66: 
            case 82: 
            case 85: 
        }
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleKeyUp(n2);
            }
        });
        return true;
    }

    public void onPause() {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleOnPause();
            }
        });
        this.setRenderMode(0);
    }

    public void onResume() {
        super.onResume();
        this.setRenderMode(1);
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleOnResume();
            }
        });
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        if (!this.isInEditMode()) {
            this.mCocos2dxRenderer.setScreenWidthAndHeight(n2, n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2;
        int n3 = motionEvent.getPointerCount();
        final int[] nArray = new int[n3];
        final float[] fArray = new float[n3];
        final float[] fArray2 = new float[n3];
        if (this.mSoftKeyboardShown) {
            ((InputMethodManager)this.getContext().getSystemService("input_method")).hideSoftInputFromWindow(((Activity)this.getContext()).getCurrentFocus().getWindowToken(), 0);
            this.requestFocus();
            this.mSoftKeyboardShown = false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = motionEvent.getPointerId(n2);
            fArray[n2] = motionEvent.getX(n2);
            fArray2[n2] = motionEvent.getY(n2);
        }
        switch (motionEvent.getAction() & 0xFF) {
            case 5: {
                n2 = motionEvent.getAction() >> 8;
                this.queueEvent(new Runnable(motionEvent.getPointerId(n2), motionEvent.getX(n2), motionEvent.getY(n2)){
                    final /* synthetic */ int val$idPointerDown;
                    final /* synthetic */ float val$xPointerDown;
                    final /* synthetic */ float val$yPointerDown;
                    {
                        this.val$idPointerDown = n2;
                        this.val$xPointerDown = f2;
                        this.val$yPointerDown = f3;
                    }

                    @Override
                    public void run() {
                        Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleActionDown(this.val$idPointerDown, this.val$xPointerDown, this.val$yPointerDown);
                    }
                });
                return true;
            }
            case 0: {
                this.queueEvent(new Runnable(motionEvent.getPointerId(0), fArray[0], fArray2[0]){
                    final /* synthetic */ int val$idDown;
                    final /* synthetic */ float val$xDown;
                    final /* synthetic */ float val$yDown;
                    {
                        this.val$idDown = n2;
                        this.val$xDown = f2;
                        this.val$yDown = f3;
                    }

                    @Override
                    public void run() {
                        Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleActionDown(this.val$idDown, this.val$xDown, this.val$yDown);
                    }
                });
                return true;
            }
            case 2: {
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleActionMove(nArray, fArray, fArray2);
                    }
                });
                return true;
            }
            case 6: {
                n2 = motionEvent.getAction() >> 8;
                this.queueEvent(new Runnable(motionEvent.getPointerId(n2), motionEvent.getX(n2), motionEvent.getY(n2)){
                    final /* synthetic */ int val$idPointerUp;
                    final /* synthetic */ float val$xPointerUp;
                    final /* synthetic */ float val$yPointerUp;
                    {
                        this.val$idPointerUp = n2;
                        this.val$xPointerUp = f2;
                        this.val$yPointerUp = f3;
                    }

                    @Override
                    public void run() {
                        Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleActionUp(this.val$idPointerUp, this.val$xPointerUp, this.val$yPointerUp);
                    }
                });
                return true;
            }
            case 1: {
                this.queueEvent(new Runnable(motionEvent.getPointerId(0), fArray[0], fArray2[0]){
                    final /* synthetic */ int val$idUp;
                    final /* synthetic */ float val$xUp;
                    final /* synthetic */ float val$yUp;
                    {
                        this.val$idUp = n2;
                        this.val$xUp = f2;
                        this.val$yUp = f3;
                    }

                    @Override
                    public void run() {
                        Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleActionUp(this.val$idUp, this.val$xUp, this.val$yUp);
                    }
                });
                return true;
            }
            case 3: {
                this.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        Cocos2dxGLSurfaceView.this.mCocos2dxRenderer.handleActionCancel(nArray, fArray, fArray2);
                    }
                });
                return true;
            }
        }
        return true;
    }

    public void setCocos2dxEditText(Cocos2dxEditBox cocos2dxEditBox) {
        this.mCocos2dxEditText = cocos2dxEditBox;
        if (this.mCocos2dxEditText != null && sCocos2dxTextInputWraper != null) {
            this.mCocos2dxEditText.setOnEditorActionListener(sCocos2dxTextInputWraper);
            this.requestFocus();
        }
    }

    public void setCocos2dxRenderer(Cocos2dxRenderer cocos2dxRenderer) {
        this.mCocos2dxRenderer = cocos2dxRenderer;
        this.setRenderer(this.mCocos2dxRenderer);
    }

    public void setSoftKeyboardShown(boolean bl) {
        this.mSoftKeyboardShown = bl;
    }
}

