/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import org.cocos2dx.lib.Cocos2dxActivity;
import org.cocos2dx.lib.Cocos2dxEditBox;
import org.cocos2dx.lib.ResizeLayout;

public class Cocos2dxEditBoxHelper {
    private static final String TAG = Cocos2dxEditBoxHelper.class.getSimpleName();
    private static Cocos2dxActivity mCocos2dxActivity;
    private static SparseArray<Cocos2dxEditBox> mEditBoxArray;
    private static ResizeLayout mFrameLayout;
    private static int mViewTag;

    static {
        mViewTag = 0;
    }

    public Cocos2dxEditBoxHelper(ResizeLayout resizeLayout) {
        mFrameLayout = resizeLayout;
        mCocos2dxActivity = (Cocos2dxActivity)Cocos2dxActivity.getContext();
        mEditBoxArray = new SparseArray();
    }

    public static void __editBoxEditingChanged(int n2, String string2) {
        Cocos2dxEditBoxHelper.editBoxEditingChanged(n2, string2);
    }

    public static void __editBoxEditingDidBegin(int n2) {
        Cocos2dxEditBoxHelper.editBoxEditingDidBegin(n2);
    }

    public static void __editBoxEditingDidEnd(int n2, String string2) {
        Cocos2dxEditBoxHelper.editBoxEditingDidEnd(n2, string2);
    }

    public static void closeKeyboard(int n2) {
        Cocos2dxActivity cocos2dxActivity = mCocos2dxActivity;
        cocos2dxActivity = (InputMethodManager)Cocos2dxActivity.getContext().getSystemService("input_method");
        Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
        if (cocos2dxEditBox != null) {
            cocos2dxActivity.hideSoftInputFromWindow(cocos2dxEditBox.getWindowToken(), 0);
            mCocos2dxActivity.getGLSurfaceView().setSoftKeyboardShown(false);
        }
    }

    public static int convertToSP(float f2) {
        return (int)TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)mCocos2dxActivity.getResources().getDisplayMetrics());
    }

    public static int createEditBox(final int n2, final int n3, final int n4, final int n5, final float f2) {
        final int n6 = mViewTag;
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                final Cocos2dxEditBox cocos2dxEditBox = new Cocos2dxEditBox((Context)mCocos2dxActivity);
                cocos2dxEditBox.setFocusable(true);
                cocos2dxEditBox.setFocusableInTouchMode(true);
                cocos2dxEditBox.setInputFlag(4);
                cocos2dxEditBox.setInputMode(6);
                cocos2dxEditBox.setReturnType(0);
                cocos2dxEditBox.setHintTextColor(-7829368);
                cocos2dxEditBox.setVisibility(4);
                cocos2dxEditBox.setBackgroundColor(0);
                cocos2dxEditBox.setTextColor(-1);
                cocos2dxEditBox.setSingleLine();
                cocos2dxEditBox.setOpenGLViewScaleX(f2);
                float f22 = mCocos2dxActivity.getResources().getDisplayMetrics().density;
                int n22 = Cocos2dxEditBoxHelper.convertToSP((float)((int)((float)n5 * 0.33f / f22)) - f2 * 5.0f / f22) / 2;
                cocos2dxEditBox.setPadding(Cocos2dxEditBoxHelper.convertToSP((int)(f2 * 5.0f / f22)), n22, 0, n22);
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
                layoutParams.leftMargin = n2;
                layoutParams.topMargin = n3;
                layoutParams.width = n4;
                layoutParams.height = n5;
                layoutParams.gravity = 51;
                mFrameLayout.addView((View)cocos2dxEditBox, (ViewGroup.LayoutParams)layoutParams);
                cocos2dxEditBox.addTextChangedListener(new TextWatcher(){

                    public void afterTextChanged(Editable editable) {
                    }

                    public void beforeTextChanged(CharSequence charSequence, int n2, int n3, int n4) {
                    }

                    public void onTextChanged(final CharSequence charSequence, int n2, int n3, int n4) {
                        mCocos2dxActivity.runOnGLThread(new Runnable(){

                            @Override
                            public void run() {
                                Cocos2dxEditBoxHelper.__editBoxEditingChanged(n6, charSequence.toString());
                            }
                        });
                    }
                });
                cocos2dxEditBox.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                    public void onFocusChange(View view, boolean bl) {
                        if (bl) {
                            mCocos2dxActivity.runOnGLThread(new Runnable(){

                                @Override
                                public void run() {
                                    Cocos2dxEditBoxHelper.__editBoxEditingDidBegin(n6);
                                }
                            });
                            cocos2dxEditBox.setSelection(cocos2dxEditBox.getText().length());
                            mFrameLayout.setEnableForceDoLayout(true);
                            mCocos2dxActivity.getGLSurfaceView().setSoftKeyboardShown(true);
                            Log.d((String)TAG, (String)"edit box get focus");
                            return;
                        }
                        cocos2dxEditBox.setVisibility(8);
                        mCocos2dxActivity.runOnGLThread(new Runnable(){

                            @Override
                            public void run() {
                                Cocos2dxEditBoxHelper.__editBoxEditingDidEnd(n6, cocos2dxEditBox.getText().toString());
                            }
                        });
                        mFrameLayout.setEnableForceDoLayout(false);
                        Log.d((String)TAG, (String)"edit box lose focus");
                    }
                });
                cocos2dxEditBox.setOnKeyListener(new View.OnKeyListener(){

                    public boolean onKey(View view, int n2, KeyEvent keyEvent) {
                        if (keyEvent.getAction() == 0 && n2 == 66 && (cocos2dxEditBox.getInputType() & 0x20000) != 131072) {
                            Cocos2dxEditBoxHelper.closeKeyboard(n6);
                            mCocos2dxActivity.getGLSurfaceView().requestFocus();
                            return true;
                        }
                        return false;
                    }
                });
                cocos2dxEditBox.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView textView, int n2, KeyEvent keyEvent) {
                        if (n2 == 6) {
                            Cocos2dxEditBoxHelper.closeKeyboard(n6);
                            mCocos2dxActivity.getGLSurfaceView().requestFocus();
                        }
                        return false;
                    }
                });
                mEditBoxArray.put(n6, (Object)cocos2dxEditBox);
            }
        });
        n2 = mViewTag;
        mViewTag = n2 + 1;
        return n2;
    }

    private static native void editBoxEditingChanged(int var0, String var1);

    private static native void editBoxEditingDidBegin(int var0);

    private static native void editBoxEditingDidEnd(int var0, String var1);

    public static void openKeyboard(int n2) {
        Cocos2dxActivity cocos2dxActivity = mCocos2dxActivity;
        cocos2dxActivity = (InputMethodManager)Cocos2dxActivity.getContext().getSystemService("input_method");
        Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
        if (cocos2dxEditBox != null) {
            cocos2dxActivity.showSoftInput((View)cocos2dxEditBox, 0);
            mCocos2dxActivity.getGLSurfaceView().setSoftKeyboardShown(true);
        }
    }

    public static void removeEditBox(final int n2) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    mEditBoxArray.remove(n2);
                    mFrameLayout.removeView((View)cocos2dxEditBox);
                    Log.e((String)TAG, (String)"remove EditBox");
                }
            }
        });
    }

    public static void setEditBoxViewRect(final int n2, final int n3, final int n4, final int n5, final int n6) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setEditBoxViewRect(n3, n4, n5, n6);
                }
            }
        });
    }

    public static void setFont(final int n2, final String string2, final float f2) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    Typeface typeface = !string2.isEmpty() ? Typeface.create((String)string2, (int)0) : Typeface.DEFAULT;
                    if (f2 >= 0.0f) {
                        float f22 = mCocos2dxActivity.getResources().getDisplayMetrics().density;
                        cocos2dxEditBox.setTextSize(2, f2 / f22);
                    }
                    cocos2dxEditBox.setTypeface(typeface);
                }
            }
        });
    }

    public static void setFontColor(final int n2, final int n3, final int n4, final int n5, final int n6) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setTextColor(Color.argb((int)n6, (int)n3, (int)n4, (int)n5));
                }
            }
        });
    }

    public static void setInputFlag(final int n2, final int n3) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setInputFlag(n3);
                }
            }
        });
    }

    public static void setInputMode(final int n2, final int n3) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setInputMode(n3);
                }
            }
        });
    }

    public static void setMaxLength(final int n2, final int n3) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setMaxLength(n3);
                }
            }
        });
    }

    public static void setPlaceHolderText(final int n2, final String string2) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setHint(string2);
                }
            }
        });
    }

    public static void setPlaceHolderTextColor(final int n2, final int n3, final int n4, final int n5, final int n6) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setHintTextColor(Color.argb((int)n6, (int)n3, (int)n4, (int)n5));
                }
            }
        });
    }

    public static void setReturnType(final int n2, final int n3) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setReturnType(n3);
                }
            }
        });
    }

    public static void setText(final int n2, final String string2) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    cocos2dxEditBox.setText(string2);
                }
            }
        });
    }

    public static void setVisible(final int n2, final boolean bl) {
        mCocos2dxActivity.runOnUiThread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Cocos2dxEditBox cocos2dxEditBox = (Cocos2dxEditBox)((Object)mEditBoxArray.get(n2));
                if (cocos2dxEditBox != null) {
                    int n22 = bl ? 0 : 8;
                    cocos2dxEditBox.setVisibility(n22);
                    if (!bl) {
                        mCocos2dxActivity.getGLSurfaceView().requestFocus();
                        Cocos2dxEditBoxHelper.closeKeyboard(n2);
                        return;
                    }
                    cocos2dxEditBox.requestFocus();
                    Cocos2dxEditBoxHelper.openKeyboard(n2);
                }
            }
        });
    }
}

