/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.cocos2dx.lib.Cocos2dxTypefaces;

public final class Cocos2dxBitmap {
    private static final int HORIZONTAL_ALIGN_CENTER = 3;
    private static final int HORIZONTAL_ALIGN_LEFT = 1;
    private static final int HORIZONTAL_ALIGN_RIGHT = 2;
    private static final int VERTICAL_ALIGN_BOTTOM = 2;
    private static final int VERTICAL_ALIGN_CENTER = 3;
    private static final int VERTICAL_ALIGN_TOP = 1;
    private static Context sContext;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static boolean createTextBitmapShadowStroke(byte[] object, String string2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, float f2, float f3, float f4, float f5, boolean bl2, int n10, int n11, int n12, int n13, float f6) {
        void var5_11;
        void var4_10;
        void var3_9;
        void var6_12;
        int n14;
        void var0_3;
        int n15;
        void var15_21;
        int n16;
        TextPaint textPaint;
        int n17;
        if (object == null || ((byte[])object).length == 0) {
            return false;
        }
        String string3 = new String((byte[])object);
        Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
        int n18 = n17 & 0xF;
        Layout.Alignment alignment2 = alignment;
        switch (n18) {
            default: {
                Layout.Alignment alignment3 = alignment;
                break;
            }
            case 3: {
                Layout.Alignment alignment4 = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 2: {
                Layout.Alignment alignment5 = Layout.Alignment.ALIGN_OPPOSITE;
            }
            case 1: 
        }
        textPaint = Cocos2dxBitmap.newPaint((String)textPaint, n16);
        if (var15_21 != false) {
            void var20_26;
            textPaint.setStyle(Paint.Style.STROKE);
            textPaint.setStrokeWidth((float)var20_26);
        }
        int n19 = n16 = n15;
        if (n16 <= 0) {
            n19 = (int)Math.ceil(StaticLayout.getDesiredWidth((CharSequence)string3, (TextPaint)textPaint));
        }
        StaticLayout staticLayout = new StaticLayout((CharSequence)string3, textPaint, n19, (Layout.Alignment)var0_3, 1.0f, 0.0f, false);
        int n20 = staticLayout.getWidth();
        n19 = staticLayout.getLineTop(staticLayout.getLineCount());
        int n21 = Math.max(n20, n15);
        n15 = n19;
        if (n14 > 0) {
            n15 = n14;
        }
        if (n21 == 0 || n15 == 0) {
            return false;
        }
        n16 = 0;
        if (n18 == 3) {
            n16 = (n21 - n20) / 2;
        } else if (n18 == 2) {
            n16 = n21 - n20;
        }
        n14 = 0;
        switch (n17 >> 4 & 0xF) {
            default: {
                n17 = n14;
                break;
            }
            case 3: {
                n17 = (n15 - n19) / 2;
                break;
            }
            case 2: {
                n17 = n15 - n19;
            }
        }
        alignment = Bitmap.createBitmap((int)n21, (int)n15, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        string3 = new Canvas((Bitmap)alignment);
        string3.translate((float)n16, (float)n17);
        if (var15_21 != false) {
            void var18_24;
            void var17_23;
            void var16_22;
            void var19_25;
            textPaint.setARGB((int)var19_25, (int)var16_22, (int)var17_23, (int)var18_24);
            staticLayout.draw((Canvas)string3);
        }
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setARGB((int)var6_12, (int)var3_9, (int)var4_10, (int)var5_11);
        staticLayout.draw((Canvas)string3);
        Cocos2dxBitmap.initNativeObject((Bitmap)alignment);
        return true;
    }

    public static int getFontSizeAccordingHeight(int n2) {
        TextPaint textPaint = new TextPaint();
        Rect rect = new Rect();
        textPaint.setTypeface(Typeface.DEFAULT);
        int n3 = 1;
        boolean bl = false;
        while (!bl) {
            int n4;
            textPaint.setTextSize((float)n3);
            textPaint.getTextBounds("SghMNy", 0, "SghMNy".length(), rect);
            n3 = n4 = n3 + 1;
            if (n2 - rect.height() > 2) continue;
            bl = true;
            n3 = n4;
        }
        return n3;
    }

    private static byte[] getPixels(Bitmap bitmap) {
        if (bitmap != null) {
            byte[] byArray = new byte[bitmap.getWidth() * bitmap.getHeight() * 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.nativeOrder());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            return byArray;
        }
        return null;
    }

    private static String getStringWithEllipsis(String string2, float f2, float f3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        TextPaint textPaint = new TextPaint();
        textPaint.setTypeface(Typeface.DEFAULT);
        textPaint.setTextSize(f3);
        return TextUtils.ellipsize((CharSequence)string2, (TextPaint)textPaint, (float)f2, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
    }

    private static void initNativeObject(Bitmap bitmap) {
        byte[] byArray = Cocos2dxBitmap.getPixels(bitmap);
        if (byArray == null) {
            return;
        }
        Cocos2dxBitmap.nativeInitBitmapDC(bitmap.getWidth(), bitmap.getHeight(), byArray);
    }

    private static native void nativeInitBitmapDC(int var0, int var1, byte[] var2);

    private static TextPaint newPaint(String string2, int n2) {
        TextPaint textPaint = new TextPaint();
        textPaint.setTextSize((float)n2);
        textPaint.setAntiAlias(true);
        if (string2.endsWith(".ttf")) {
            try {
                textPaint.setTypeface(Cocos2dxTypefaces.get(sContext, string2));
                return textPaint;
            }
            catch (Exception exception) {
                Log.e((String)"Cocos2dxBitmap", (String)("error to create ttf type face: " + string2));
                textPaint.setTypeface(Typeface.create((String)string2, (int)0));
                return textPaint;
            }
        }
        textPaint.setTypeface(Typeface.create((String)string2, (int)0));
        return textPaint;
    }

    public static void setContext(Context context) {
        sContext = context;
    }
}

