/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.chukong.cocosplay.client.CocosPlayClient;
import java.util.Iterator;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import org.cocos2dx.lib.Cocos2dxEditBox;
import org.cocos2dx.lib.Cocos2dxEditBoxHelper;
import org.cocos2dx.lib.Cocos2dxGLSurfaceView;
import org.cocos2dx.lib.Cocos2dxHandler;
import org.cocos2dx.lib.Cocos2dxHelper;
import org.cocos2dx.lib.Cocos2dxRenderer;
import org.cocos2dx.lib.Cocos2dxVideoHelper;
import org.cocos2dx.lib.Cocos2dxWebViewHelper;
import org.cocos2dx.lib.ResizeLayout;

public abstract class Cocos2dxActivity
extends Activity
implements Cocos2dxHelper.Cocos2dxHelperListener {
    private static final String TAG = Cocos2dxActivity.class.getSimpleName();
    private static Cocos2dxActivity sContext = null;
    private boolean hasFocus = false;
    private Cocos2dxEditBoxHelper mEditBoxHelper = null;
    protected ResizeLayout mFrameLayout = null;
    private int[] mGLContextAttrs = null;
    private Cocos2dxGLSurfaceView mGLSurfaceView = null;
    private Cocos2dxHandler mHandler = null;
    private Cocos2dxVideoHelper mVideoHelper = null;
    private Cocos2dxWebViewHelper mWebViewHelper = null;

    public static Context getContext() {
        return sContext;
    }

    private static native int[] getGLContextAttrs();

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean isAndroidEmulator() {
        String string2 = Build.MODEL;
        Log.d((String)TAG, (String)("model=" + string2));
        string2 = Build.PRODUCT;
        Log.d((String)TAG, (String)("product=" + string2));
        boolean bl = false;
        if (string2 != null) {
            bl = string2.equals("sdk") || string2.contains("_sdk") || string2.contains("sdk_");
        }
        Log.d((String)TAG, (String)("isEmulator=" + bl));
        return bl;
    }

    private void resumeIfHasFocus() {
        if (this.hasFocus) {
            Cocos2dxHelper.onResume();
            this.mGLSurfaceView.onResume();
        }
    }

    public Cocos2dxGLSurfaceView getGLSurfaceView() {
        return this.mGLSurfaceView;
    }

    public void init() {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        this.mFrameLayout = new ResizeLayout((Context)this);
        this.mFrameLayout.setLayoutParams(layoutParams);
        layoutParams = new ViewGroup.LayoutParams(-1, -2);
        Cocos2dxEditBox cocos2dxEditBox = new Cocos2dxEditBox((Context)this);
        cocos2dxEditBox.setLayoutParams(layoutParams);
        this.mFrameLayout.addView((View)cocos2dxEditBox);
        this.mGLSurfaceView = this.onCreateView();
        this.mFrameLayout.addView((View)this.mGLSurfaceView);
        if (Cocos2dxActivity.isAndroidEmulator()) {
            this.mGLSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        }
        this.mGLSurfaceView.setCocos2dxRenderer(new Cocos2dxRenderer());
        this.mGLSurfaceView.setCocos2dxEditText(cocos2dxEditBox);
        this.setContentView((View)this.mFrameLayout);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        Iterator<PreferenceManager.OnActivityResultListener> iterator = Cocos2dxHelper.getOnActivityResultListeners().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n2, n3, intent);
        }
        super.onActivityResult(n2, n3, intent);
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        CocosPlayClient.init(this, false);
        this.onLoadNativeLibraries();
        sContext = this;
        this.mHandler = new Cocos2dxHandler(this);
        Cocos2dxHelper.init(this);
        this.mGLContextAttrs = Cocos2dxActivity.getGLContextAttrs();
        this.init();
        if (this.mVideoHelper == null) {
            this.mVideoHelper = new Cocos2dxVideoHelper(this, this.mFrameLayout);
        }
        if (this.mWebViewHelper == null) {
            this.mWebViewHelper = new Cocos2dxWebViewHelper(this.mFrameLayout);
        }
        if (this.mEditBoxHelper == null) {
            this.mEditBoxHelper = new Cocos2dxEditBoxHelper(this.mFrameLayout);
        }
        this.getWindow().setSoftInputMode(32);
    }

    public Cocos2dxGLSurfaceView onCreateView() {
        Cocos2dxGLSurfaceView cocos2dxGLSurfaceView = new Cocos2dxGLSurfaceView((Context)this);
        if (this.mGLContextAttrs[3] > 0) {
            cocos2dxGLSurfaceView.getHolder().setFormat(-3);
        }
        cocos2dxGLSurfaceView.setEGLConfigChooser(new Cocos2dxEGLConfigChooser(this.mGLContextAttrs));
        return cocos2dxGLSurfaceView;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onLoadNativeLibraries() {
        try {
            System.loadLibrary(this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)128).metaData.getString("android.app.lib_name"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void onPause() {
        Log.d((String)TAG, (String)"onPause()");
        super.onPause();
        Cocos2dxHelper.onPause();
        this.mGLSurfaceView.onPause();
    }

    protected void onResume() {
        Log.d((String)TAG, (String)"onResume()");
        super.onResume();
        this.resumeIfHasFocus();
    }

    public void onWindowFocusChanged(boolean bl) {
        Log.d((String)TAG, (String)("onWindowFocusChanged() hasFocus=" + bl));
        super.onWindowFocusChanged(bl);
        this.hasFocus = bl;
        this.resumeIfHasFocus();
    }

    @Override
    public void runOnGLThread(Runnable runnable) {
        this.mGLSurfaceView.queueEvent(runnable);
    }

    public void setKeepScreenOn(final boolean bl) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Cocos2dxActivity.this.mGLSurfaceView.setKeepScreenOn(bl);
            }
        });
    }

    @Override
    public void showDialog(String string2, String string3) {
        Message message = new Message();
        message.what = 1;
        message.obj = new Cocos2dxHandler.DialogMessage(string2, string3);
        this.mHandler.sendMessage(message);
    }

    public class Cocos2dxEGLConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        protected int[] configAttribs;

        public Cocos2dxEGLConfigChooser(int n2, int n3, int n4, int n5, int n6, int n7) {
            this.configAttribs = new int[]{n2, n3, n4, n5, n6, n7};
        }

        public Cocos2dxEGLConfigChooser(int[] nArray) {
            this.configAttribs = nArray;
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n2, int n3) {
            int[] nArray = new int[1];
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n2, nArray)) {
                n3 = nArray[0];
            }
            return n3;
        }

        public EGLConfig chooseConfig(EGL10 object, EGLDisplay eGLDisplay) {
            int[] nArray;
            int n2 = this.configAttribs[0];
            int n3 = this.configAttribs[1];
            int n4 = this.configAttribs[2];
            int n5 = this.configAttribs[3];
            int n6 = this.configAttribs[4];
            int n7 = this.configAttribs[5];
            Object[] objectArray = new EGLConfig[1];
            int[] nArray2 = new int[1];
            if (object.eglChooseConfig(eGLDisplay, new int[]{12324, n2, 12323, n3, 12322, n4, 12321, n5, 12325, n6, 12326, n7, 12352, 4, 12344}, objectArray, 1, nArray2) && nArray2[0] > 0) {
                return objectArray[0];
            }
            int[] nArray3 = nArray = new int[3];
            nArray[0] = 12352;
            nArray3[1] = 4;
            nArray3[2] = 12344;
            if (object.eglChooseConfig(eGLDisplay, nArray, null, 0, nArray2) && nArray2[0] > 0) {
                n5 = nArray2[0];
                objectArray = new ConfigValue[n5];
                EGLConfig[] eGLConfigArray = new EGLConfig[n5];
                object.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, n5, nArray2);
                for (n2 = 0; n2 < n5; ++n2) {
                    objectArray[n2] = new ConfigValue((EGL10)object, eGLDisplay, eGLConfigArray[n2]);
                }
                object = new ConfigValue(this.configAttribs);
                n2 = 0;
                n3 = n5;
                while (n2 < n3 - 1) {
                    n4 = (n2 + n3) / 2;
                    if (((ConfigValue)object).compareTo((ConfigValue)objectArray[n4]) < 0) {
                        n3 = n4;
                        continue;
                    }
                    n2 = n4;
                }
                n3 = n2;
                if (n2 != n5 - 1) {
                    n3 = n2 + 1;
                }
                Log.w((String)"cocos2d", (String)("Can't find EGLConfig match: " + object + ", instead of closest one:" + objectArray[n3]));
                return objectArray[n3].config;
            }
            Log.e((String)"device_policy", (String)"Can not select an EGLConfig for rendering.");
            return null;
        }

        class ConfigValue
        implements Comparable<ConfigValue> {
            public EGLConfig config = null;
            public int[] configAttribs = null;
            public int value = 0;

            public ConfigValue(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
                this.config = eGLConfig;
                this.configAttribs = new int[6];
                this.configAttribs[0] = Cocos2dxEGLConfigChooser.this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                this.configAttribs[1] = Cocos2dxEGLConfigChooser.this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                this.configAttribs[2] = Cocos2dxEGLConfigChooser.this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                this.configAttribs[3] = Cocos2dxEGLConfigChooser.this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                this.configAttribs[4] = Cocos2dxEGLConfigChooser.this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                this.configAttribs[5] = Cocos2dxEGLConfigChooser.this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                this.calcValue();
            }

            public ConfigValue(int[] nArray) {
                this.configAttribs = nArray;
                this.calcValue();
            }

            private void calcValue() {
                if (this.configAttribs[4] > 0) {
                    this.value = this.value + 0x20000000 + (this.configAttribs[4] % 64 << 6);
                }
                if (this.configAttribs[5] > 0) {
                    this.value = this.value + 0x10000000 + this.configAttribs[5] % 64;
                }
                if (this.configAttribs[3] > 0) {
                    this.value = this.value + 0x40000000 + (this.configAttribs[3] % 16 << 24);
                }
                if (this.configAttribs[1] > 0) {
                    this.value += this.configAttribs[1] % 16 << 20;
                }
                if (this.configAttribs[2] > 0) {
                    this.value += this.configAttribs[2] % 16 << 16;
                }
                if (this.configAttribs[0] > 0) {
                    this.value += this.configAttribs[0] % 16 << 12;
                }
            }

            @Override
            public int compareTo(ConfigValue configValue) {
                if (this.value < configValue.value) {
                    return -1;
                }
                if (this.value > configValue.value) {
                    return 1;
                }
                return 0;
            }

            public String toString() {
                return "{ color: " + this.configAttribs[3] + this.configAttribs[2] + this.configAttribs[1] + this.configAttribs[0] + "; depth: " + this.configAttribs[4] + "; stencil: " + this.configAttribs[5] + ";}";
            }
        }
    }
}

