/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.cpp;

public final class Base64 {
    private static final int BASELENGTH = 128;
    private static final int EIGHTBIT = 8;
    private static final int FOURBYTE = 4;
    private static final int LOOKUPLENGTH = 64;
    private static char PAD = '\u0000';
    private static final int SIGN = -128;
    private static final int SIXTEENBIT = 16;
    private static final int TWENTYFOURBITGROUP = 24;
    private static byte[] base64Alphabet;
    private static char[] lookUpBase64Alphabet;

    static {
        int n2;
        PAD = (char)61;
        base64Alphabet = new byte[128];
        lookUpBase64Alphabet = new char[64];
        for (n2 = 0; n2 < 128; ++n2) {
            Base64.base64Alphabet[n2] = -1;
        }
        for (n2 = 90; n2 >= 65; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
        }
        for (n2 = 122; n2 >= 97; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 97 + 26);
        }
        for (n2 = 57; n2 >= 48; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n2 = 0; n2 <= 25; ++n2) {
            Base64.lookUpBase64Alphabet[n2] = (char)(n2 + 65);
        }
        int n3 = 26;
        n2 = 0;
        while (n3 <= 51) {
            Base64.lookUpBase64Alphabet[n3] = (char)(n2 + 97);
            ++n3;
            ++n2;
        }
        n3 = 52;
        n2 = 0;
        while (n3 <= 61) {
            Base64.lookUpBase64Alphabet[n3] = (char)(n2 + 48);
            ++n3;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }

    public static byte[] decode(String object) {
        char c2;
        int n2;
        char c3;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object[] objectArray;
        block18: {
            block17: {
                if (object == null) {
                    return null;
                }
                objectArray = ((String)object).toCharArray();
                n7 = Base64.removeWhiteSpace(objectArray);
                if (n7 % 4 != 0) {
                    return null;
                }
                n6 = n7 / 4;
                if (n6 == 0) {
                    return new byte[0];
                }
                n5 = 0;
                object = new byte[n6 * 3];
                n4 = 0;
                n7 = 0;
                while (n5 < n6 - 1) {
                    char c4;
                    char c5;
                    block16: {
                        block15: {
                            n3 = n4 + 1;
                            c3 = objectArray[n4];
                            if (!Base64.isData(c3)) break block15;
                            n2 = n3 + 1;
                            c2 = objectArray[n3];
                            n4 = n2;
                            if (!Base64.isData(c2)) break block15;
                            n3 = n2 + 1;
                            c5 = objectArray[n2];
                            if (!Base64.isData(c5)) break block15;
                            n4 = n3 + 1;
                            c4 = objectArray[n3];
                            if (Base64.isData(c4)) break block16;
                        }
                        return null;
                    }
                    byte by = base64Alphabet[c3];
                    n2 = base64Alphabet[c2];
                    n3 = base64Alphabet[c5];
                    byte by2 = base64Alphabet[c4];
                    int n8 = n7 + 1;
                    object[n7] = (byte)(by << 2 | n2 >> 4);
                    n7 = n8 + 1;
                    object[n8] = (byte)((n2 & 0xF) << 4 | n3 >> 2 & 0xF);
                    object[n7] = (byte)(n3 << 6 | by2);
                    ++n5;
                    ++n7;
                }
                n2 = n4 + 1;
                c3 = objectArray[n4];
                if (!Base64.isData(c3)) break block17;
                n6 = n2 + 1;
                c2 = objectArray[n2];
                if (Base64.isData(c2)) break block18;
            }
            return null;
        }
        n2 = base64Alphabet[c3];
        n4 = base64Alphabet[c2];
        n3 = n6 + 1;
        c3 = objectArray[n6];
        c2 = objectArray[n3];
        if (!Base64.isData(c3) || !Base64.isData(c2)) {
            if (Base64.isPad(c3) && Base64.isPad(c2)) {
                if ((n4 & 0xF) != 0) {
                    return null;
                }
                objectArray = new byte[n5 * 3 + 1];
                System.arraycopy(object, 0, objectArray, 0, n5 * 3);
                objectArray[n7] = (char)(n2 << 2 | n4 >> 4);
                return objectArray;
            }
            if (!Base64.isPad(c3) && Base64.isPad(c2)) {
                n6 = base64Alphabet[c3];
                if ((n6 & 3) != 0) {
                    return null;
                }
                objectArray = new byte[n5 * 3 + 2];
                System.arraycopy(object, 0, objectArray, 0, n5 * 3);
                objectArray[n7] = (char)(n2 << 2 | n4 >> 4);
                objectArray[n7 + 1] = (char)((n4 & 0xF) << 4 | n6 >> 2 & 0xF);
                return objectArray;
            }
            return null;
        }
        n5 = base64Alphabet[c3];
        n6 = base64Alphabet[c2];
        n3 = n7 + 1;
        object[n7] = (byte)(n2 << 2 | n4 >> 4);
        n7 = n3 + 1;
        object[n3] = (byte)((n4 & 0xF) << 4 | n5 >> 2 & 0xF);
        object[n7] = (byte)(n5 << 6 | n6);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String encode(byte[] byArray) {
        byte by;
        int n2;
        int n3;
        if (byArray == null) {
            return null;
        }
        int n4 = byArray.length * 8;
        if (n4 == 0) {
            return "";
        }
        int n5 = n4 % 24;
        int n6 = n4 / 24;
        n4 = n5 != 0 ? n6 + 1 : n6;
        char[] cArray = new char[n4 * 4];
        int n7 = 0;
        n4 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = n7 + 1;
            n7 = byArray[n7];
            int n8 = n2 + 1;
            n2 = byArray[n2];
            byte by2 = byArray[n8];
            byte by3 = (byte)(n2 & 0xF);
            byte by4 = (byte)(n7 & 3);
            n7 = (n7 & 0xFFFFFF80) == 0 ? (int)((byte)(n7 >> 2)) : (int)((byte)(n7 >> 2 ^ 0xC0));
            n2 = (n2 & 0xFFFFFF80) == 0 ? (int)((byte)(n2 >> 4)) : (int)((byte)(n2 >> 4 ^ 0xF0));
            by = (by2 & 0xFFFFFF80) == 0 ? (byte)(by2 >> 6) : (byte)(by2 >> 6 ^ 0xFC);
            int n9 = n4 + 1;
            cArray[n4] = lookUpBase64Alphabet[n7];
            n4 = n9 + 1;
            cArray[n9] = lookUpBase64Alphabet[by4 << 4 | n2];
            n7 = n4 + 1;
            cArray[n4] = lookUpBase64Alphabet[by3 << 2 | by];
            n4 = n7 + 1;
            cArray[n7] = lookUpBase64Alphabet[by2 & 0x3F];
            n7 = n8 + 1;
        }
        if (n5 == 8) {
            n3 = byArray[n7];
            n7 = (byte)(n3 & 3);
            n3 = (n3 & 0xFFFFFF80) == 0 ? (int)((byte)(n3 >> 2)) : (int)((byte)(n3 >> 2 ^ 0xC0));
            n2 = n4 + 1;
            cArray[n4] = lookUpBase64Alphabet[n3];
            n4 = n2 + 1;
            cArray[n2] = lookUpBase64Alphabet[n7 << 4];
            n3 = n4 + 1;
            cArray[n4] = PAD;
            cArray[n3] = PAD;
            return new String(cArray);
        }
        n3 = n4;
        if (n5 != 16) return new String(cArray);
        n3 = byArray[n7];
        n7 = byArray[n7 + 1];
        n2 = (byte)(n7 & 0xF);
        by = (byte)(n3 & 3);
        n3 = (n3 & 0xFFFFFF80) == 0 ? (int)((byte)(n3 >> 2)) : (int)((byte)(n3 >> 2 ^ 0xC0));
        n7 = (n7 & 0xFFFFFF80) == 0 ? (int)((byte)(n7 >> 4)) : (int)((byte)(n7 >> 4 ^ 0xF0));
        n6 = n4 + 1;
        cArray[n4] = lookUpBase64Alphabet[n3];
        n4 = n6 + 1;
        cArray[n6] = lookUpBase64Alphabet[by << 4 | n7];
        n7 = n4 + 1;
        cArray[n4] = lookUpBase64Alphabet[n2 << 2];
        n3 = n7 + 1;
        cArray[n7] = PAD;
        return new String(cArray);
    }

    private static boolean isData(char c2) {
        return c2 < '\u0080' && base64Alphabet[c2] != -1;
    }

    private static boolean isPad(char c2) {
        return c2 == PAD;
    }

    private static boolean isWhiteSpace(char c2) {
        return c2 == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int removeWhiteSpace(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = n4;
            if (n3 >= n2) return n5;
            if (!Base64.isWhiteSpace(cArray[n3])) {
                n5 = n4 + 1;
                cArray[n4] = cArray[n3];
                n4 = n5;
            }
            ++n3;
        }
    }
}

