/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.compressor;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import java.io.File;
import org.cocos2dx.compressor.ImageUtil;

public class Compressor {
    private static volatile Compressor INSTANCE;
    private Bitmap.Config bitmapConfig;
    private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
    private Context context;
    private String destinationDirectoryPath;
    private String fileName;
    private String fileNamePrefix;
    private float maxHeight = 720.0f;
    private float maxWidth = 1280.0f;
    private int quality = 50;

    private Compressor(Context context) {
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
        this.context = context;
        this.destinationDirectoryPath = context.getCacheDir().getPath() + File.pathSeparator + "Compressor";
    }

    static /* synthetic */ float access$102(Compressor compressor, float f2) {
        compressor.maxWidth = f2;
        return f2;
    }

    static /* synthetic */ float access$202(Compressor compressor, float f2) {
        compressor.maxHeight = f2;
        return f2;
    }

    static /* synthetic */ Bitmap.CompressFormat access$302(Compressor compressor, Bitmap.CompressFormat compressFormat) {
        compressor.compressFormat = compressFormat;
        return compressFormat;
    }

    static /* synthetic */ Bitmap.Config access$402(Compressor compressor, Bitmap.Config config) {
        compressor.bitmapConfig = config;
        return config;
    }

    static /* synthetic */ int access$502(Compressor compressor, int n2) {
        compressor.quality = n2;
        return n2;
    }

    static /* synthetic */ String access$602(Compressor compressor, String string2) {
        compressor.destinationDirectoryPath = string2;
        return string2;
    }

    static /* synthetic */ String access$702(Compressor compressor, String string2) {
        compressor.fileNamePrefix = string2;
        return string2;
    }

    static /* synthetic */ String access$802(Compressor compressor, String string2) {
        compressor.fileName = string2;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Compressor getDefault(Context context) {
        if (INSTANCE == null) {
            synchronized (Compressor.class) {
                if (INSTANCE == null) {
                    INSTANCE = new Compressor(context);
                }
            }
        }
        return INSTANCE;
    }

    public Bitmap compressToBitmap(File file) {
        return ImageUtil.getScaledBitmap(this.context, Uri.fromFile((File)file), this.maxWidth, this.maxHeight, this.bitmapConfig);
    }

    public File compressToFile(File file) {
        return ImageUtil.compressImage(this.context, Uri.fromFile((File)file), this.maxWidth, this.maxHeight, this.compressFormat, this.bitmapConfig, this.quality, this.destinationDirectoryPath, this.fileNamePrefix, this.fileName);
    }

    public static class Builder {
        private Compressor compressor;

        public Builder(Context context) {
            this.compressor = new Compressor(context);
        }

        public Compressor build() {
            return this.compressor;
        }

        public Builder setBitmapConfig(Bitmap.Config config) {
            Compressor.access$402(this.compressor, config);
            return this;
        }

        public Builder setCompressFormat(Bitmap.CompressFormat compressFormat) {
            Compressor.access$302(this.compressor, compressFormat);
            return this;
        }

        public Builder setDestinationDirectoryPath(String string2) {
            Compressor.access$602(this.compressor, string2);
            return this;
        }

        public Builder setFileName(String string2) {
            Compressor.access$802(this.compressor, string2);
            return this;
        }

        public Builder setFileNamePrefix(String string2) {
            Compressor.access$702(this.compressor, string2);
            return this;
        }

        public Builder setMaxHeight(float f2) {
            Compressor.access$202(this.compressor, f2);
            return this;
        }

        public Builder setMaxWidth(float f2) {
            Compressor.access$102(this.compressor, f2);
            return this;
        }

        public Builder setQuality(int n2) {
            Compressor.access$502(this.compressor, n2);
            return this;
        }
    }
}

