/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.sasl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;

public class PlainSaslClient
implements SaslClient {
    private static byte SEPARATOR = 0;
    private String authenticationID;
    private String authorizationID;
    private CallbackHandler cbh;
    private boolean completed = false;
    private byte[] password;

    public PlainSaslClient(String string2, CallbackHandler objectArray) throws SaslException {
        this.cbh = objectArray;
        objectArray = this.getUserInfo();
        this.authorizationID = string2;
        this.authenticationID = (String)objectArray[0];
        this.password = (byte[])objectArray[1];
        if (this.authenticationID == null || this.password == null) {
            throw new SaslException("PLAIN: authenticationID and password must be specified");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearPassword() {
        if (this.password == null) return;
        int n2 = 0;
        while (true) {
            if (n2 >= this.password.length) {
                this.password = null;
                return;
            }
            this.password[n2] = 0;
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getUserInfo() throws SaslException {
        try {
            Object object = new NameCallback("PLAIN authentication id: ");
            PasswordCallback passwordCallback = new PasswordCallback("PLAIN password: ", false);
            this.cbh.handle(new Callback[]{object, passwordCallback});
            String string2 = ((NameCallback)object).getName();
            object = passwordCallback.getPassword();
            if (object != null) {
                object = new String((char[])object).getBytes("UTF8");
                passwordCallback.clearPassword();
                return new Object[]{string2, object};
            } else {
                object = null;
            }
            return new Object[]{string2, object};
        }
        catch (IOException iOException) {
            throw new SaslException("Cannot get password", iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("Cannot get userid/password", unsupportedCallbackException);
        }
    }

    @Override
    public void dispose() throws SaslException {
        this.clearPassword();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] evaluateChallenge(byte[] object) throws SaslException {
        int n2 = 0;
        if (this.completed) {
            throw new IllegalStateException("PLAIN: authentication already completed");
        }
        this.completed = true;
        try {
            object = this.authorizationID == null ? null : this.authorizationID.getBytes("UTF8");
            byte[] byArray = this.authenticationID.getBytes("UTF8");
            int n3 = this.password.length;
            int n4 = byArray.length;
            if (object != null) {
                n2 = ((byte[])object).length;
            }
            byte[] byArray2 = new byte[n2 + (n3 + n4 + 2)];
            if (object != null) {
                System.arraycopy(object, 0, byArray2, 0, ((byte[])object).length);
                n2 = ((byte[])object).length;
            } else {
                n2 = 0;
            }
            n3 = n2 + 1;
            byArray2[n2] = SEPARATOR;
            System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
            n2 = n3 + byArray.length;
            byArray2[n2] = SEPARATOR;
            System.arraycopy(this.password, 0, byArray2, n2 + 1, this.password.length);
            this.clearPassword();
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("PLAIN: Cannot get UTF-8 encoding of ids", unsupportedEncodingException);
        }
    }

    protected void finalize() {
        this.clearPassword();
    }

    @Override
    public String getMechanismName() {
        return "PLAIN";
    }

    @Override
    public Object getNegotiatedProperty(String string2) {
        if (this.completed) {
            if (string2.equals("javax.security.sasl.qop")) {
                return "auth";
            }
            return null;
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: this mechanism supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("PLAIN: this mechanism supports neither integrity nor privacy");
        }
        throw new IllegalStateException("PLAIN: authentication not completed");
    }
}

