/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.login;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.Subject;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.auth.login.AppConfigurationEntry;
import org.apache.harmony.javax.security.auth.login.Configuration;
import org.apache.harmony.javax.security.auth.login.LoginException;
import org.apache.harmony.javax.security.auth.spi.LoginModule;

public class LoginContext {
    private static final String DEFAULT_CALLBACK_HANDLER_PROPERTY = "auth.login.defaultCallbackHandler";
    private static final int OPTIONAL = 0;
    private static final int REQUIRED = 1;
    private static final int REQUISITE = 2;
    private static final int SUFFICIENT = 3;
    private CallbackHandler callbackHandler;
    private ClassLoader contextClassLoader;
    private boolean loggedIn;
    private Module[] modules;
    private Map<String, ?> sharedState;
    private Subject subject;
    private AccessControlContext userContext;
    private boolean userProvidedConfig;
    private boolean userProvidedSubject;

    public LoginContext(String string2) throws LoginException {
        this.init(string2, null, null, null);
    }

    public LoginContext(String string2, Subject subject) throws LoginException {
        if (subject == null) {
            throw new LoginException("auth.03");
        }
        this.init(string2, subject, null, null);
    }

    public LoginContext(String string2, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        if (subject == null) {
            throw new LoginException("auth.03");
        }
        if (callbackHandler == null) {
            throw new LoginException("auth.34");
        }
        this.init(string2, subject, callbackHandler, null);
    }

    public LoginContext(String string2, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        this.init(string2, subject, callbackHandler, configuration);
    }

    public LoginContext(String string2, CallbackHandler callbackHandler) throws LoginException {
        if (callbackHandler == null) {
            throw new LoginException("auth.34");
        }
        this.init(string2, null, callbackHandler, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(String string2, Subject object, final CallbackHandler callbackHandler, Configuration object2) throws LoginException {
        block12: {
            AppConfigurationEntry[] appConfigurationEntryArray;
            SecurityManager securityManager;
            this.subject = object;
            boolean bl = object != null;
            this.userProvidedSubject = bl;
            if (string2 == null) {
                throw new LoginException("auth.00");
            }
            if (object2 == null) {
                object2 = Configuration.getAccessibleConfiguration();
            } else {
                this.userProvidedConfig = true;
            }
            if ((securityManager = System.getSecurityManager()) != null && !this.userProvidedConfig) {
                securityManager.checkPermission(new AuthPermission("createLoginContext." + string2));
            }
            object = appConfigurationEntryArray = ((Configuration)object2).getAppConfigurationEntry(string2);
            if (appConfigurationEntryArray == null) {
                if (securityManager != null && !this.userProvidedConfig) {
                    securityManager.checkPermission(new AuthPermission("createLoginContext.other"));
                }
                object2 = ((Configuration)object2).getAppConfigurationEntry("other");
                object = object2;
                if (object2 == null) {
                    throw new LoginException("auth.35 " + string2);
                }
            }
            this.modules = new Module[((AppConfigurationEntry[])object).length];
            int n2 = 0;
            while (true) {
                if (n2 >= this.modules.length) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            LoginContext.this.contextClassLoader = Thread.currentThread().getContextClassLoader();
                            if (LoginContext.this.contextClassLoader == null) {
                                LoginContext.this.contextClassLoader = ClassLoader.getSystemClassLoader();
                            }
                            if (callbackHandler == null) {
                                Object object = Security.getProperty(LoginContext.DEFAULT_CALLBACK_HANDLER_PROPERTY);
                                if (object == null || ((String)object).length() == 0) {
                                    return null;
                                }
                                object = Class.forName((String)object, true, LoginContext.this.contextClassLoader);
                                LoginContext.this.callbackHandler = (CallbackHandler)((Class)object).newInstance();
                                return null;
                            }
                            LoginContext.this.callbackHandler = callbackHandler;
                            return null;
                        }
                    });
                    if (!this.userProvidedConfig) break block12;
                    this.userContext = AccessController.getContext();
                    return;
                }
                this.modules[n2] = new Module(object[n2]);
                ++n2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                throw (LoginException)new LoginException("auth.36").initCause(throwable);
            }
        }
        if (this.callbackHandler == null) return;
        this.userContext = AccessController.getContext();
        this.callbackHandler = new ContextedCallbackHandler(this.callbackHandler);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loginImpl() throws LoginException {
        block31: {
            block30: {
                if (this.subject == null) {
                    this.subject = new Subject();
                }
                if (this.sharedState == null) {
                    this.sharedState = new HashMap<String, ?>();
                }
                var4_1 = null;
                var8_2 = new int[4];
                var7_3 /* !! */  = new int[4];
                var9_4 = this.modules;
                var2_5 = var9_4.length;
                var1_6 = 0;
                while (true) {
                    block28: {
                        block29: {
                            if (var1_6 >= var2_5) {
                                var5_8 /* !! */  = var4_1;
                            } else {
                                var10_13 = var9_4[var1_6];
                                var10_13.create(this.subject, this.callbackHandler, this.sharedState);
                                var6_9 = var4_1;
                                if (!var10_13.module.login()) break block28;
                                var3_7 = var10_13.getFlag();
                                var7_3 /* !! */ [var3_7] = var7_3 /* !! */ [var3_7] + 1;
                                var3_7 = var10_13.getFlag();
                                var8_2[var3_7] = var8_2[var3_7] + 1;
                                try {
                                    var3_7 = var10_13.getFlag();
                                    var5_8 /* !! */  = var4_1;
                                    if (var3_7 == 3) break block29;
                                    var6_9 = var4_1;
                                    break block28;
                                }
                                catch (Throwable var6_10) {
                                    var5_8 /* !! */  = var4_1;
                                    if (var4_1 == null) {
                                        var5_8 /* !! */  = var6_10;
                                    }
                                    if (var10_13.klass == null) {
                                        var7_3 /* !! */ [1] = var7_3 /* !! */ [1] + 1;
                                        break block29;
                                    }
                                    var3_7 = var10_13.getFlag();
                                    var7_3 /* !! */ [var3_7] = var7_3 /* !! */ [var3_7] + 1;
                                    var6_9 = var5_8 /* !! */ ;
                                    if (var10_13.getFlag() != 2) break block28;
                                }
                            }
                        }
                        var1_6 = var2_5 = 1;
                        if (var8_2[1] != var7_3 /* !! */ [1]) break block30;
                        var1_6 = var2_5;
                        if (var8_2[2] != var7_3 /* !! */ [2]) break block30;
                        if (var7_3 /* !! */ [1] != 0 || var7_3 /* !! */ [2] != 0) break;
                        if (var8_2[0] == 0) {
                            var1_6 = var2_5;
                            if (var8_2[3] == 0) break block30;
                        }
                        var1_6 = 0;
                        break block30;
                    }
                    ++var1_6;
                    var4_1 = var6_9;
                }
                var1_6 = 0;
            }
            var8_2 = new int[4];
            var7_3 /* !! */ [3] = 0;
            var7_3 /* !! */ [2] = 0;
            var7_3 /* !! */ [1] = 0;
            var7_3 /* !! */ [0] = 0;
            var4_1 = var5_8 /* !! */ ;
            if (var1_6 != 0) ** GOTO lbl72
            var9_4 = this.modules;
            var2_5 = var9_4.length;
            var1_6 = 0;
            while (true) {
                block32: {
                    block34: {
                        if (var1_6 < var2_5) break block34;
                        var4_1 = var5_8 /* !! */ ;
lbl72:
                        // 2 sources

                        var1_6 = var2_5 = 1;
                        if (var8_2[1] != var7_3 /* !! */ [1]) break block31;
                        var1_6 = var2_5;
                        if (var8_2[2] != var7_3 /* !! */ [2]) break block31;
                        if (var7_3 /* !! */ [1] != 0 || var7_3 /* !! */ [2] != 0) break;
                        if (var8_2[0] == 0) {
                            var1_6 = var2_5;
                            if (var8_2[3] == 0) break block31;
                        }
                        var1_6 = 0;
                        break block31;
                    }
                    var6_9 = var9_4[var1_6];
                    var4_1 = var5_8 /* !! */ ;
                    if (var6_9.klass != null) {
                        var3_7 = var6_9.getFlag();
                        var7_3 /* !! */ [var3_7] = var7_3 /* !! */ [var3_7] + 1;
                        try {
                            var6_9.module.commit();
                            var3_7 = var6_9.getFlag();
                        }
                        catch (Throwable var6_11) {
                            var4_1 = var5_8 /* !! */ ;
                            if (var5_8 /* !! */  != null) break block32;
                            var4_1 = var6_11;
                        }
                        var8_2[var3_7] = var8_2[var3_7] + 1;
                        var4_1 = var5_8 /* !! */ ;
                    }
                }
                ++var1_6;
                var5_8 /* !! */  = var4_1;
            }
            var1_6 = 0;
        }
        if (var1_6 == 0) {
            this.loggedIn = true;
            return;
        }
        var7_3 /* !! */  = (int[])this.modules;
        var2_5 = var7_3 /* !! */ .length;
        var1_6 = 0;
        while (true) {
            block33: {
                if (var1_6 >= var2_5) {
                    var5_8 /* !! */  = var4_1;
                    if (var4_1 instanceof PrivilegedActionException) {
                        var5_8 /* !! */  = var4_1;
                        if (var4_1.getCause() != null) {
                            var5_8 /* !! */  = var4_1.getCause();
                        }
                    }
                    if (!(var5_8 /* !! */  instanceof LoginException)) break;
                    throw (LoginException)var5_8 /* !! */ ;
                }
                var5_8 /* !! */  = (Throwable)var7_3 /* !! */ [var1_6];
                try {
                    var5_8 /* !! */ .module.abort();
                    var5_8 /* !! */  = var4_1;
                }
                catch (Throwable var6_12) {
                    var5_8 /* !! */  = var4_1;
                    if (var4_1 != null) break block33;
                    var5_8 /* !! */  = var6_12;
                }
            }
            ++var1_6;
            var4_1 = var5_8 /* !! */ ;
        }
        throw (LoginException)new LoginException("auth.37").initCause(var5_8 /* !! */ );
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logoutImpl() throws LoginException {
        Object object;
        int n2 = 0;
        if (this.subject == null) {
            throw new LoginException("auth.38");
        }
        this.loggedIn = false;
        Object object2 = null;
        int n3 = 0;
        Module[] moduleArray = this.modules;
        int n4 = moduleArray.length;
        while (true) {
            int n5;
            block8: {
                if (n2 >= n4) {
                    if (object2 == null && n3 != 0) {
                        return;
                    }
                    object = object2;
                    if (object2 instanceof PrivilegedActionException) {
                        object = object2;
                        if (((Throwable)object2).getCause() != null) {
                            object = ((Throwable)object2).getCause();
                        }
                    }
                    if (!(object instanceof LoginException)) break;
                    throw (LoginException)object;
                }
                object = moduleArray[n2];
                try {
                    ((Module)object).module.logout();
                    n5 = n3 + 1;
                    object = object2;
                }
                catch (Throwable throwable) {
                    object = object2;
                    n5 = n3;
                    if (object2 != null) break block8;
                    object = throwable;
                    n5 = n3;
                }
            }
            ++n2;
            object2 = object;
            n3 = n5;
        }
        throw (LoginException)new LoginException("auth.37").initCause((Throwable)object);
    }

    public Subject getSubject() {
        if (this.userProvidedSubject || this.loggedIn) {
            return this.subject;
        }
        return null;
    }

    public void login() throws LoginException {
        PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws LoginException {
                LoginContext.this.loginImpl();
                return null;
            }
        };
        try {
            if (this.userProvidedConfig) {
                AccessController.doPrivileged(privilegedExceptionAction, this.userContext);
                return;
            }
            AccessController.doPrivileged(privilegedExceptionAction);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    public void logout() throws LoginException {
        PrivilegedExceptionAction<Void> privilegedExceptionAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws LoginException {
                LoginContext.this.logoutImpl();
                return null;
            }
        };
        try {
            if (this.userProvidedConfig) {
                AccessController.doPrivileged(privilegedExceptionAction, this.userContext);
                return;
            }
            AccessController.doPrivileged(privilegedExceptionAction);
            return;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (LoginException)privilegedActionException.getException();
        }
    }

    private class ContextedCallbackHandler
    implements CallbackHandler {
        private final CallbackHandler hiddenHandlerRef;

        ContextedCallbackHandler(CallbackHandler callbackHandler) {
            this.hiddenHandlerRef = callbackHandler;
        }

        @Override
        public void handle(final Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, UnsupportedCallbackException {
                        ContextedCallbackHandler.this.hiddenHandlerRef.handle(callbackArray);
                        return null;
                    }
                }, LoginContext.this.userContext);
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getCause() instanceof UnsupportedCallbackException) {
                    throw (UnsupportedCallbackException)privilegedActionException.getCause();
                }
                throw (IOException)privilegedActionException.getCause();
            }
        }
    }

    private final class Module {
        AppConfigurationEntry entry;
        int flag;
        Class<?> klass;
        LoginModule module;

        Module(AppConfigurationEntry appConfigurationEntry) {
            this.entry = appConfigurationEntry;
            LoginContext.this = appConfigurationEntry.getControlFlag();
            if (LoginContext.this == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
                this.flag = 0;
                return;
            }
            if (LoginContext.this == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                this.flag = 2;
                return;
            }
            if (LoginContext.this == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                this.flag = 3;
                return;
            }
            this.flag = 1;
        }

        /*
         * Loose catch block
         */
        void create(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map) throws LoginException {
            String string2 = this.entry.getLoginModuleName();
            if (this.klass == null) {
                this.klass = Class.forName(string2, false, LoginContext.this.contextClassLoader);
            }
            if (this.module == null) {
                this.module = (LoginModule)this.klass.newInstance();
                this.module.initialize(subject, callbackHandler, map, this.entry.getOptions());
            }
            return;
            catch (ClassNotFoundException classNotFoundException) {
                throw (LoginException)new LoginException("auth.39 " + string2).initCause(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (LoginException)new LoginException("auth.3A " + string2).initCause(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw (LoginException)new LoginException("auth.3A" + string2).initCause(instantiationException);
            }
        }

        int getFlag() {
            return this.flag;
        }
    }
}

