/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.login;

import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.login.AppConfigurationEntry;

public abstract class Configuration {
    private static final AuthPermission GET_LOGIN_CONFIGURATION = new AuthPermission("getLoginConfiguration");
    private static final String LOGIN_CONFIGURATION_PROVIDER = "login.configuration.provider";
    private static final AuthPermission SET_LOGIN_CONFIGURATION = new AuthPermission("setLoginConfiguration");
    private static Configuration configuration;

    protected Configuration() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Configuration getAccessibleConfiguration() {
        Configuration configuration = Configuration.configuration;
        if (configuration != null) {
            return configuration;
        }
        synchronized (Configuration.class) {
            if (Configuration.configuration != null) return Configuration.configuration;
            Configuration.configuration = Configuration.getDefaultProvider();
            return Configuration.configuration;
        }
    }

    public static Configuration getConfiguration() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GET_LOGIN_CONFIGURATION);
        }
        return Configuration.getAccessibleConfiguration();
    }

    private static final Configuration getDefaultProvider() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String string2) {
                return new AppConfigurationEntry[0];
            }

            @Override
            public void refresh() {
            }
        };
    }

    public static void setConfiguration(Configuration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOGIN_CONFIGURATION);
        }
        Configuration.configuration = configuration;
    }

    public abstract AppConfigurationEntry[] getAppConfigurationEntry(String var1);

    public abstract void refresh();
}

