/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.login;

import java.util.Collections;
import java.util.Map;

public class AppConfigurationEntry {
    private final LoginModuleControlFlag controlFlag;
    private final String loginModuleName;
    private final Map<String, ?> options;

    public AppConfigurationEntry(String string2, LoginModuleControlFlag loginModuleControlFlag, Map<String, ?> map) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("auth.26");
        }
        if (loginModuleControlFlag == null) {
            throw new IllegalArgumentException("auth.27");
        }
        if (map == null) {
            throw new IllegalArgumentException("auth.1A");
        }
        this.loginModuleName = string2;
        this.controlFlag = loginModuleControlFlag;
        this.options = Collections.unmodifiableMap(map);
    }

    public LoginModuleControlFlag getControlFlag() {
        return this.controlFlag;
    }

    public String getLoginModuleName() {
        return this.loginModuleName;
    }

    public Map<String, ?> getOptions() {
        return this.options;
    }

    public static class LoginModuleControlFlag {
        public static final LoginModuleControlFlag OPTIONAL;
        public static final LoginModuleControlFlag REQUIRED;
        public static final LoginModuleControlFlag REQUISITE;
        public static final LoginModuleControlFlag SUFFICIENT;
        private final String flag;

        static {
            REQUIRED = new LoginModuleControlFlag("LoginModuleControlFlag: required");
            REQUISITE = new LoginModuleControlFlag("LoginModuleControlFlag: requisite");
            OPTIONAL = new LoginModuleControlFlag("LoginModuleControlFlag: optional");
            SUFFICIENT = new LoginModuleControlFlag("LoginModuleControlFlag: sufficient");
        }

        private LoginModuleControlFlag(String string2) {
            this.flag = string2;
        }

        public String toString() {
            return this.flag;
        }
    }
}

