/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.callback;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.harmony.javax.security.auth.callback.Callback;

public class PasswordCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = 2267422647454909926L;
    boolean echoOn;
    private char[] inputPassword;
    private String prompt;

    public PasswordCallback(String string2, boolean bl) {
        this.setPrompt(string2);
        this.echoOn = bl;
    }

    private void setPrompt(String string2) throws IllegalArgumentException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("auth.14");
        }
        this.prompt = string2;
    }

    public void clearPassword() {
        if (this.inputPassword != null) {
            Arrays.fill(this.inputPassword, '\u0000');
        }
    }

    public char[] getPassword() {
        if (this.inputPassword != null) {
            char[] cArray = new char[this.inputPassword.length];
            System.arraycopy(this.inputPassword, 0, cArray, 0, cArray.length);
            return cArray;
        }
        return null;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public boolean isEchoOn() {
        return this.echoOn;
    }

    public void setPassword(char[] cArray) {
        if (cArray == null) {
            this.inputPassword = cArray;
            return;
        }
        this.inputPassword = new char[cArray.length];
        System.arraycopy(cArray, 0, this.inputPassword, 0, this.inputPassword.length);
    }
}

