/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.callback;

import java.io.Serializable;
import org.apache.harmony.javax.security.auth.callback.Callback;

public class ConfirmationCallback
implements Callback,
Serializable {
    public static final int CANCEL = 2;
    public static final int ERROR = 2;
    public static final int INFORMATION = 0;
    public static final int NO = 1;
    public static final int OK = 3;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int UNSPECIFIED_OPTION = -1;
    public static final int WARNING = 1;
    public static final int YES = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int YES_NO_OPTION = 0;
    private static final long serialVersionUID = -9095656433782481624L;
    private int defaultOption;
    private int messageType;
    private int optionType = -1;
    private String[] options;
    private String prompt;
    private int selection;

    public ConfirmationCallback(int n2, int n3, int n4) {
        if (n2 > 2 || n2 < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        switch (n3) {
            default: {
                throw new IllegalArgumentException("auth.18");
            }
            case 0: {
                if (n4 == 0 || n4 == 1) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 1: {
                if (n4 == 0 || n4 == 1 || n4 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 2: {
                if (n4 == 3 || n4 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
        }
        this.messageType = n2;
        this.optionType = n3;
        this.defaultOption = n4;
    }

    public ConfirmationCallback(int n2, String[] stringArray, int n3) {
        if (n2 > 2 || n2 < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("auth.1A");
        }
        int n4 = 0;
        while (true) {
            if (n4 >= stringArray.length) {
                if (n3 >= 0 && n3 < stringArray.length) break;
                throw new IllegalArgumentException("auth.17");
            }
            if (stringArray[n4] == null || stringArray[n4].length() == 0) {
                throw new IllegalArgumentException("auth.1A");
            }
            ++n4;
        }
        this.options = stringArray;
        this.defaultOption = n3;
        this.messageType = n2;
    }

    public ConfirmationCallback(String string2, int n2, int n3, int n4) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("auth.14");
        }
        if (n2 > 2 || n2 < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        switch (n3) {
            default: {
                throw new IllegalArgumentException("auth.18");
            }
            case 0: {
                if (n4 == 0 || n4 == 1) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 1: {
                if (n4 == 0 || n4 == 1 || n4 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
            case 2: {
                if (n4 == 3 || n4 == 2) break;
                throw new IllegalArgumentException("auth.17");
            }
        }
        this.prompt = string2;
        this.messageType = n2;
        this.optionType = n3;
        this.defaultOption = n4;
    }

    public ConfirmationCallback(String string2, int n2, String[] stringArray, int n3) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("auth.14");
        }
        if (n2 > 2 || n2 < 0) {
            throw new IllegalArgumentException("auth.16");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("auth.1A");
        }
        int n4 = 0;
        while (true) {
            if (n4 >= stringArray.length) {
                if (n3 >= 0 && n3 < stringArray.length) break;
                throw new IllegalArgumentException("auth.17");
            }
            if (stringArray[n4] == null || stringArray[n4].length() == 0) {
                throw new IllegalArgumentException("auth.1A");
            }
            ++n4;
        }
        this.options = stringArray;
        this.defaultOption = n3;
        this.messageType = n2;
        this.prompt = string2;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSelectedIndex(int n2) {
        if (this.options != null) {
            if (n2 >= 0 && n2 <= this.options.length) {
                this.selection = n2;
                return;
            }
            throw new ArrayIndexOutOfBoundsException("auth.1B");
        }
        switch (this.optionType) {
            case 0: {
                if (n2 == 0 || n2 == 1) break;
                throw new IllegalArgumentException("auth.19");
            }
            case 1: {
                if (n2 == 0 || n2 == 1 || n2 == 2) break;
                throw new IllegalArgumentException("auth.19");
            }
            case 2: {
                if (n2 == 3 || n2 == 2) break;
                throw new IllegalArgumentException("auth.19");
            }
        }
        this.selection = n2;
    }
}

