/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth.callback;

import java.io.Serializable;
import org.apache.harmony.javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -3975664071579892167L;
    private String[] choices;
    private int defaultChoice;
    private boolean multipleSelectionsAllowed;
    private String prompt;
    private int[] selections;

    public ChoiceCallback(String string2, String[] stringArray, int n2, boolean bl) {
        this.setPrompt(string2);
        this.setChoices(stringArray);
        this.setDefaultChoice(n2);
        this.multipleSelectionsAllowed = bl;
    }

    private void setChoices(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("auth.1C");
        }
        int n2 = 0;
        while (true) {
            if (n2 >= stringArray.length) {
                this.choices = stringArray;
                return;
            }
            if (stringArray[n2] == null || stringArray[n2].length() == 0) {
                throw new IllegalArgumentException("auth.1C");
            }
            ++n2;
        }
    }

    private void setDefaultChoice(int n2) {
        if (n2 < 0 || n2 >= this.choices.length) {
            throw new IllegalArgumentException("auth.1D");
        }
        this.defaultChoice = n2;
    }

    private void setPrompt(String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("auth.14");
        }
        this.prompt = string2;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int[] getSelectedIndexes() {
        return this.selections;
    }

    public void setSelectedIndex(int n2) {
        this.selections = new int[1];
        this.selections[0] = n2;
    }

    public void setSelectedIndexes(int[] nArray) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException();
        }
        this.selections = nArray;
    }
}

