/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.harmony.javax.security.auth.AuthPermission;
import org.apache.harmony.javax.security.auth.PrivateCredentialPermission;
import org.apache.harmony.javax.security.auth.SubjectDomainCombiner;

public final class Subject
implements Serializable {
    private static final AuthPermission _AS = new AuthPermission("doAs");
    private static final AuthPermission _AS_PRIVILEGED = new AuthPermission("doAsPrivileged");
    private static final AuthPermission _PRINCIPALS;
    private static final AuthPermission _PRIVATE_CREDENTIALS;
    private static final AuthPermission _PUBLIC_CREDENTIALS;
    private static final AuthPermission _READ_ONLY;
    private static final AuthPermission _SUBJECT;
    private static final long serialVersionUID = -8308522755600156056L;
    private final Set<Principal> principals;
    private transient SecureSet<Object> privateCredentials;
    private transient SecureSet<Object> publicCredentials;
    private boolean readOnly;

    static {
        _SUBJECT = new AuthPermission("getSubject");
        _PRINCIPALS = new AuthPermission("modifyPrincipals");
        _PRIVATE_CREDENTIALS = new AuthPermission("modifyPrivateCredentials");
        _PUBLIC_CREDENTIALS = new AuthPermission("modifyPublicCredentials");
        _READ_ONLY = new AuthPermission("setReadOnly");
    }

    public Subject() {
        this.principals = new SecureSet<Principal>(_PRINCIPALS);
        this.publicCredentials = new SecureSet(_PUBLIC_CREDENTIALS);
        this.privateCredentials = new SecureSet(_PRIVATE_CREDENTIALS);
        this.readOnly = false;
    }

    public Subject(boolean bl, Set<? extends Principal> set, Set<?> set2, Set<?> set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException();
        }
        this.principals = new SecureSet<Principal>(_PRINCIPALS, set);
        this.publicCredentials = new SecureSet(_PUBLIC_CREDENTIALS, set2);
        this.privateCredentials = new SecureSet(_PRIVATE_CREDENTIALS, set3);
        this.readOnly = bl;
    }

    private static void checkPermission(Permission permission2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission2);
        }
    }

    private void checkState() {
        if (this.readOnly) {
            throw new IllegalStateException("auth.0A");
        }
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        Subject.checkPermission(_AS);
        return Subject.doAs_PrivilegedAction(subject, privilegedAction, AccessController.getContext());
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        Subject.checkPermission(_AS);
        return Subject.doAs_PrivilegedExceptionAction(subject, privilegedExceptionAction, AccessController.getContext());
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        Subject.checkPermission(_AS_PRIVILEGED);
        if (accessControlContext == null) {
            return Subject.doAs_PrivilegedAction(subject, privilegedAction, new AccessControlContext(new ProtectionDomain[0]));
        }
        return Subject.doAs_PrivilegedAction(subject, privilegedAction, accessControlContext);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        Subject.checkPermission(_AS_PRIVILEGED);
        if (accessControlContext == null) {
            return Subject.doAs_PrivilegedExceptionAction(subject, privilegedExceptionAction, new AccessControlContext(new ProtectionDomain[0]));
        }
        return Subject.doAs_PrivilegedExceptionAction(subject, privilegedExceptionAction, accessControlContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object doAs_PrivilegedAction(Subject object, PrivilegedAction privilegedAction, final AccessControlContext accessControlContext) {
        if (object == null) {
            object = null;
            return AccessController.doPrivileged(privilegedAction, (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction((SubjectDomainCombiner)object){
                private final /* synthetic */ SubjectDomainCombiner val$combiner;
                {
                    this.val$combiner = subjectDomainCombiner;
                }

                public Object run() {
                    return new AccessControlContext(accessControlContext, this.val$combiner);
                }
            }));
        }
        object = new SubjectDomainCombiner((Subject)object);
        return AccessController.doPrivileged(privilegedAction, (AccessControlContext)AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object doAs_PrivilegedExceptionAction(Subject object, PrivilegedExceptionAction privilegedExceptionAction, final AccessControlContext accessControlContext) throws PrivilegedActionException {
        if (object == null) {
            object = null;
            return AccessController.doPrivileged(privilegedExceptionAction, AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>((SubjectDomainCombiner)object){
                private final /* synthetic */ SubjectDomainCombiner val$combiner;
                {
                    this.val$combiner = subjectDomainCombiner;
                }

                @Override
                public AccessControlContext run() {
                    return new AccessControlContext(accessControlContext, this.val$combiner);
                }
            }));
        }
        object = new SubjectDomainCombiner((Subject)object);
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */));
    }

    public static Subject getSubject(AccessControlContext object) {
        Subject.checkPermission(_SUBJECT);
        if (object == null) {
            throw new NullPointerException("auth.09");
        }
        if ((object = AccessController.doPrivileged(new PrivilegedAction<DomainCombiner>((AccessControlContext)object){
            private final /* synthetic */ AccessControlContext val$context;
            {
                this.val$context = accessControlContext;
            }

            @Override
            public DomainCombiner run() {
                return this.val$context.getDomainCombiner();
            }
        })) == null || !(object instanceof SubjectDomainCombiner)) {
            return null;
        }
        return ((SubjectDomainCombiner)object).getSubject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.publicCredentials = new SecureSet(_PUBLIC_CREDENTIALS);
        this.privateCredentials = new SecureSet(_PRIVATE_CREDENTIALS);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                object = (Subject)object;
                if (!this.principals.equals(((Subject)object).principals) || !this.publicCredentials.equals(((Subject)object).publicCredentials) || !this.privateCredentials.equals(((Subject)object).privateCredentials)) break block5;
            }
            return true;
        }
        return false;
    }

    public Set<Principal> getPrincipals() {
        return this.principals;
    }

    public <T extends Principal> Set<T> getPrincipals(Class<T> clazz) {
        return ((SecureSet)this.principals).get(clazz);
    }

    public Set<Object> getPrivateCredentials() {
        return this.privateCredentials;
    }

    public <T> Set<T> getPrivateCredentials(Class<T> clazz) {
        return this.privateCredentials.get(clazz);
    }

    public Set<Object> getPublicCredentials() {
        return this.publicCredentials;
    }

    public <T> Set<T> getPublicCredentials(Class<T> clazz) {
        return this.publicCredentials.get(clazz);
    }

    public int hashCode() {
        return this.principals.hashCode() + this.privateCredentials.hashCode() + this.publicCredentials.hashCode();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        Subject.checkPermission(_READ_ONLY);
        this.readOnly = true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Subject:\n");
        Iterator<Object> iterator = this.principals.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            stringBuilder.append("\tPrincipal: ");
            stringBuilder.append(iterator.next());
            stringBuilder.append('\n');
        }
        iterator = this.publicCredentials.iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            stringBuilder.append("\tPublic Credential: ");
            stringBuilder.append(iterator.next());
            stringBuilder.append('\n');
        }
        int n2 = stringBuilder.length();
        iterator = this.privateCredentials.iterator();
        while (true) {
            boolean bl = iterator.hasNext();
            if (bl) break block6;
            break;
        }
        catch (SecurityException securityException) {
            stringBuilder.delete(n2 - 1, stringBuilder.length());
            stringBuilder.append("\tPrivate Credentials: no accessible information\n");
            return stringBuilder.toString();
        }
        {
            block6: {
                return stringBuilder.toString();
            }
            stringBuilder.append("\tPrivate Credential: ");
            stringBuilder.append(iterator.next());
            stringBuilder.append('\n');
            continue;
        }
    }

    private final class SecureSet<SST>
    extends AbstractSet<SST>
    implements Serializable {
        private static final int SET_Principal = 0;
        private static final int SET_PrivCred = 1;
        private static final int SET_PubCred = 2;
        private static final long serialVersionUID = 7911754171111800359L;
        private LinkedList<SST> elements;
        private transient AuthPermission permission;
        private int setType;

        protected SecureSet(AuthPermission authPermission) {
            this.permission = authPermission;
            this.elements = new LinkedList();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        protected SecureSet(AuthPermission authPermission, Collection<? extends SST> collection) {
            this(authPermission);
            void var3_5;
            boolean bl = var3_5.getClass().getClassLoader() == null;
            iterator = var3_5.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                super.verifyElement(e2);
                if (!bl && this.elements.contains(e2)) continue;
                this.elements.add(e2);
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void readObject(ObjectInputStream iterator) throws IOException, ClassNotFoundException {
            ((ObjectInputStream)((Object)iterator)).defaultReadObject();
            switch (this.setType) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 0: {
                    this.permission = _PRINCIPALS;
                    break;
                }
                case 1: {
                    this.permission = _PRIVATE_CREDENTIALS;
                    break;
                }
                case 2: {
                    this.permission = _PUBLIC_CREDENTIALS;
                }
            }
            iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                this.verifyElement(iterator.next());
            }
            return;
        }

        private void verifyElement(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (this.permission == _PRINCIPALS && !Principal.class.isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("auth.0B");
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            if (this.permission != _PRIVATE_CREDENTIALS) {
                this.setType = this.permission == _PRINCIPALS ? 0 : 2;
            } else {
                Iterator<SST> iterator = this.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.setType = 1;
                        break;
                    }
                    iterator.next();
                }
            }
            objectOutputStream.defaultWriteObject();
        }

        @Override
        public boolean add(SST SST) {
            this.verifyElement(SST);
            Subject.this.checkState();
            Subject.checkPermission(this.permission);
            if (!this.elements.contains(SST)) {
                this.elements.add(SST);
                return true;
            }
            return false;
        }

        protected final <E> Set<E> get(final Class<E> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            AbstractSet abstractSet = new AbstractSet<E>(){
                private LinkedList<E> elements = new LinkedList();

                @Override
                public boolean add(E e2) {
                    if (!clazz.isAssignableFrom(e2.getClass())) {
                        throw new IllegalArgumentException("auth.0C " + clazz.getName());
                    }
                    if (this.elements.contains(e2)) {
                        return false;
                    }
                    this.elements.add(e2);
                    return true;
                }

                @Override
                public Iterator<E> iterator() {
                    return this.elements.iterator();
                }

                @Override
                public boolean retainAll(Collection<?> collection) {
                    if (collection == null) {
                        throw new NullPointerException();
                    }
                    return super.retainAll(collection);
                }

                @Override
                public int size() {
                    return this.elements.size();
                }
            };
            Iterator<SST> iterator = this.iterator();
            while (iterator.hasNext()) {
                SST SST = iterator.next();
                if (!clazz.isAssignableFrom(SST.getClass())) continue;
                abstractSet.add(clazz.cast(SST));
            }
            return abstractSet;
        }

        @Override
        public Iterator<SST> iterator() {
            if (this.permission == _PRIVATE_CREDENTIALS) {
                return new SecureIterator(this.elements.iterator()){

                    @Override
                    public SST next() {
                        Object e2 = this.iterator.next();
                        Subject.checkPermission(new PrivateCredentialPermission(e2.getClass().getName(), Subject.this.principals));
                        return e2;
                    }
                };
            }
            return new SecureIterator(this.elements.iterator());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            if (collection == null) {
                throw new NullPointerException();
            }
            return super.retainAll(collection);
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        private class SecureIterator
        implements Iterator<SST> {
            protected Iterator<SST> iterator;

            protected SecureIterator(Iterator<SST> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public SST next() {
                return this.iterator.next();
            }

            @Override
            public void remove() {
                Subject.this.checkState();
                Subject.checkPermission(SecureSet.this.permission);
                this.iterator.remove();
            }
        }
    }
}

