/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Set;

public final class PrivateCredentialPermission
extends Permission {
    private static final String READ = "read";
    private static final long serialVersionUID = 5284372143517237068L;
    private String credentialClass;
    private transient int offset;
    private transient CredOwner[] set;

    public PrivateCredentialPermission(String string2, String string3) {
        super(string2);
        if (READ.equalsIgnoreCase(string3)) {
            this.initTargetName(string2);
            return;
        }
        throw new IllegalArgumentException("auth.11");
    }

    /*
     * Enabled aggressive block sorting
     */
    PrivateCredentialPermission(String iterator, Set<Principal> object) {
        super((String)((Object)iterator));
        this.credentialClass = iterator;
        this.set = new CredOwner[object.size()];
        iterator = object.iterator();
        block0: while (iterator.hasNext()) {
            object = (Principal)iterator.next();
            object = new CredOwner(object.getClass().getName(), object.getName());
            int n2 = 0;
            int n3 = 0;
            while (true) {
                block8: {
                    block7: {
                        block6: {
                            if (n3 < this.offset) break block6;
                            n3 = n2;
                            break block7;
                        }
                        if (!this.set[n3].equals(object)) break block8;
                        n3 = 1;
                    }
                    if (n3 != 0) continue block0;
                    CredOwner[] credOwnerArray = this.set;
                    n3 = this.offset;
                    this.offset = n3 + 1;
                    credOwnerArray[n3] = object;
                    continue block0;
                }
                ++n3;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTargetName(String string2) {
        int n2;
        if (string2 == null) {
            throw new NullPointerException("auth.0E");
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("auth.0F");
        }
        int n3 = string2.indexOf(32);
        if (n3 == -1) {
            throw new IllegalArgumentException("auth.10");
        }
        this.credentialClass = string2.substring(0, n3);
        int n4 = n3 + 1;
        n3 = 0;
        int n5 = string2.length();
        while (true) {
            if (n4 >= n5) {
                if (n3 >= 1) break;
                throw new IllegalArgumentException("auth.10");
            }
            n4 = string2.indexOf(32, n4);
            n2 = string2.indexOf(34, n4 + 2);
            if (n4 == -1 || n2 == -1 || string2.charAt(n4 + 1) != '\"') {
                throw new IllegalArgumentException("auth.10");
            }
            n4 = n2 + 2;
            ++n3;
        }
        n5 = string2.indexOf(32) + 1;
        this.set = new CredOwner[n3];
        n4 = 0;
        block1: while (n4 < n3) {
            n2 = string2.indexOf(32, n5);
            int n6 = string2.indexOf(34, n2 + 2);
            CredOwner credOwner = new CredOwner(string2.substring(n5, n2), string2.substring(n2 + 2, n6));
            n2 = 0;
            n5 = 0;
            while (true) {
                block15: {
                    block14: {
                        block13: {
                            if (n5 < this.offset) break block13;
                            n5 = n2;
                            break block14;
                        }
                        if (!this.set[n5].equals(credOwner)) break block15;
                        n5 = 1;
                    }
                    if (n5 == 0) {
                        CredOwner[] credOwnerArray = this.set;
                        n5 = this.offset;
                        this.offset = n5 + 1;
                        credOwnerArray[n5] = credOwner;
                    }
                    n5 = n6 + 2;
                    ++n4;
                    continue block1;
                }
                ++n5;
            }
            break;
        }
        return;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initTargetName(this.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private boolean sameMembers(Object[] objectArray, Object[] objectArray2, int n2) {
        if (objectArray == null && objectArray2 == null) {
            return true;
        }
        if (objectArray == null) return false;
        if (objectArray2 == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (true) {
                block9: {
                    block8: {
                        block7: {
                            if (n5 < n2) break block7;
                            n5 = n4;
                            break block8;
                        }
                        if (!objectArray[n3].equals(objectArray2[n5])) break block9;
                        n5 = 1;
                    }
                    if (n5 != 0) break;
                    return false;
                }
                ++n5;
            }
            ++n3;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                object = (PrivateCredentialPermission)object;
                if (!this.credentialClass.equals(((PrivateCredentialPermission)object).credentialClass) || this.offset != ((PrivateCredentialPermission)object).offset || !this.sameMembers(this.set, ((PrivateCredentialPermission)object).set, this.offset)) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getActions() {
        return READ;
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    public String[][] getPrincipals() {
        String[][] stringArray = (String[][])Array.newInstance(String.class, this.offset, 2);
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2][0] = this.set[n2].principalClass;
            stringArray[n2][1] = this.set[n2].principalName;
            ++n2;
        }
        return stringArray;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.offset) {
            n2 += this.set[n3].hashCode();
            ++n3;
        }
        return this.getCredentialClass().hashCode() + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean implies(Permission permission2) {
        if (permission2 != null && this.getClass() == permission2.getClass()) {
            permission2 = (PrivateCredentialPermission)permission2;
            if ("*".equals(this.credentialClass) || this.credentialClass.equals(((PrivateCredentialPermission)permission2).getCredentialClass())) {
                if (((PrivateCredentialPermission)permission2).offset == 0) {
                    return true;
                }
                CredOwner[] credOwnerArray = this.set;
                CredOwner[] credOwnerArray2 = ((PrivateCredentialPermission)permission2).set;
                int n2 = this.offset;
                int n3 = ((PrivateCredentialPermission)permission2).offset;
                int n4 = 0;
                while (true) {
                    int n5;
                    if (n4 >= n2) {
                        return true;
                    }
                    for (n5 = 0; n5 < n3 && !credOwnerArray[n4].implies(credOwnerArray2[n5]); ++n5) {
                    }
                    if (n5 == credOwnerArray2.length) break;
                    ++n4;
                }
            }
        }
        return false;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private static final class CredOwner
    implements Serializable {
        private static final long serialVersionUID = -5607449830436408266L;
        private transient boolean isClassWildcard;
        private transient boolean isPNameWildcard;
        String principalClass;
        String principalName;

        CredOwner(String string2, String string3) {
            if ("*".equals(string2)) {
                this.isClassWildcard = true;
            }
            if ("*".equals(string3)) {
                this.isPNameWildcard = true;
            }
            if (this.isClassWildcard && !this.isPNameWildcard) {
                throw new IllegalArgumentException("auth.12");
            }
            this.principalClass = string2;
            this.principalName = string3;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (object == this) break block4;
                    if (!(object instanceof CredOwner)) {
                        return false;
                    }
                    object = (CredOwner)object;
                    if (!this.principalClass.equals(((CredOwner)object).principalClass) || !this.principalName.equals(((CredOwner)object).principalName)) break block5;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.principalClass.hashCode() + this.principalName.hashCode();
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean implies(Object object) {
            block3: {
                block2: {
                    if (object == this) break block2;
                    object = (CredOwner)object;
                    if (!this.isClassWildcard && !this.principalClass.equals(((CredOwner)object).principalClass) || !this.isPNameWildcard && !this.principalName.equals(((CredOwner)object).principalName)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

