/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.androidpn.client.AppUserInfo;
import org.androidpn.client.LogUtil;
import org.androidpn.client.NotificationIQ;
import org.androidpn.client.NotificationIQProvider;
import org.androidpn.client.NotificationPacketListener;
import org.androidpn.client.NotificationService;
import org.androidpn.client.PersistentConnectionListener;
import org.androidpn.client.ReconnectionThread;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.provider.ProviderManager;

public class XmppManager {
    private static final String LOGTAG = LogUtil.makeLogTag(XmppManager.class);
    private static final String XMPP_RESOURCE_NAME = "AndroidpnClient";
    private XMPPConnection connection;
    private ConnectionListener connectionListener;
    private Context context;
    private Future<?> futureTask;
    private Handler handler;
    private PacketListener notificationPacketListener;
    private String password;
    private Thread reconnection;
    private boolean running = false;
    private SharedPreferences sharedPrefs;
    private List<Runnable> taskList;
    private NotificationService.TaskSubmitter taskSubmitter;
    private NotificationService.TaskTracker taskTracker;
    private String username;
    private String xmppHost;
    private int xmppPort;

    public XmppManager(NotificationService notificationService) {
        this.context = notificationService;
        this.taskSubmitter = notificationService.getTaskSubmitter();
        this.taskTracker = notificationService.getTaskTracker();
        this.sharedPrefs = notificationService.getSharedPreferences();
        this.xmppHost = this.sharedPrefs.getString("XMPP_HOST", "122.224.178.121");
        this.xmppPort = this.sharedPrefs.getInt("XMPP_PORT", 5222);
        this.username = this.sharedPrefs.getString("XMPP_USERNAME", "");
        this.password = this.sharedPrefs.getString("XMPP_PASSWORD", "");
        this.connectionListener = new PersistentConnectionListener(this);
        this.notificationPacketListener = new NotificationPacketListener(this);
        this.handler = new Handler();
        this.taskList = new ArrayList<Runnable>();
        this.reconnection = new ReconnectionThread(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTask(Runnable runnable) {
        Log.d((String)LOGTAG, (String)"addTask(runnable)...");
        this.taskTracker.increase();
        List<Runnable> list = this.taskList;
        synchronized (list) {
            if (this.taskList.isEmpty() && !this.running) {
                this.running = true;
                this.futureTask = this.taskSubmitter.submit(runnable);
                if (this.futureTask == null) {
                    this.taskTracker.decrease();
                }
            } else {
                this.taskList.add(runnable);
            }
        }
        Log.d((String)LOGTAG, (String)"addTask(runnable)... done");
    }

    private boolean isAuthenticated() {
        return this.connection != null && this.connection.isConnected() && this.connection.isAuthenticated();
    }

    private boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    private boolean isRegistered() {
        return this.sharedPrefs.contains("XMPP_USERNAME") && this.sharedPrefs.contains("XMPP_PASSWORD");
    }

    private void removeAccount() {
        SharedPreferences.Editor editor = this.sharedPrefs.edit();
        editor.remove("XMPP_USERNAME");
        editor.remove("XMPP_PASSWORD");
        editor.commit();
    }

    private void submitConnectTask() {
        Log.d((String)LOGTAG, (String)"submitConnectTask()...");
        this.addTask(new ConnectTask());
    }

    private void submitLoginTask() {
        Log.d((String)LOGTAG, (String)"submitLoginTask()...");
        this.submitRegisterTask();
        this.addTask(new LoginTask());
    }

    private void submitRegisterTask() {
        Log.d((String)LOGTAG, (String)"submitRegisterTask()...");
        this.submitConnectTask();
        this.addTask(new RegisterTask());
    }

    public void connect() {
        Log.d((String)LOGTAG, (String)"connect()...");
        this.submitLoginTask();
    }

    public void disconnect() {
        Log.d((String)LOGTAG, (String)"disconnect()...");
        this.terminatePersistentConnection();
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public Context getContext() {
        return this.context;
    }

    public Future<?> getFutureTask() {
        return this.futureTask;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public PacketListener getNotificationPacketListener() {
        return this.notificationPacketListener;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Runnable> getTaskList() {
        return this.taskList;
    }

    public String getUsername() {
        return this.username;
    }

    public void reregisterAccount() {
        this.removeAccount();
        this.submitLoginTask();
        this.runTask();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTask() {
        Log.d((String)LOGTAG, (String)"runTask()...");
        List<Runnable> list = this.taskList;
        synchronized (list) {
            this.running = false;
            this.futureTask = null;
            if (!this.taskList.isEmpty()) {
                Runnable runnable = this.taskList.get(0);
                this.taskList.remove(0);
                this.running = true;
                this.futureTask = this.taskSubmitter.submit(runnable);
                if (this.futureTask == null) {
                    this.taskTracker.decrease();
                }
            }
        }
        this.taskTracker.decrease();
        Log.d((String)LOGTAG, (String)"runTask()...done");
    }

    public void setConnection(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
    }

    public void setPassword(String string2) {
        this.password = string2;
    }

    public void setUsername(String string2) {
        this.username = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startReconnectionThread() {
        Thread thread = this.reconnection;
        synchronized (thread) {
            if (!this.reconnection.isAlive()) {
                this.reconnection.setName("Xmpp Reconnection Thread");
                this.reconnection.start();
            }
            return;
        }
    }

    public void terminatePersistentConnection() {
        Log.d((String)LOGTAG, (String)"terminatePersistentConnection()...");
        this.addTask(new Runnable(){
            final XmppManager xmppManager;
            {
                this.xmppManager = XmppManager.this;
            }

            @Override
            public void run() {
                if (this.xmppManager.isConnected()) {
                    Log.d((String)LOGTAG, (String)"terminatePersistentConnection()... run()");
                    this.xmppManager.getConnection().removePacketListener(this.xmppManager.getNotificationPacketListener());
                    this.xmppManager.getConnection().disconnect();
                }
                this.xmppManager.runTask();
            }
        });
    }

    private class ConnectTask
    implements Runnable {
        final XmppManager xmppManager;

        private ConnectTask() {
            this.xmppManager = XmppManager.this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Log.i((String)LOGTAG, (String)"ConnectTask.run()...");
            if (this.xmppManager.isConnected()) {
                Log.i((String)LOGTAG, (String)"XMPP connected already");
                this.xmppManager.runTask();
                return;
            }
            Object object = new ConnectionConfiguration(XmppManager.this.xmppHost, XmppManager.this.xmppPort);
            ((ConnectionConfiguration)object).setSecurityMode(ConnectionConfiguration.SecurityMode.required);
            ((ConnectionConfiguration)object).setSASLAuthenticationEnabled(false);
            ((ConnectionConfiguration)object).setCompressionEnabled(false);
            object = new XMPPConnection((ConnectionConfiguration)object);
            this.xmppManager.setConnection((XMPPConnection)object);
            try {
                ((XMPPConnection)object).connect();
                Log.i((String)LOGTAG, (String)"XMPP connected successfully");
                ProviderManager.getInstance().addIQProvider("notification", "androidpn:iq:notification", new NotificationIQProvider());
            }
            catch (XMPPException xMPPException) {
                Log.e((String)LOGTAG, (String)"XMPP connection failed", (Throwable)xMPPException);
            }
            this.xmppManager.runTask();
        }
    }

    private class LoginTask
    implements Runnable {
        final XmppManager xmppManager;

        private LoginTask() {
            this.xmppManager = XmppManager.this;
        }

        @Override
        public void run() {
            Log.i((String)LOGTAG, (String)"LoginTask.run()...");
            if (!this.xmppManager.isAuthenticated()) {
                Log.d((String)LOGTAG, (String)("username=" + XmppManager.this.username));
                Log.d((String)LOGTAG, (String)("password=" + XmppManager.this.password));
                try {
                    this.xmppManager.getConnection().login(this.xmppManager.getUsername(), this.xmppManager.getPassword(), XmppManager.XMPP_RESOURCE_NAME);
                    Log.d((String)LOGTAG, (String)"Loggedn in successfully");
                    if (this.xmppManager.getConnectionListener() != null) {
                        this.xmppManager.getConnection().addConnectionListener(this.xmppManager.getConnectionListener());
                    }
                    PacketTypeFilter packetTypeFilter = new PacketTypeFilter(NotificationIQ.class);
                    PacketListener packetListener = this.xmppManager.getNotificationPacketListener();
                    XmppManager.this.connection.addPacketListener(packetListener, packetTypeFilter);
                    this.xmppManager.runTask();
                    return;
                }
                catch (XMPPException xMPPException) {
                    Log.e((String)LOGTAG, (String)"LoginTask.run()... xmpp error");
                    Log.e((String)LOGTAG, (String)("Failed to login to xmpp server. Caused by: " + xMPPException.getMessage()));
                    String string2 = xMPPException.getMessage();
                    if (string2 != null && string2.contains("401")) {
                        this.xmppManager.reregisterAccount();
                        return;
                    }
                    this.xmppManager.startReconnectionThread();
                    return;
                }
                catch (Exception exception) {
                    Log.e((String)LOGTAG, (String)"LoginTask.run()... other error");
                    Log.e((String)LOGTAG, (String)("Failed to login to xmpp server. Caused by: " + exception.getMessage()));
                    this.xmppManager.startReconnectionThread();
                    return;
                }
            }
            Log.i((String)LOGTAG, (String)"Logged in already");
            this.xmppManager.runTask();
        }
    }

    private class RegisterTask
    implements Runnable {
        final XmppManager xmppManager;

        private RegisterTask() {
            this.xmppManager = XmppManager.this;
        }

        @Override
        public void run() {
            Log.i((String)LOGTAG, (String)"RegisterTask.run()...");
            if (!this.xmppManager.isRegistered()) {
                final String string2 = AppUserInfo.getAppUsername(XmppManager.this.context);
                final String string3 = AppUserInfo.getUserPassword(XmppManager.this.context);
                Registration registration = new Registration();
                AndFilter andFilter = new AndFilter(new PacketIDFilter(registration.getPacketID()), new PacketTypeFilter(IQ.class));
                PacketListener packetListener = new PacketListener(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    @Override
                    public void processPacket(Packet packet) {
                        Log.d((String)"RegisterTask.PacketListener", (String)"processPacket().....");
                        Log.d((String)"RegisterTask.PacketListener", (String)("packet=" + packet.toXML()));
                        if (!(packet instanceof IQ)) return;
                        if (((IQ)(packet = (IQ)packet)).getType() == IQ.Type.ERROR) {
                            if (packet.getError().toString().contains("409")) return;
                            Log.e((String)LOGTAG, (String)("Unknown error while registering XMPP account! " + packet.getError().getCondition()));
                            return;
                        }
                        if (((IQ)packet).getType() != IQ.Type.RESULT) return;
                        RegisterTask.this.xmppManager.setUsername(string2);
                        RegisterTask.this.xmppManager.setPassword(string3);
                        Log.d((String)LOGTAG, (String)("username=" + string2));
                        Log.d((String)LOGTAG, (String)("password=" + string3));
                        packet = XmppManager.this.sharedPrefs.edit();
                        packet.putString("XMPP_USERNAME", string2);
                        packet.putString("XMPP_PASSWORD", string3);
                        packet.commit();
                        Log.i((String)LOGTAG, (String)"Account registered successfully");
                        RegisterTask.this.xmppManager.runTask();
                    }
                };
                XmppManager.this.connection.addPacketListener(packetListener, andFilter);
                registration.setType(IQ.Type.SET);
                registration.addAttribute("username", string2);
                registration.addAttribute("password", string3);
                XmppManager.this.connection.sendPacket(registration);
                return;
            }
            Log.i((String)LOGTAG, (String)"Account registered already");
            this.xmppManager.runTask();
        }
    }
}

