/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import java.util.Properties;
import org.androidpn.client.LogUtil;
import org.androidpn.client.NotificationService;
import org.androidpn.client.NotificationSettingsActivity;

public final class ServiceManager {
    private static final String LOGTAG = LogUtil.makeLogTag(ServiceManager.class);
    private String apiKey;
    private String callbackActivityClassName;
    private String callbackActivityPackageName;
    private Context context;
    private Properties props;
    private SharedPreferences sharedPrefs;
    private String version = "0.5.0";
    private String xmppHost;
    private String xmppPort;

    public ServiceManager(Context context) {
        this.context = context;
        if (context instanceof Activity) {
            Log.i((String)LOGTAG, (String)"Callback Activity...");
            Activity activity = (Activity)context;
            this.callbackActivityPackageName = activity.getPackageName();
            this.callbackActivityClassName = activity.getClass().getName();
        }
        this.props = this.loadProperties();
        this.apiKey = this.props.getProperty("apiKey", "");
        this.xmppHost = this.props.getProperty("xmppHost", "127.0.0.1");
        this.xmppPort = this.props.getProperty("xmppPort", "5222");
        Log.i((String)LOGTAG, (String)("apiKey=" + this.apiKey));
        Log.i((String)LOGTAG, (String)("xmppHost=" + this.xmppHost));
        Log.i((String)LOGTAG, (String)("xmppPort=" + this.xmppPort));
        this.sharedPrefs = context.getSharedPreferences("client_preferences", 0);
        context = this.sharedPrefs.edit();
        context.putString("API_KEY", this.apiKey);
        context.putString("VERSION", this.version);
        context.putString("XMPP_HOST", this.xmppHost);
        context.putInt("XMPP_PORT", Integer.parseInt(this.xmppPort));
        context.putString("CALLBACK_ACTIVITY_PACKAGE_NAME", this.callbackActivityPackageName);
        context.putString("CALLBACK_ACTIVITY_CLASS_NAME", this.callbackActivityClassName);
        context.commit();
    }

    private Properties loadProperties() {
        Properties properties = new Properties();
        try {
            int n2 = this.context.getResources().getIdentifier("androidpn", "raw", this.context.getPackageName());
            properties.load(this.context.getResources().openRawResource(n2));
            return properties;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Could not find the properties file.", (Throwable)exception);
            return properties;
        }
    }

    public static void viewNotificationSettings(Context context) {
        context.startActivity(new Intent().setClass(context, NotificationSettingsActivity.class));
    }

    public void setNotificationIcon(int n2) {
        SharedPreferences.Editor editor = this.sharedPrefs.edit();
        editor.putInt("NOTIFICATION_ICON", n2);
        editor.commit();
    }

    public void startService() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Intent intent = NotificationService.getIntent();
                ServiceManager.this.context.startService(intent);
            }
        }).start();
    }

    public void stopService() {
        Intent intent = NotificationService.getIntent();
        this.context.stopService(intent);
    }
}

