/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.util.Log;
import org.androidpn.client.LogUtil;
import org.androidpn.client.XmppManager;

public class ReconnectionThread
extends Thread {
    private static final String LOGTAG = LogUtil.makeLogTag(ReconnectionThread.class);
    private int waiting;
    private final XmppManager xmppManager;

    ReconnectionThread(XmppManager xmppManager) {
        this.xmppManager = xmppManager;
        this.waiting = 0;
    }

    private int waiting() {
        if (this.waiting > 20) {
            return 600;
        }
        if (this.waiting > 13) {
            return 300;
        }
        if (this.waiting <= 7) {
            return 10;
        }
        return 60;
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.isInterrupted()) {
                    return;
                }
                Log.d((String)LOGTAG, (String)("Trying to reconnect in " + this.waiting() + " seconds"));
                Thread.sleep((long)this.waiting() * 1000L);
                this.xmppManager.connect();
                ++this.waiting;
            }
        }
        catch (InterruptedException interruptedException) {
            this.xmppManager.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    ReconnectionThread.this.xmppManager.getConnectionListener().reconnectionFailed(interruptedException);
                }
            });
            return;
        }
    }
}

