/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.util.Log;
import org.androidpn.client.LogUtil;
import org.androidpn.client.XmppManager;
import org.jivesoftware.smack.ConnectionListener;

public class PersistentConnectionListener
implements ConnectionListener {
    private static final String LOGTAG = LogUtil.makeLogTag(PersistentConnectionListener.class);
    private final XmppManager xmppManager;

    public PersistentConnectionListener(XmppManager xmppManager) {
        this.xmppManager = xmppManager;
    }

    @Override
    public void connectionClosed() {
        Log.d((String)LOGTAG, (String)"connectionClosed()...");
    }

    @Override
    public void connectionClosedOnError(Exception exception) {
        Log.d((String)LOGTAG, (String)"connectionClosedOnError()...");
        if (this.xmppManager.getConnection() != null && this.xmppManager.getConnection().isConnected()) {
            this.xmppManager.getConnection().disconnect();
        }
        this.xmppManager.startReconnectionThread();
    }

    @Override
    public void reconnectingIn(int n2) {
        Log.d((String)LOGTAG, (String)"reconnectingIn()...");
    }

    @Override
    public void reconnectionFailed(Exception exception) {
        Log.d((String)LOGTAG, (String)"reconnectionFailed()...");
    }

    @Override
    public void reconnectionSuccessful() {
        Log.d((String)LOGTAG, (String)"reconnectionSuccessful()...");
    }
}

