/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import android.widget.Toast;
import java.util.Random;
import org.androidpn.client.LogUtil;
import org.androidpn.client.NotificationDetailsActivity;

public class Notifier {
    private static final String LOGTAG = LogUtil.makeLogTag(Notifier.class);
    private static final Random random = new Random(System.currentTimeMillis());
    private Context context;
    private NotificationManager notificationManager;
    private SharedPreferences sharedPrefs;

    public Notifier(Context context) {
        this.context = context;
        this.sharedPrefs = context.getSharedPreferences("client_preferences", 0);
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    private int getNotificationIcon() {
        return this.sharedPrefs.getInt("NOTIFICATION_ICON", 0);
    }

    private boolean isNotificationEnabled() {
        return this.sharedPrefs.getBoolean("SETTINGS_NOTIFICATION_ENABLED", true);
    }

    private boolean isNotificationSoundEnabled() {
        return this.sharedPrefs.getBoolean("SETTINGS_SOUND_ENABLED", true);
    }

    private boolean isNotificationToastEnabled() {
        return this.sharedPrefs.getBoolean("SETTINGS_TOAST_ENABLED", false);
    }

    private boolean isNotificationVibrateEnabled() {
        return this.sharedPrefs.getBoolean("SETTINGS_VIBRATE_ENABLED", true);
    }

    public void notify(String string2, String string3, String string4, String string5, String string6) {
        Log.d((String)LOGTAG, (String)"notify()...");
        Log.d((String)LOGTAG, (String)("notificationId=" + string2));
        Log.d((String)LOGTAG, (String)("notificationApiKey=" + string3));
        Log.d((String)LOGTAG, (String)("notificationTitle=" + string4));
        Log.d((String)LOGTAG, (String)("notificationMessage=" + string5));
        Log.d((String)LOGTAG, (String)("notificationUri=" + string6));
        if (this.isNotificationEnabled()) {
            if (this.isNotificationToastEnabled()) {
                Toast.makeText((Context)this.context, (CharSequence)string5, (int)1).show();
            }
            Notification notification = new Notification();
            notification.icon = this.getNotificationIcon();
            notification.defaults = 4;
            if (this.isNotificationSoundEnabled()) {
                notification.defaults |= 1;
            }
            if (this.isNotificationVibrateEnabled()) {
                notification.defaults |= 2;
            }
            notification.flags |= 0x10;
            notification.when = System.currentTimeMillis();
            notification.tickerText = string5;
            Intent intent = new Intent(this.context, NotificationDetailsActivity.class);
            intent.putExtra("NOTIFICATION_ID", string2);
            intent.putExtra("NOTIFICATION_API_KEY", string3);
            intent.putExtra("NOTIFICATION_TITLE", string4);
            intent.putExtra("NOTIFICATION_MESSAGE", string5);
            intent.putExtra("NOTIFICATION_URI", string6);
            intent.setFlags(0x10000000);
            intent.setFlags(0x800000);
            intent.setFlags(0x40000000);
            intent.setFlags(0x20000000);
            intent.setFlags(0x4000000);
            string2 = PendingIntent.getActivity((Context)this.context, (int)random.nextInt(), (Intent)intent, (int)0x8000000);
            notification.setLatestEventInfo(this.context, (CharSequence)string4, (CharSequence)string5, (PendingIntent)string2);
            this.notificationManager.notify(random.nextInt(), notification);
            return;
        }
        Log.w((String)LOGTAG, (String)"Notificaitons disabled.");
    }
}

