/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.content.Context;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.util.Log;
import org.androidpn.client.LogUtil;

public class NotificationSettingsActivity
extends PreferenceActivity {
    private static final String LOGTAG = LogUtil.makeLogTag(NotificationSettingsActivity.class);

    private PreferenceScreen createPreferenceHierarchy() {
        Log.d((String)LOGTAG, (String)"createSettingsPreferenceScreen()...");
        PreferenceManager preferenceManager = this.getPreferenceManager();
        preferenceManager.setSharedPreferencesName("client_preferences");
        preferenceManager.setSharedPreferencesMode(0);
        preferenceManager = preferenceManager.createPreferenceScreen((Context)this);
        CheckBoxPreference checkBoxPreference = new CheckBoxPreference((Context)this);
        checkBoxPreference.setKey("SETTINGS_NOTIFICATION_ENABLED");
        checkBoxPreference.setTitle((CharSequence)"Notifications Enabled");
        checkBoxPreference.setSummaryOn((CharSequence)"Receive push messages");
        checkBoxPreference.setSummaryOff((CharSequence)"Do not receive push messages");
        checkBoxPreference.setDefaultValue((Object)Boolean.TRUE);
        checkBoxPreference.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean onPreferenceChange(Preference preference, Object object) {
                if (Boolean.valueOf(object.toString()).booleanValue()) {
                    preference.setTitle((CharSequence)"Notifications Enabled");
                    return true;
                }
                preference.setTitle((CharSequence)"Notifications Disabled");
                return true;
            }
        });
        CheckBoxPreference checkBoxPreference2 = new CheckBoxPreference((Context)this);
        checkBoxPreference2.setKey("SETTINGS_SOUND_ENABLED");
        checkBoxPreference2.setTitle((CharSequence)"Sound");
        checkBoxPreference2.setSummary((CharSequence)"Play a sound for notifications");
        checkBoxPreference2.setDefaultValue((Object)Boolean.TRUE);
        CheckBoxPreference checkBoxPreference3 = new CheckBoxPreference((Context)this);
        checkBoxPreference3.setKey("SETTINGS_VIBRATE_ENABLED");
        checkBoxPreference3.setTitle((CharSequence)"Vibrate");
        checkBoxPreference3.setSummary((CharSequence)"Vibrate the phone for notifications");
        checkBoxPreference3.setDefaultValue((Object)Boolean.TRUE);
        preferenceManager.addPreference((Preference)checkBoxPreference);
        preferenceManager.addPreference((Preference)checkBoxPreference2);
        preferenceManager.addPreference((Preference)checkBoxPreference3);
        return preferenceManager;
    }

    private void setPreferenceDependencies() {
        Preference preference = this.getPreferenceManager().findPreference((CharSequence)"SETTINGS_SOUND_ENABLED");
        if (preference != null) {
            preference.setDependency("SETTINGS_NOTIFICATION_ENABLED");
        }
        if ((preference = this.getPreferenceManager().findPreference((CharSequence)"SETTINGS_VIBRATE_ENABLED")) != null) {
            preference.setDependency("SETTINGS_NOTIFICATION_ENABLED");
        }
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setPreferenceScreen(this.createPreferenceHierarchy());
        this.setPreferenceDependencies();
        bundle = (CheckBoxPreference)this.getPreferenceManager().findPreference((CharSequence)"SETTINGS_NOTIFICATION_ENABLED");
        if (bundle.isChecked()) {
            bundle.setTitle((CharSequence)"Notifications Enabled");
            return;
        }
        bundle.setTitle((CharSequence)"Notifications Disabled");
    }
}

