/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.androidpn.client.ConnectivityReceiver;
import org.androidpn.client.LogUtil;
import org.androidpn.client.NotificationReceiver;
import org.androidpn.client.PhoneStateChangeListener;
import org.androidpn.client.XmppManager;

public class NotificationService
extends Service {
    private static final String LOGTAG = LogUtil.makeLogTag(NotificationService.class);
    public static final String SERVICE_NAME = "org.androidpn.client.NotificationService";
    private BroadcastReceiver connectivityReceiver;
    private String deviceId;
    private ExecutorService executorService;
    private BroadcastReceiver notificationReceiver = new NotificationReceiver();
    private PhoneStateListener phoneStateListener;
    private SharedPreferences sharedPrefs;
    private TaskSubmitter taskSubmitter;
    private TaskTracker taskTracker;
    private TelephonyManager telephonyManager;
    private XmppManager xmppManager;

    public NotificationService() {
        this.connectivityReceiver = new ConnectivityReceiver(this);
        this.phoneStateListener = new PhoneStateChangeListener(this);
        this.executorService = Executors.newSingleThreadExecutor();
        this.taskSubmitter = new TaskSubmitter(this);
        this.taskTracker = new TaskTracker(this);
    }

    public static Intent getIntent() {
        return new Intent(SERVICE_NAME);
    }

    private void registerConnectivityReceiver() {
        Log.d((String)LOGTAG, (String)"registerConnectivityReceiver()...");
        this.telephonyManager.listen(this.phoneStateListener, 64);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.registerReceiver(this.connectivityReceiver, intentFilter);
    }

    private void registerNotificationReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("org.androidpn.client.SHOW_NOTIFICATION");
        intentFilter.addAction("org.androidpn.client.NOTIFICATION_CLICKED");
        intentFilter.addAction("org.androidpn.client.NOTIFICATION_CLEARED");
        this.registerReceiver(this.notificationReceiver, intentFilter);
    }

    private void start() {
        Log.d((String)LOGTAG, (String)"start()...");
        this.registerNotificationReceiver();
        this.registerConnectivityReceiver();
        this.xmppManager.connect();
    }

    private void stop() {
        Log.d((String)LOGTAG, (String)"stop()...");
        this.unregisterNotificationReceiver();
        this.unregisterConnectivityReceiver();
        this.xmppManager.disconnect();
        this.executorService.shutdown();
    }

    private void unregisterConnectivityReceiver() {
        Log.d((String)LOGTAG, (String)"unregisterConnectivityReceiver()...");
        this.telephonyManager.listen(this.phoneStateListener, 0);
        this.unregisterReceiver(this.connectivityReceiver);
    }

    private void unregisterNotificationReceiver() {
        this.unregisterReceiver(this.notificationReceiver);
    }

    public void connect() {
        Log.d((String)LOGTAG, (String)"connect()...");
        this.taskSubmitter.submit(new Runnable(){

            @Override
            public void run() {
                NotificationService.this.getXmppManager().connect();
            }
        });
    }

    public void disconnect() {
        Log.d((String)LOGTAG, (String)"disconnect()...");
        this.taskSubmitter.submit(new Runnable(){

            @Override
            public void run() {
                NotificationService.this.getXmppManager().disconnect();
            }
        });
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public SharedPreferences getSharedPreferences() {
        return this.sharedPrefs;
    }

    public TaskSubmitter getTaskSubmitter() {
        return this.taskSubmitter;
    }

    public TaskTracker getTaskTracker() {
        return this.taskTracker;
    }

    public XmppManager getXmppManager() {
        return this.xmppManager;
    }

    public IBinder onBind(Intent intent) {
        Log.d((String)LOGTAG, (String)"onBind()...");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate() {
        Log.d((String)LOGTAG, (String)"onCreate()...");
        this.telephonyManager = (TelephonyManager)this.getSystemService("phone");
        this.sharedPrefs = this.getSharedPreferences("client_preferences", 0);
        this.deviceId = this.telephonyManager.getDeviceId();
        SharedPreferences.Editor editor = this.sharedPrefs.edit();
        editor.putString("DEVICE_ID", this.deviceId);
        editor.commit();
        if (this.deviceId == null || this.deviceId.trim().length() == 0 || this.deviceId.matches("0+")) {
            if (this.sharedPrefs.contains("EMULATOR_DEVICE_ID")) {
                this.deviceId = this.sharedPrefs.getString("EMULATOR_DEVICE_ID", "");
            } else {
                this.deviceId = "EMU" + new Random(System.currentTimeMillis()).nextLong();
                editor.putString("EMULATOR_DEVICE_ID", this.deviceId);
                editor.commit();
            }
        }
        Log.d((String)LOGTAG, (String)("deviceId=" + this.deviceId));
        this.xmppManager = new XmppManager(this);
        this.taskSubmitter.submit(new Runnable(){

            @Override
            public void run() {
                NotificationService.this.start();
            }
        });
    }

    public void onDestroy() {
        Log.d((String)LOGTAG, (String)"onDestroy()...");
        this.stop();
    }

    public void onRebind(Intent intent) {
        Log.d((String)LOGTAG, (String)"onRebind()...");
    }

    public void onStart(Intent intent, int n2) {
        Log.d((String)LOGTAG, (String)"onStart()...");
    }

    public boolean onUnbind(Intent intent) {
        Log.d((String)LOGTAG, (String)"onUnbind()...");
        return true;
    }

    public class TaskSubmitter {
        final NotificationService notificationService;

        public TaskSubmitter(NotificationService notificationService2) {
            this.notificationService = notificationService2;
        }

        public Future submit(Runnable runnable) {
            Future<?> future;
            Future<?> future2 = future = null;
            if (!this.notificationService.getExecutorService().isTerminated()) {
                future2 = future;
                if (!this.notificationService.getExecutorService().isShutdown()) {
                    future2 = future;
                    if (runnable != null) {
                        future2 = this.notificationService.getExecutorService().submit(runnable);
                    }
                }
            }
            return future2;
        }
    }

    public class TaskTracker {
        public int count;
        final NotificationService notificationService;

        public TaskTracker(NotificationService notificationService2) {
            this.notificationService = notificationService2;
            this.count = 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void decrease() {
            TaskTracker taskTracker = this.notificationService.getTaskTracker();
            synchronized (taskTracker) {
                TaskTracker taskTracker2 = this.notificationService.getTaskTracker();
                --taskTracker2.count;
                Log.d((String)LOGTAG, (String)("Decremented task count to " + this.count));
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void increase() {
            TaskTracker taskTracker = this.notificationService.getTaskTracker();
            synchronized (taskTracker) {
                TaskTracker taskTracker2 = this.notificationService.getTaskTracker();
                ++taskTracker2.count;
                Log.d((String)LOGTAG, (String)("Incremented task count to " + this.count));
                return;
            }
        }
    }
}

