/*
 * Decompiled with CFR 0.152.
 */
package org.androidpn.client;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.util.Log;
import org.androidpn.client.LogUtil;
import org.androidpn.client.NotificationService;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private static final String LOGTAG = LogUtil.makeLogTag(ConnectivityReceiver.class);
    private NotificationService notificationService;

    public ConnectivityReceiver(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void onReceive(Context context, Intent object) {
        Log.d((String)LOGTAG, (String)"ConnectivityReceiver.onReceive()...");
        object = object.getAction();
        Log.d((String)LOGTAG, (String)("action=" + (String)object));
        context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (context != null) {
            Log.d((String)LOGTAG, (String)("Network Type  = " + context.getTypeName()));
            Log.d((String)LOGTAG, (String)("Network State = " + context.getState()));
            if (context.isConnected()) {
                Log.i((String)LOGTAG, (String)"Network connected");
                this.notificationService.connect();
            }
            return;
        }
        Log.e((String)LOGTAG, (String)"Network unavailable");
        this.notificationService.disconnect();
    }
}

