/*
 * Decompiled with CFR 0.152.
 */
package com.yaya.sdk.connection;

import com.yaya.sdk.connection.CPtr;
import com.yaya.sdk.connection.JavaFunction;
import com.yaya.sdk.connection.YayaException;
import com.yaya.sdk.connection.YayaObject;
import com.yaya.sdk.connection.YayaStateFactory;

public class YayaLib {
    private static final String YAYAJAVA_LIB = "YvImSdk";
    private int stateId;
    private CPtr yayaState;

    static {
        System.loadLibrary(YAYAJAVA_LIB);
    }

    protected YayaLib(int n2) {
        this.yayaState = this._open();
        this.Yaya_open(this.yayaState, n2);
        this.stateId = n2;
    }

    protected YayaLib(CPtr cPtr) {
        this.yayaState = cPtr;
        this.stateId = YayaStateFactory.insertYayaState(this);
        this.Yaya_open(cPtr, this.stateId);
    }

    private synchronized native void Yaya_open(CPtr var1, int var2);

    private synchronized native int _LargError(CPtr var1, int var2, String var3);

    private synchronized native int _LcallMeta(CPtr var1, int var2, String var3);

    private synchronized native void _LcheckAny(CPtr var1, int var2);

    private synchronized native int _LcheckInteger(CPtr var1, int var2);

    private synchronized native double _LcheckNumber(CPtr var1, int var2);

    private synchronized native void _LcheckStack(CPtr var1, int var2, String var3);

    private synchronized native String _LcheckString(CPtr var1, int var2);

    private synchronized native void _LcheckType(CPtr var1, int var2, int var3);

    private synchronized native int _LdoFile(CPtr var1, String var2);

    private synchronized native int _LdoString(CPtr var1, String var2);

    private synchronized native String _LfindTable(CPtr var1, int var2, String var3, int var4);

    private synchronized native int _LgetMetaField(CPtr var1, int var2, String var3);

    private synchronized native void _LgetMetatable(CPtr var1, String var2);

    private synchronized native int _LgetN(CPtr var1, int var2);

    private synchronized native String _Lgsub(CPtr var1, String var2, String var3, String var4);

    private synchronized native int _LloadBuffer(CPtr var1, byte[] var2, long var3, String var5);

    private synchronized native int _LloadFile(CPtr var1, String var2);

    private synchronized native int _LloadString(CPtr var1, String var2);

    private synchronized native int _LnewMetatable(CPtr var1, String var2);

    private synchronized native int _LoptInteger(CPtr var1, int var2, int var3);

    private synchronized native double _LoptNumber(CPtr var1, int var2, double var3);

    private synchronized native String _LoptString(CPtr var1, int var2, String var3);

    private synchronized native int _Lref(CPtr var1, int var2);

    private synchronized native void _LsetN(CPtr var1, int var2, int var3);

    private synchronized native int _Ltyperror(CPtr var1, int var2, String var3);

    private synchronized native void _LunRef(CPtr var1, int var2, int var3);

    private synchronized native void _Lwhere(CPtr var1, int var2);

    private synchronized native void _call(CPtr var1, int var2, int var3);

    private synchronized native int _checkStack(CPtr var1, int var2);

    private synchronized native void _close(CPtr var1);

    private synchronized native void _concat(CPtr var1, int var2);

    private synchronized native void _createTable(CPtr var1, int var2, int var3);

    private synchronized native int _equal(CPtr var1, int var2, int var3);

    private synchronized native int _error(CPtr var1);

    private synchronized native int _gc(CPtr var1, int var2, int var3);

    private synchronized native void _getFEnv(CPtr var1, int var2);

    private synchronized native void _getField(CPtr var1, int var2, String var3);

    private synchronized native int _getGcCount(CPtr var1);

    private synchronized native void _getGlobal(CPtr var1, String var2);

    private synchronized native int _getMetaTable(CPtr var1, int var2);

    private synchronized native Object _getObjectFromUserdata(CPtr var1, int var2) throws YayaException;

    private synchronized native void _getTable(CPtr var1, int var2);

    private synchronized native int _getTop(CPtr var1);

    private synchronized native void _insert(CPtr var1, int var2);

    private synchronized native int _isBoolean(CPtr var1, int var2);

    private synchronized native int _isCFunction(CPtr var1, int var2);

    private synchronized native int _isFunction(CPtr var1, int var2);

    private synchronized native boolean _isJavaFunction(CPtr var1, int var2);

    private synchronized native int _isNil(CPtr var1, int var2);

    private synchronized native int _isNone(CPtr var1, int var2);

    private synchronized native int _isNoneOrNil(CPtr var1, int var2);

    private synchronized native int _isNumber(CPtr var1, int var2);

    private synchronized native boolean _isObject(CPtr var1, int var2);

    private synchronized native int _isString(CPtr var1, int var2);

    private synchronized native int _isTable(CPtr var1, int var2);

    private synchronized native int _isThread(CPtr var1, int var2);

    private synchronized native int _isUserdata(CPtr var1, int var2);

    private synchronized native int _lessthan(CPtr var1, int var2, int var3);

    private synchronized native void _newTable(CPtr var1);

    private synchronized native CPtr _newthread(CPtr var1);

    private synchronized native int _next(CPtr var1, int var2);

    private synchronized native int _objlen(CPtr var1, int var2);

    private synchronized native CPtr _open();

    private synchronized native void _openBase(CPtr var1);

    private synchronized native void _openDebug(CPtr var1);

    private synchronized native void _openIo(CPtr var1);

    private synchronized native void _openLibs(CPtr var1);

    private synchronized native void _openMath(CPtr var1);

    private synchronized native void _openOs(CPtr var1);

    private synchronized native void _openPackage(CPtr var1);

    private synchronized native void _openString(CPtr var1);

    private synchronized native void _openTable(CPtr var1);

    private synchronized native int _pcall(CPtr var1, int var2, int var3, int var4);

    private synchronized native void _pop(CPtr var1, int var2);

    private synchronized native void _pushBoolean(CPtr var1, int var2);

    private synchronized native void _pushInteger(CPtr var1, int var2);

    private synchronized native void _pushJavaFunction(CPtr var1, JavaFunction var2) throws YayaException;

    private synchronized native void _pushJavaObject(CPtr var1, Object var2);

    private synchronized native void _pushNil(CPtr var1);

    private synchronized native void _pushNumber(CPtr var1, double var2);

    private synchronized native void _pushString(CPtr var1, String var2);

    private synchronized native void _pushString(CPtr var1, byte[] var2, int var3);

    private synchronized native void _pushValue(CPtr var1, int var2);

    private synchronized native void _rawGet(CPtr var1, int var2);

    private synchronized native void _rawGetI(CPtr var1, int var2, int var3);

    private synchronized native void _rawSet(CPtr var1, int var2);

    private synchronized native void _rawSetI(CPtr var1, int var2, int var3);

    private synchronized native int _rawequal(CPtr var1, int var2, int var3);

    private synchronized native void _remove(CPtr var1, int var2);

    private synchronized native void _replace(CPtr var1, int var2);

    private synchronized native int _resume(CPtr var1, int var2);

    private synchronized native int _setFEnv(CPtr var1, int var2);

    private synchronized native void _setField(CPtr var1, int var2, String var3);

    private synchronized native void _setGlobal(CPtr var1, String var2);

    private synchronized native int _setMetaTable(CPtr var1, int var2);

    private synchronized native void _setTable(CPtr var1, int var2);

    private synchronized native void _setTop(CPtr var1, int var2);

    private synchronized native int _status(CPtr var1);

    private synchronized native int _strlen(CPtr var1, int var2);

    private synchronized native int _toBoolean(CPtr var1, int var2);

    private synchronized native int _toInteger(CPtr var1, int var2);

    private synchronized native double _toNumber(CPtr var1, int var2);

    private synchronized native String _toString(CPtr var1, int var2);

    private synchronized native CPtr _toThread(CPtr var1, int var2);

    private synchronized native int _type(CPtr var1, int var2);

    private synchronized native String _typeName(CPtr var1, int var2);

    private synchronized native void _xmove(CPtr var1, CPtr var2, int var3);

    private synchronized native int _yield(CPtr var1, int var2);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Number convertYayaNumber(Double d2, Class clazz) {
        void var2_3;
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                Integer n2 = new Integer(d2.intValue());
                return var2_3;
            }
            if (clazz == Long.TYPE) {
                return new Long(d2.longValue());
            }
            if (clazz == Float.TYPE) {
                return new Float(d2.floatValue());
            }
            Double d3 = d2;
            if (clazz == Double.TYPE) return var2_3;
            if (clazz == Byte.TYPE) {
                return new Byte(d2.byteValue());
            }
            if (clazz != Short.TYPE) return null;
            return new Short(d2.shortValue());
        }
        if (!clazz.isAssignableFrom(Number.class)) return null;
        if (clazz.isAssignableFrom(Integer.class)) {
            return new Integer(d2.intValue());
        }
        if (clazz.isAssignableFrom(Long.class)) {
            return new Long(d2.longValue());
        }
        if (clazz.isAssignableFrom(Float.class)) {
            return new Float(d2.floatValue());
        }
        Double d4 = d2;
        if (clazz.isAssignableFrom(Double.class)) return var2_3;
        if (clazz.isAssignableFrom(Byte.class)) {
            return new Byte(d2.byteValue());
        }
        if (!clazz.isAssignableFrom(Short.class)) return null;
        return new Short(d2.shortValue());
    }

    public int LargError(int n2, String string2) {
        return this._LargError(this.yayaState, n2, string2);
    }

    public int LcallMeta(int n2, String string2) {
        return this._LcallMeta(this.yayaState, n2, string2);
    }

    public void LcheckAny(int n2) {
        this._LcheckAny(this.yayaState, n2);
    }

    public int LcheckInteger(int n2) {
        return this._LcheckInteger(this.yayaState, n2);
    }

    public double LcheckNumber(int n2) {
        return this._LcheckNumber(this.yayaState, n2);
    }

    public void LcheckStack(int n2, String string2) {
        this._LcheckStack(this.yayaState, n2, string2);
    }

    public String LcheckString(int n2) {
        return this._LcheckString(this.yayaState, n2);
    }

    public void LcheckType(int n2, int n3) {
        this._LcheckType(this.yayaState, n2, n3);
    }

    public int LdoFile(String string2) {
        return this._LdoFile(this.yayaState, string2);
    }

    public int LdoString(String string2) {
        return this._LdoString(this.yayaState, string2);
    }

    public String LfindTable(int n2, String string2, int n3) {
        return this._LfindTable(this.yayaState, n2, string2, n3);
    }

    public int LgetMetaField(int n2, String string2) {
        return this._LgetMetaField(this.yayaState, n2, string2);
    }

    public void LgetMetatable(String string2) {
        this._LgetMetatable(this.yayaState, string2);
    }

    public int LgetN(int n2) {
        return this._LgetN(this.yayaState, n2);
    }

    public String Lgsub(String string2, String string3, String string4) {
        return this._Lgsub(this.yayaState, string2, string3, string4);
    }

    public int LloadBuffer(byte[] byArray, String string2) {
        return this._LloadBuffer(this.yayaState, byArray, byArray.length, string2);
    }

    public int LloadFile(String string2) {
        return this._LloadFile(this.yayaState, string2);
    }

    public int LloadString(String string2) {
        return this._LloadString(this.yayaState, string2);
    }

    public int LnewMetatable(String string2) {
        return this._LnewMetatable(this.yayaState, string2);
    }

    public int LoptInteger(int n2, int n3) {
        return this._LoptInteger(this.yayaState, n2, n3);
    }

    public double LoptNumber(int n2, double d2) {
        return this._LoptNumber(this.yayaState, n2, d2);
    }

    public String LoptString(int n2, String string2) {
        return this._LoptString(this.yayaState, n2, string2);
    }

    public int Lref(int n2) {
        return this._Lref(this.yayaState, n2);
    }

    public void LsetN(int n2, int n3) {
        this._LsetN(this.yayaState, n2, n3);
    }

    public int Ltyperror(int n2, String string2) {
        return this._Ltyperror(this.yayaState, n2, string2);
    }

    public void LunRef(int n2, int n3) {
        this._LunRef(this.yayaState, n2, n3);
    }

    public void Lwhere(int n2) {
        this._Lwhere(this.yayaState, n2);
    }

    public void call(int n2, int n3) {
        this._call(this.yayaState, n2, n3);
    }

    public int checkStack(int n2) {
        return this._checkStack(this.yayaState, n2);
    }

    public void close() {
        synchronized (this) {
            YayaStateFactory.removeYayaState(this.stateId);
            this._close(this.yayaState);
            this.yayaState = null;
            return;
        }
    }

    public void concat(int n2) {
        this._concat(this.yayaState, n2);
    }

    public void createTable(int n2, int n3) {
        this._createTable(this.yayaState, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String dumpStack() {
        int n2 = this.getTop();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 1;
        while (n3 <= n2) {
            int n4 = this.type(n3);
            stringBuilder.append(n3).append(": ").append(this.typeName(n4));
            if (n4 == 3) {
                stringBuilder.append(" = ").append(this.toNumber(n3));
            } else if (n4 == 4) {
                stringBuilder.append(" = '").append(this.toString(n3)).append("'");
            }
            stringBuilder.append("\n");
            ++n3;
        }
        return stringBuilder.toString();
    }

    public int equal(int n2, int n3) {
        return this._equal(this.yayaState, n2, n3);
    }

    public int error() {
        return this._error(this.yayaState);
    }

    public int gc(int n2, int n3) {
        return this._gc(this.yayaState, n2, n3);
    }

    public long getCPtrPeer() {
        if (this.yayaState != null) {
            return this.yayaState.getPeer();
        }
        return 0L;
    }

    public void getFEnv(int n2) {
        this._getFEnv(this.yayaState, n2);
    }

    public void getField(int n2, String string2) {
        this._getField(this.yayaState, n2, string2);
    }

    public int getGcCount() {
        return this._getGcCount(this.yayaState);
    }

    public void getGlobal(String string2) {
        synchronized (this) {
            this._getGlobal(this.yayaState, string2);
            return;
        }
    }

    public int getMetaTable(int n2) {
        return this._getMetaTable(this.yayaState, n2);
    }

    public Object getObjectFromUserdata(int n2) throws YayaException {
        return this._getObjectFromUserdata(this.yayaState, n2);
    }

    public void getTable(int n2) {
        this._getTable(this.yayaState, n2);
    }

    public int getTop() {
        return this._getTop(this.yayaState);
    }

    public YayaObject getYayaObject(int n2) {
        return new YayaObject(this, n2);
    }

    public YayaObject getYayaObject(YayaObject yayaObject, YayaObject yayaObject2) throws YayaException {
        if (yayaObject.getYayaState().getCPtrPeer() != this.yayaState.getPeer() || yayaObject.getYayaState().getCPtrPeer() != yayaObject2.getYayaState().getCPtrPeer()) {
            throw new YayaException("Object must have the same YayaState as the parent!");
        }
        return new YayaObject(yayaObject, yayaObject2);
    }

    public YayaObject getYayaObject(YayaObject yayaObject, Number number) throws YayaException {
        if (yayaObject.L.getCPtrPeer() != this.yayaState.getPeer()) {
            throw new YayaException("Object must have the same YayaState as the parent!");
        }
        return new YayaObject(yayaObject, number);
    }

    public YayaObject getYayaObject(YayaObject yayaObject, String string2) throws YayaException {
        if (yayaObject.L.getCPtrPeer() != this.yayaState.getPeer()) {
            throw new YayaException("Object must have the same YayaState as the parent!");
        }
        return new YayaObject(yayaObject, string2);
    }

    public YayaObject getYayaObject(String string2) {
        return new YayaObject(this, string2);
    }

    public void insert(int n2) {
        this._insert(this.yayaState, n2);
    }

    public boolean isBoolean(int n2) {
        return this._isBoolean(this.yayaState, n2) != 0;
    }

    public boolean isCFunction(int n2) {
        return this._isCFunction(this.yayaState, n2) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClosed() {
        synchronized (this) {
            CPtr cPtr = this.yayaState;
            if (cPtr != null) return false;
            return true;
        }
    }

    public boolean isFunction(int n2) {
        return this._isFunction(this.yayaState, n2) != 0;
    }

    public boolean isJavaFunction(int n2) {
        return this._isJavaFunction(this.yayaState, n2);
    }

    public boolean isNil(int n2) {
        return this._isNil(this.yayaState, n2) != 0;
    }

    public boolean isNone(int n2) {
        return this._isNone(this.yayaState, n2) != 0;
    }

    public boolean isNoneOrNil(int n2) {
        return this._isNoneOrNil(this.yayaState, n2) != 0;
    }

    public boolean isNumber(int n2) {
        return this._isNumber(this.yayaState, n2) != 0;
    }

    public boolean isObject(int n2) {
        return this._isObject(this.yayaState, n2);
    }

    public boolean isString(int n2) {
        return this._isString(this.yayaState, n2) != 0;
    }

    public boolean isTable(int n2) {
        return this._isTable(this.yayaState, n2) != 0;
    }

    public boolean isThread(int n2) {
        return this._isThread(this.yayaState, n2) != 0;
    }

    public boolean isUserdata(int n2) {
        return this._isUserdata(this.yayaState, n2) != 0;
    }

    public int lessthan(int n2, int n3) {
        return this._lessthan(this.yayaState, n2, n3);
    }

    public void newTable() {
        this._newTable(this.yayaState);
    }

    public YayaLib newThread() {
        YayaLib yayaLib = new YayaLib(this._newthread(this.yayaState));
        YayaStateFactory.insertYayaState(yayaLib);
        return yayaLib;
    }

    public int next(int n2) {
        return this._next(this.yayaState, n2);
    }

    public int objLen(int n2) {
        return this._objlen(this.yayaState, n2);
    }

    public void openBase() {
        this._openBase(this.yayaState);
    }

    public void openDebug() {
        this._openDebug(this.yayaState);
    }

    public void openIo() {
        this._openIo(this.yayaState);
    }

    public void openLibs() {
        this._openLibs(this.yayaState);
    }

    public void openMath() {
        this._openMath(this.yayaState);
    }

    public void openOs() {
        this._openOs(this.yayaState);
    }

    public void openPackage() {
        this._openPackage(this.yayaState);
    }

    public void openString() {
        this._openString(this.yayaState);
    }

    public void openTable() {
        this._openTable(this.yayaState);
    }

    public int pcall(int n2, int n3, int n4) {
        return this._pcall(this.yayaState, n2, n3, n4);
    }

    public void pop(int n2) {
        this._pop(this.yayaState, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pushBoolean(boolean bl) {
        CPtr cPtr = this.yayaState;
        int n2 = bl ? 1 : 0;
        this._pushBoolean(cPtr, n2);
    }

    public void pushInteger(int n2) {
        this._pushInteger(this.yayaState, n2);
    }

    public void pushJavaFunction(JavaFunction javaFunction) throws YayaException {
        this._pushJavaFunction(this.yayaState, javaFunction);
    }

    public void pushJavaObject(Object object) {
        this._pushJavaObject(this.yayaState, object);
    }

    public void pushNil() {
        this._pushNil(this.yayaState);
    }

    public void pushNumber(double d2) {
        this._pushNumber(this.yayaState, d2);
    }

    public void pushObjectValue(Object object) throws YayaException {
        if (object == null) {
            this.pushNil();
            return;
        }
        if (object instanceof Boolean) {
            this.pushBoolean((Boolean)object);
            return;
        }
        if (object instanceof Number) {
            this.pushNumber(((Number)object).doubleValue());
            return;
        }
        if (object instanceof String) {
            this.pushString((String)object);
            return;
        }
        if (object instanceof JavaFunction) {
            this.pushJavaFunction((JavaFunction)object);
            return;
        }
        if (object instanceof YayaObject) {
            ((YayaObject)object).push();
            return;
        }
        if (object instanceof byte[]) {
            this.pushString((byte[])object);
            return;
        }
        this.pushJavaObject(object);
    }

    public void pushString(String string2) {
        if (string2 == null) {
            this._pushNil(this.yayaState);
            return;
        }
        this._pushString(this.yayaState, string2);
    }

    public void pushString(byte[] byArray) {
        if (byArray == null) {
            this._pushNil(this.yayaState);
            return;
        }
        this._pushString(this.yayaState, byArray, byArray.length);
    }

    public void pushValue(int n2) {
        this._pushValue(this.yayaState, n2);
    }

    public void rawGet(int n2) {
        this._rawGet(this.yayaState, n2);
    }

    public void rawGetI(int n2, int n3) {
        this._rawGetI(this.yayaState, n2, n3);
    }

    public void rawSet(int n2) {
        this._rawSet(this.yayaState, n2);
    }

    public void rawSetI(int n2, int n3) {
        this._rawSetI(this.yayaState, n2, n3);
    }

    public int rawequal(int n2, int n3) {
        return this._rawequal(this.yayaState, n2, n3);
    }

    public void remove(int n2) {
        this._remove(this.yayaState, n2);
    }

    public void replace(int n2) {
        this._replace(this.yayaState, n2);
    }

    public int resume(int n2) {
        return this._resume(this.yayaState, n2);
    }

    public int setFEnv(int n2) {
        return this._setFEnv(this.yayaState, n2);
    }

    public void setField(int n2, String string2) {
        this._setField(this.yayaState, n2, string2);
    }

    public void setGlobal(String string2) {
        synchronized (this) {
            this._setGlobal(this.yayaState, string2);
            return;
        }
    }

    public int setMetaTable(int n2) {
        return this._setMetaTable(this.yayaState, n2);
    }

    public void setTable(int n2) {
        this._setTable(this.yayaState, n2);
    }

    public void setTop(int n2) {
        this._setTop(this.yayaState, n2);
    }

    public int status() {
        return this._status(this.yayaState);
    }

    public int strLen(int n2) {
        return this._strlen(this.yayaState, n2);
    }

    public boolean toBoolean(int n2) {
        return this._toBoolean(this.yayaState, n2) != 0;
    }

    public int toInteger(int n2) {
        return this._toInteger(this.yayaState, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object toJavaObject(int n2) throws YayaException {
        Object var4_2 = null;
        synchronized (this) {
            if (this.isBoolean(n2)) {
                return new Boolean(this.toBoolean(n2));
            }
            if (this.type(n2) == 4) {
                return this.toString(n2);
            }
            if (this.isFunction(n2)) {
                return this.getYayaObject(n2);
            }
            if (this.isTable(n2)) {
                return this.getYayaObject(n2);
            }
            if (this.type(n2) == 3) {
                return new Double(this.toNumber(n2));
            }
            if (this.isUserdata(n2)) {
                if (!this.isObject(n2)) return this.getYayaObject(n2);
                return this.getObjectFromUserdata(n2);
            }
            boolean bl = this.isNil(n2);
            Object var3_3 = var4_2;
            if (!bl) return var3_3;
            return var4_2;
        }
    }

    public double toNumber(int n2) {
        return this._toNumber(this.yayaState, n2);
    }

    public String toString(int n2) {
        return this._toString(this.yayaState, n2);
    }

    public YayaLib toThread(int n2) {
        return new YayaLib(this._toThread(this.yayaState, n2));
    }

    public int type(int n2) {
        return this._type(this.yayaState, n2);
    }

    public String typeName(int n2) {
        return this._typeName(this.yayaState, n2);
    }

    public void xmove(YayaLib yayaLib, int n2) {
        this._xmove(this.yayaState, yayaLib.yayaState, n2);
    }

    public int yield(int n2) {
        return this._yield(this.yayaState, n2);
    }
}

