/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.mobclickcpp;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.umeng.mobclickcpp.Cocos2dxHelper;
import com.umeng.mobclickcpp.DeviceConfig;
import com.umeng.mobclickcpp.IDFA;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MobClickCppHelper {
    private static String Access;
    private static String AndroidId;
    private static String AppName;
    private static String AppVersion;
    private static String Board;
    private static String Brand;
    private static String Carrier;
    private static String Country;
    private static String Cpu;
    private static String DeviceId;
    private static String GpuRender;
    private static String GpuVender;
    private static String IMEI;
    private static String IdMd5;
    private static String Language;
    private static String Mac;
    private static String Manufacturer;
    private static String Manuid;
    private static long Manutime;
    private static String Model;
    private static String Name;
    private static String OsVersion;
    private static String Package;
    private static String Resolution;
    private static String Serial;
    private static String Signature;
    private static String SubAccess;
    private static int Timezone;
    private static String UTDId;
    private static String VersionCode;
    private static String idfa;
    private static Context mCtx;

    static {
        mCtx = null;
        Log.d((String)"umeng", (String)"loadLibrary");
        System.loadLibrary("mobclickcpp");
    }

    public static String getAccess() {
        return Access;
    }

    public static String getAndroidId() {
        return AndroidId;
    }

    public static String getAppName() {
        return AppName;
    }

    public static String getAppVersion() {
        return AppVersion;
    }

    public static String getBoard() {
        return Board;
    }

    public static String getBrand() {
        return Brand;
    }

    public static String getCarrier() {
        return Carrier;
    }

    public static String getCountry() {
        return Country;
    }

    public static String getCpu() {
        return Cpu;
    }

    public static String getDeviceId() {
        DeviceId = DeviceConfig.getDeviceId(mCtx);
        return DeviceId;
    }

    public static String getGpuRender() {
        return GpuRender;
    }

    public static String getGpuVender() {
        return GpuVender;
    }

    public static String getIDFA() {
        return idfa;
    }

    public static String getIMEI() {
        return IMEI;
    }

    public static String getIdMd5() {
        return IdMd5;
    }

    public static String getLanguage() {
        return Language;
    }

    public static String getMac() {
        Mac = DeviceConfig.getMac(mCtx);
        return Mac;
    }

    public static String getManufacturer() {
        return Manufacturer;
    }

    public static String getManuid() {
        return Manuid;
    }

    public static long getManutime() {
        return Manutime;
    }

    public static String getModel() {
        return Model;
    }

    public static String getName() {
        return Name;
    }

    public static String getOsVersion() {
        return OsVersion;
    }

    public static String getPackage() {
        return Package;
    }

    public static String getResolution() {
        return Resolution;
    }

    public static String getSerial() {
        return Serial;
    }

    public static String getSignature() {
        return Signature;
    }

    public static String getSubAccess() {
        return SubAccess;
    }

    public static String getTimezone() {
        return String.format("%d", Timezone);
    }

    public static String getUTDId() {
        return UTDId;
    }

    public static String getVersionCode() {
        return VersionCode;
    }

    public static void init(Context stringArray) {
        System.loadLibrary("mobclickcpp");
        Cocos2dxHelper.init((Context)stringArray, null);
        mCtx = stringArray.getApplicationContext();
        IdMd5 = DeviceConfig.getDeviceIdUmengMD5(mCtx);
        Model = Build.MODEL;
        OsVersion = Build.VERSION.RELEASE;
        Resolution = DeviceConfig.getResolution(mCtx);
        Cpu = DeviceConfig.getCPU();
        Board = Build.BOARD;
        Brand = Build.BRAND;
        Manutime = Build.TIME;
        Manufacturer = Build.MANUFACTURER;
        Manuid = Build.ID;
        Name = Build.DEVICE;
        AppVersion = DeviceConfig.getAppVersionName(mCtx);
        VersionCode = DeviceConfig.getAppVersionCode(mCtx);
        Package = DeviceConfig.getPackageName(mCtx);
        AppName = DeviceConfig.getApplicationLable(mCtx);
        Timezone = DeviceConfig.getTimeZone(mCtx);
        stringArray = DeviceConfig.getLocaleInfo(mCtx);
        Country = stringArray[0];
        Language = stringArray[1];
        stringArray = DeviceConfig.getNetworkAccessMode(mCtx);
        Access = stringArray[0];
        SubAccess = stringArray[1];
        Carrier = DeviceConfig.getOperator(mCtx);
        AndroidId = AndroidIdGetter.getAndroidId();
        IMEI = IMEIGetter.getIMEI();
        UTDId = UTDIdGetter.readUTDId();
        Serial = SerialGetter.getSerial();
        new Thread(new Runnable(){

            @Override
            public void run() {
                idfa = IDFA.getIdfa(mCtx);
            }
        }).start();
        Signature = DeviceConfig.getSign(mCtx);
    }

    public static void loadLibrary() {
        Log.d((String)"umeng", (String)"loadLibrary did nothing");
    }

    public static void setCheckDevice(boolean bl) {
        DeviceConfig.setCheckDevice(bl);
    }

    private static class AndroidIdGetter {
        private AndroidIdGetter() {
        }

        private static String getAndroidId() {
            try {
                String string2 = Settings.Secure.getString((ContentResolver)mCtx.getContentResolver(), (String)"android_id");
                return string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    private static class IMEIGetter {
        private IMEIGetter() {
        }

        private static String getIMEI() {
            String string2 = null;
            TelephonyManager telephonyManager = (TelephonyManager)mCtx.getSystemService("phone");
            try {
                if (DeviceConfig.checkPermission(mCtx, "android.permission.READ_PHONE_STATE")) {
                    string2 = telephonyManager.getDeviceId();
                }
                return string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    private static class SerialGetter {
        private SerialGetter() {
        }

        @SuppressLint(value={"NewApi"})
        public static String getSerial() {
            if (Build.VERSION.SDK_INT >= 9) {
                return Build.SERIAL;
            }
            return null;
        }
    }

    private static class UTDIdGetter {
        private UTDIdGetter() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static File getFile() {
            if (!DeviceConfig.checkPermission(mCtx, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                return null;
            }
            if (!Environment.getExternalStorageState().equals("mounted")) return null;
            File file = Environment.getExternalStorageDirectory();
            try {
                return new File(file.getCanonicalPath(), ".UTSystemConfig/Global/Alvin2.xml");
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private static String parseId(String object) {
            if (object == null || !((Matcher)(object = Pattern.compile("UTDID\">([^<]+)").matcher((CharSequence)object))).find()) {
                return null;
            }
            return ((Matcher)object).group(1);
        }

        private static String readStreamToString(InputStream closeable) throws IOException {
            closeable = new InputStreamReader((InputStream)closeable);
            char[] cArray = new char[1024];
            StringWriter stringWriter = new StringWriter();
            int n2;
            while (-1 != (n2 = ((Reader)closeable).read(cArray))) {
                stringWriter.write(cArray, 0, n2);
            }
            return stringWriter.toString();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String readUTDId() {
            String string2 = null;
            Object object = UTDIdGetter.getFile();
            String string3 = string2;
            if (object == null) return string3;
            if (!((File)object).exists()) {
                return string2;
            }
            object = new FileInputStream((File)object);
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    return null;
                }
                try {
                    string3 = string2 = UTDIdGetter.parseId(UTDIdGetter.readStreamToString((InputStream)object));
                    if (object == null) return string3;
                }
                catch (Throwable throwable) {}
                if (object == null) throw throwable;
                try {
                    ((FileInputStream)object).close();
                }
                catch (Exception exception) {
                    throw throwable;
                }
                {
                    throw throwable;
                }
                try {
                    ((FileInputStream)object).close();
                    return string2;
                }
                catch (Exception exception) {
                    return string2;
                }
            }
        }
    }
}

