/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.mobclickcpp;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Process;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class Cocos2dxHelper {
    private static final String PREFS_NAME = "UmengPrefsFile";
    private static boolean sAccelerometerEnabled;
    private static AssetManager sAssetManager;
    private static Cocos2dxHelperListener sCocos2dxHelperListener;
    private static Context sContext;
    private static String sFileDirectory;
    private static String sPackageName;

    static {
        sContext = null;
    }

    public static AssetManager getAssetManager() {
        return sAssetManager;
    }

    public static boolean getBoolForKey(String string2, boolean bl) {
        return ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).getBoolean(string2, bl);
    }

    public static String getCocos2dxPackageName() {
        return sPackageName;
    }

    public static String getCocos2dxWritablePath() {
        return sFileDirectory;
    }

    public static String getCurrentLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static int getDPI() {
        if (sContext != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = ((Activity)sContext).getWindowManager();
            if (windowManager != null && (windowManager = windowManager.getDefaultDisplay()) != null) {
                windowManager.getMetrics(displayMetrics);
                return (int)(displayMetrics.density * 160.0f);
            }
        }
        return -1;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static double getDoubleForKey(String string2, double d2) {
        return ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).getFloat(string2, (float)d2);
    }

    public static float getFloatForKey(String string2, float f2) {
        return ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).getFloat(string2, f2);
    }

    public static int getIntegerForKey(String string2, int n2) {
        return ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).getInt(string2, n2);
    }

    public static String getStringForKey(String string2, String string3) {
        return ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).getString(string2, string3);
    }

    public static void init(Context context, Cocos2dxHelperListener cocos2dxHelperListener) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        sContext = context;
        sCocos2dxHelperListener = cocos2dxHelperListener;
        sPackageName = applicationInfo.packageName;
        sFileDirectory = context.getFilesDir().getAbsolutePath();
        Cocos2dxHelper.nativeSetApkPath(applicationInfo.sourceDir);
        Cocos2dxHelper.nativeSetContext(context);
        sAssetManager = context.getAssets();
    }

    private static native void nativeSetApkPath(String var0);

    private static native void nativeSetContext(Context var0);

    private static native void nativeSetEditTextDialogResult(byte[] var0);

    public static void setBoolForKey(String string2, boolean bl) {
        SharedPreferences.Editor editor = ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putBoolean(string2, bl);
        editor.commit();
    }

    public static void setDoubleForKey(String string2, double d2) {
        SharedPreferences.Editor editor = ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putFloat(string2, (float)d2);
        editor.commit();
    }

    public static void setEditTextDialogResult(String object) {
        try {
            object = ((String)object).getBytes("UTF8");
            sCocos2dxHelperListener.runOnGLThread(new Runnable((byte[])object){
                private final /* synthetic */ byte[] val$bytesUTF8;
                {
                    this.val$bytesUTF8 = byArray;
                }

                @Override
                public void run() {
                    Cocos2dxHelper.nativeSetEditTextDialogResult(this.val$bytesUTF8);
                }
            });
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    public static void setFloatForKey(String string2, float f2) {
        SharedPreferences.Editor editor = ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putFloat(string2, f2);
        editor.commit();
    }

    public static void setIntegerForKey(String string2, int n2) {
        SharedPreferences.Editor editor = ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putInt(string2, n2);
        editor.commit();
    }

    public static void setStringForKey(String string2, String string3) {
        SharedPreferences.Editor editor = ((Activity)sContext).getSharedPreferences(PREFS_NAME, 0).edit();
        editor.putString(string2, string3);
        editor.commit();
    }

    private static void showDialog(String string2, String string3) {
        sCocos2dxHelperListener.showDialog(string2, string3);
    }

    private static void showEditTextDialog(String string2, String string3, int n2, int n3, int n4, int n5) {
        sCocos2dxHelperListener.showEditTextDialog(string2, string3, n2, n3, n4, n5);
    }

    public static void terminateProcess() {
        Process.killProcess((int)Process.myPid());
    }

    public static interface Cocos2dxHelperListener {
        public void runOnGLThread(Runnable var1);

        public void showDialog(String var1, String var2);

        public void showEditTextDialog(String var1, String var2, int var3, int var4, int var5, int var6);
    }
}

