/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.modelmsg;

import android.graphics.Bitmap;
import android.os.Bundle;
import com.tencent.mm.sdk.b.b;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class WXMediaMessage {
    public static final String ACTION_WXAPPMESSAGE = "com.tencent.mm.sdk.openapi.Intent.ACTION_WXAPPMESSAGE";
    private static final int DESCRIPTION_LENGTH_LIMIT = 1024;
    private static final int MEDIA_TAG_NAME_LENGTH_LIMIT = 64;
    private static final int MESSAGE_ACTION_LENGTH_LIMIT = 2048;
    private static final int MESSAGE_EXT_LENGTH_LIMIT = 2048;
    private static final String TAG = "MicroMsg.SDK.WXMediaMessage";
    public static final int THUMB_LENGTH_LIMIT = 32768;
    private static final int TITLE_LENGTH_LIMIT = 512;
    public String description;
    public IMediaObject mediaObject;
    public String mediaTagName;
    public String messageAction;
    public String messageExt;
    public int sdkVer;
    public byte[] thumbData;
    public String title;

    public WXMediaMessage() {
        this(null);
    }

    public WXMediaMessage(IMediaObject iMediaObject) {
        this.mediaObject = iMediaObject;
    }

    final boolean checkArgs() {
        if (this.getType() == 8 && (this.thumbData == null || this.thumbData.length == 0)) {
            b.b(TAG, "checkArgs fail, thumbData should not be null when send emoji");
            return false;
        }
        if (this.thumbData != null && this.thumbData.length > 32768) {
            b.b(TAG, "checkArgs fail, thumbData is invalid");
            return false;
        }
        if (this.title != null && this.title.length() > 512) {
            b.b(TAG, "checkArgs fail, title is invalid");
            return false;
        }
        if (this.description != null && this.description.length() > 1024) {
            b.b(TAG, "checkArgs fail, description is invalid");
            return false;
        }
        if (this.mediaObject == null) {
            b.b(TAG, "checkArgs fail, mediaObject is null");
            return false;
        }
        if (this.mediaTagName != null && this.mediaTagName.length() > 64) {
            b.b(TAG, "checkArgs fail, mediaTagName is too long");
            return false;
        }
        if (this.messageAction != null && this.messageAction.length() > 2048) {
            b.b(TAG, "checkArgs fail, messageAction is too long");
            return false;
        }
        if (this.messageExt != null && this.messageExt.length() > 2048) {
            b.b(TAG, "checkArgs fail, messageExt is too long");
            return false;
        }
        return this.mediaObject.checkArgs();
    }

    public final int getType() {
        if (this.mediaObject == null) {
            return 0;
        }
        return this.mediaObject.type();
    }

    public final void setThumbImage(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.thumbData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            b.b(TAG, "put thumb failed");
            return;
        }
    }

    public static class Builder {
        public static final String KEY_IDENTIFIER = "_wxobject_identifier_";

        public static WXMediaMessage fromBundle(Bundle bundle) {
            WXMediaMessage wXMediaMessage = new WXMediaMessage();
            wXMediaMessage.sdkVer = bundle.getInt("_wxobject_sdkVer");
            wXMediaMessage.title = bundle.getString("_wxobject_title");
            wXMediaMessage.description = bundle.getString("_wxobject_description");
            wXMediaMessage.thumbData = bundle.getByteArray("_wxobject_thumbdata");
            wXMediaMessage.mediaTagName = bundle.getString("_wxobject_mediatagname");
            wXMediaMessage.messageAction = bundle.getString("_wxobject_message_action");
            wXMediaMessage.messageExt = bundle.getString("_wxobject_message_ext");
            String string2 = Builder.pathOldToNew(bundle.getString(KEY_IDENTIFIER));
            if (string2 == null || string2.length() <= 0) {
                return wXMediaMessage;
            }
            try {
                wXMediaMessage.mediaObject = (IMediaObject)Class.forName(string2).newInstance();
                wXMediaMessage.mediaObject.unserialize(bundle);
                return wXMediaMessage;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                b.b(WXMediaMessage.TAG, "get media object from bundle failed: unknown ident " + string2 + ", ex = " + exception.getMessage());
                return wXMediaMessage;
            }
        }

        private static String pathNewToOld(String string2) {
            if (string2 == null || string2.length() == 0) {
                b.b(WXMediaMessage.TAG, "pathNewToOld fail, newPath is null");
                return string2;
            }
            return string2.replace("com.tencent.mm.sdk.modelmsg", "com.tencent.mm.sdk.openapi");
        }

        private static String pathOldToNew(String string2) {
            if (string2 == null || string2.length() == 0) {
                b.b(WXMediaMessage.TAG, "pathOldToNew fail, oldPath is null");
                return string2;
            }
            return string2.replace("com.tencent.mm.sdk.openapi", "com.tencent.mm.sdk.modelmsg");
        }

        public static Bundle toBundle(WXMediaMessage wXMediaMessage) {
            Bundle bundle = new Bundle();
            bundle.putInt("_wxobject_sdkVer", wXMediaMessage.sdkVer);
            bundle.putString("_wxobject_title", wXMediaMessage.title);
            bundle.putString("_wxobject_description", wXMediaMessage.description);
            bundle.putByteArray("_wxobject_thumbdata", wXMediaMessage.thumbData);
            if (wXMediaMessage.mediaObject != null) {
                bundle.putString(KEY_IDENTIFIER, Builder.pathNewToOld(wXMediaMessage.mediaObject.getClass().getName()));
                wXMediaMessage.mediaObject.serialize(bundle);
            }
            bundle.putString("_wxobject_mediatagname", wXMediaMessage.mediaTagName);
            bundle.putString("_wxobject_message_action", wXMediaMessage.messageAction);
            bundle.putString("_wxobject_message_ext", wXMediaMessage.messageExt);
            return bundle;
        }
    }

    public static interface IMediaObject {
        public static final int TYPE_APPDATA = 7;
        public static final int TYPE_CARD_SHARE = 16;
        public static final int TYPE_DESIGNER_SHARED = 25;
        public static final int TYPE_DEVICE_ACCESS = 12;
        public static final int TYPE_EMOJI = 8;
        public static final int TYPE_EMOTICON_GIFT = 11;
        public static final int TYPE_EMOTICON_SHARED = 15;
        public static final int TYPE_FILE = 6;
        public static final int TYPE_IMAGE = 2;
        public static final int TYPE_LOCATION_SHARE = 17;
        public static final int TYPE_MALL_PRODUCT = 13;
        public static final int TYPE_MUSIC = 3;
        public static final int TYPE_OLD_TV = 14;
        public static final int TYPE_PRODUCT = 10;
        public static final int TYPE_RECORD = 19;
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_TV = 20;
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_URL = 5;
        public static final int TYPE_VIDEO = 4;

        public boolean checkArgs();

        public void serialize(Bundle var1);

        public int type();

        public void unserialize(Bundle var1);
    }
}

