/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.sdk.b.b;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage;
import java.io.File;

public class WXFileObject
implements WXMediaMessage.IMediaObject {
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private static final String TAG = "MicroMsg.SDK.WXFileObject";
    private int contentLengthLimit = 0xA00000;
    public byte[] fileData;
    public String filePath;

    public WXFileObject() {
        this.fileData = null;
        this.filePath = null;
    }

    public WXFileObject(String string2) {
        this.filePath = string2;
    }

    public WXFileObject(byte[] byArray) {
        this.fileData = byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getFileSize(String object) {
        if (object == null || ((String)object).length() == 0 || !((File)(object = new File((String)object))).exists()) {
            return 0;
        }
        return (int)((File)object).length();
    }

    @Override
    public boolean checkArgs() {
        if (!(this.fileData != null && this.fileData.length != 0 || this.filePath != null && this.filePath.length() != 0)) {
            b.b(TAG, "checkArgs fail, both arguments is null");
            return false;
        }
        if (this.fileData != null && this.fileData.length > this.contentLengthLimit) {
            b.b(TAG, "checkArgs fail, fileData is too large");
            return false;
        }
        if (this.filePath != null && this.getFileSize(this.filePath) > this.contentLengthLimit) {
            b.b(TAG, "checkArgs fail, fileSize is too large");
            return false;
        }
        return true;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wxfileobject_fileData", this.fileData);
        bundle.putString("_wxfileobject_filePath", this.filePath);
    }

    public void setContentLengthLimit(int n2) {
        this.contentLengthLimit = n2;
    }

    public void setFileData(byte[] byArray) {
        this.fileData = byArray;
    }

    public void setFilePath(String string2) {
        this.filePath = string2;
    }

    @Override
    public int type() {
        return 6;
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.fileData = bundle.getByteArray("_wxfileobject_fileData");
        this.filePath = bundle.getString("_wxfileobject_filePath");
    }
}

