/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.modelbiz;

import android.os.Bundle;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class AddCardToWXCardPackage {

    public static class Req
    extends BaseReq {
        public List<WXCardItem> cardArrary;

        @Override
        public boolean checkArgs() {
            if (this.cardArrary == null || this.cardArrary.size() == 0 || this.cardArrary.size() > 40) {
                return false;
            }
            for (WXCardItem wXCardItem : this.cardArrary) {
                if (wXCardItem != null && wXCardItem.cardId != null && wXCardItem.cardId.length() <= 1024 && (wXCardItem.cardExtMsg == null || wXCardItem.cardExtMsg.length() <= 1024)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getType() {
            return 9;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            JSONStringer jSONStringer = new JSONStringer();
            try {
                jSONStringer.object();
                jSONStringer.key("card_list");
                jSONStringer.array();
                for (Object object : this.cardArrary) {
                    jSONStringer.object();
                    jSONStringer.key("card_id");
                    jSONStringer.value((Object)((WXCardItem)object).cardId);
                    jSONStringer.key("card_ext");
                    object = ((WXCardItem)object).cardExtMsg == null ? "" : ((WXCardItem)object).cardExtMsg;
                    jSONStringer.value(object);
                    jSONStringer.endObject();
                }
                jSONStringer.endArray();
                jSONStringer.endObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bundle.putString("_wxapi_add_card_to_wx_card_list", jSONStringer.toString());
        }
    }

    public static class Resp
    extends BaseResp {
        public List<WXCardItem> cardArrary;

        public Resp() {
        }

        public Resp(Bundle bundle) {
            this.fromBundle(bundle);
        }

        @Override
        public boolean checkArgs() {
            return this.cardArrary != null && this.cardArrary.size() != 0;
        }

        @Override
        public void fromBundle(Bundle object) {
            super.fromBundle((Bundle)object);
            if (this.cardArrary == null) {
                this.cardArrary = new LinkedList<WXCardItem>();
            }
            if ((object = object.getString("_wxapi_add_card_to_wx_card_list")) != null && ((String)object).length() > 0) {
                int n2;
                try {
                    object = ((JSONObject)new JSONTokener((String)object).nextValue()).getJSONArray("card_list");
                    n2 = 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (true) {
                    if (n2 < object.length()) {
                        JSONObject jSONObject = object.getJSONObject(n2);
                        WXCardItem wXCardItem = new WXCardItem();
                        wXCardItem.cardId = jSONObject.optString("card_id");
                        wXCardItem.cardExtMsg = jSONObject.optString("card_ext");
                        wXCardItem.cardState = jSONObject.optInt("is_succ");
                        this.cardArrary.add(wXCardItem);
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        }

        @Override
        public int getType() {
            return 9;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            JSONStringer jSONStringer = new JSONStringer();
            try {
                jSONStringer.object();
                jSONStringer.key("card_list");
                jSONStringer.array();
                for (WXCardItem wXCardItem : this.cardArrary) {
                    jSONStringer.object();
                    jSONStringer.key("card_id");
                    jSONStringer.value((Object)wXCardItem.cardId);
                    jSONStringer.key("card_ext");
                    String string2 = wXCardItem.cardExtMsg == null ? "" : wXCardItem.cardExtMsg;
                    jSONStringer.value((Object)string2);
                    jSONStringer.key("is_succ");
                    jSONStringer.value((long)wXCardItem.cardState);
                    jSONStringer.endObject();
                }
                jSONStringer.endArray();
                jSONStringer.endObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bundle.putString("_wxapi_add_card_to_wx_card_list", jSONStringer.toString());
        }
    }

    public static final class WXCardItem {
        public String cardExtMsg;
        public String cardId;
        public int cardState;
    }
}

