/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.crashreport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tencent.bugly.Bugly;
import com.tencent.bugly.BuglyStrategy;
import com.tencent.bugly.CrashModule;
import com.tencent.bugly.crashreport.BuglyHintException;
import com.tencent.bugly.crashreport.biz.b;
import com.tencent.bugly.crashreport.common.info.a;
import com.tencent.bugly.crashreport.crash.h5.H5JavaScriptInterface;
import com.tencent.bugly.crashreport.crash.h5.c;
import com.tencent.bugly.crashreport.crash.jni.NativeCrashHandler;
import com.tencent.bugly.proguard.u;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CrashReport {
    private static Context a;
    private static Map<String, String> b;

    static {
        b = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeCrashReport() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not close crash report because bugly is disable.");
            } else if (!CrashModule.hasInitialized()) {
                Log.w((String)u.b, (String)"Report has not been initialed! pls to call method 'initCrashReport' first!");
            } else {
                com.tencent.bugly.crashreport.crash.c.a().d();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeNativeReport() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not close native report because bugly is disable.");
            } else {
                if (!CrashModule.hasInitialized()) {
                    throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
                }
                com.tencent.bugly.crashreport.crash.c.a().f();
            }
            return;
        }
    }

    public static void enableBugly(boolean bl) {
        Bugly.enable = bl;
        if (!bl) {
            CrashReport.closeCrashReport();
        }
    }

    public static Set<String> getAllUserDataKeys(Context context) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get all keys of user data because bugly is disable.");
            return new HashSet<String>();
        }
        if (context == null) {
            throw new BuglyHintException("getAllUserDataKeys args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).y();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAppChannel() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not get App channel because bugly is disable.");
                return "unknown";
            }
            if (CrashModule.hasInitialized()) return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).j;
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAppID() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not get App ID because bugly is disable.");
                return "unknown";
            }
            if (CrashModule.hasInitialized()) return com.tencent.bugly.crashreport.common.info.a.a(a).e();
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAppVer() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not get app version because bugly is disable.");
                return "unknown";
            }
            if (CrashModule.hasInitialized()) return com.tencent.bugly.crashreport.common.info.a.a((Context)CrashReport.a).i;
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
    }

    public static String getBuglyVersion(Context context) {
        if (context == null) {
            u.d("Please call with context.", new Object[0]);
            return "unknown";
        }
        com.tencent.bugly.crashreport.common.info.a.a(context);
        return com.tencent.bugly.crashreport.common.info.a.b();
    }

    public static Map<String, String> getSdkExtraData() {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserData(Context context, String string2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            throw new BuglyHintException("getUserDataValue args context should not be null");
        }
        if (string2 == null) return null;
        if (string2.trim().length() <= 0) return null;
        boolean bl = false;
        if (!bl) return com.tencent.bugly.crashreport.common.info.a.a(context).g(string2);
        return null;
    }

    public static int getUserDatasSize(Context context) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get size of user data because bugly is disable.");
            return -1;
        }
        if (context == null) {
            throw new BuglyHintException("getUserDatasSize args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).x();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUserId() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not get user ID because bugly is disable.");
                return "unknown";
            }
            if (CrashModule.hasInitialized()) return com.tencent.bugly.crashreport.common.info.a.a(a).f();
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
    }

    public static int getUserSceneTagId(Context context) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not get user scene tag because bugly is disable.");
            return -1;
        }
        if (context == null) {
            throw new BuglyHintException("getUserSceneTagId args context should not be null");
        }
        return com.tencent.bugly.crashreport.common.info.a.a(context).A();
    }

    public static void initCrashReport(Context context) {
        synchronized (CrashReport.class) {
            a = context;
            com.tencent.bugly.b.a(context);
            return;
        }
    }

    public static void initCrashReport(Context context, UserStrategy userStrategy) {
        synchronized (CrashReport.class) {
            a = context;
            com.tencent.bugly.b.a(context, userStrategy);
            return;
        }
    }

    public static void initCrashReport(Context context, String string2, boolean bl) {
        synchronized (CrashReport.class) {
            CrashReport.initCrashReport(context, string2, bl, null);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initCrashReport(Context context, String string2, boolean bl, UserStrategy userStrategy) {
        synchronized (CrashReport.class) {
            if (context == null) {
                return;
            }
            a = context;
            com.tencent.bugly.b.a(context, string2, bl, userStrategy);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLastSessionCrash() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"The info 'isLastSessionCrash' is not accurate because bugly is disable.");
                return false;
            }
            if (CrashModule.hasInitialized()) return com.tencent.bugly.crashreport.crash.c.a().b();
            throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void postCatchedException(Throwable throwable) {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not post crash caught because bugly is disable.");
            } else {
                if (!CrashModule.hasInitialized()) {
                    throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
                }
                if (throwable == null) {
                    u.d("throwable is null, just return", new Object[0]);
                } else {
                    com.tencent.bugly.crashreport.crash.c.a().a(Thread.currentThread(), throwable, false, null, null);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void putSdkData(Context context, String string2, String string3) {
        String string4;
        if (context == null) return;
        if (string2 == null) return;
        if (string2.trim().length() <= 0) return;
        boolean bl = false;
        if (bl) return;
        if (string3 == null) return;
        if (string3.trim().length() <= 0) return;
        bl = false;
        if (bl) {
            return;
        }
        string2 = string4 = string2.replace("[a-zA-Z[0-9]]+", "");
        if (string4.length() > 50) {
            Log.w((String)u.b, (String)String.format("putSdkData key length over limit %d, will be cutted.", 50));
            string2 = string4.substring(0, 50);
        }
        string4 = string3;
        if (string3.length() > 200) {
            Log.w((String)u.b, (String)String.format("putSdkData value length over limit %d, will be cutted!", 200));
            string4 = string3.substring(0, 200);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).b(string2, string4);
        Log.w((String)u.a, (String)String.format("[param] putSdkData data: %s - %s", string2, string4));
    }

    public static void putUserData(Context context, String object, String object2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not put user data because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)u.b, (String)"putUserData args context should not be null");
            return;
        }
        if (object == null) {
            String cfr_ignored_0 = (String)object;
            u.d("putUserData args key should not be null or empty", new Object[0]);
            return;
        }
        if (object2 == null) {
            String cfr_ignored_1 = (String)object2;
            u.d("putUserData args value should not be null", new Object[0]);
            return;
        }
        if (!((String)object).matches("[a-zA-Z[0-9]]+")) {
            u.d("putUserData args key should match [a-zA-Z[0-9]]+  {" + (String)object + "}", new Object[0]);
            return;
        }
        String string2 = object2;
        if (((String)object2).length() > 200) {
            u.d("user data value length over limit %d, it will be cutted!", 200);
            string2 = ((String)object2).substring(0, 200);
        }
        if (((a)(object2 = com.tencent.bugly.crashreport.common.info.a.a(context))).y().contains(object)) {
            object2 = NativeCrashHandler.getInstance();
            if (object2 != null) {
                ((NativeCrashHandler)object2).putKeyValueToNative((String)object, string2);
            }
            com.tencent.bugly.crashreport.common.info.a.a(context).a((String)object, string2);
            u.c("replace KV %s %s", object, string2);
            return;
        }
        if (((a)object2).x() >= 10) {
            u.d("user data size is over limit %d, it will be cutted!", 10);
            return;
        }
        object2 = object;
        if (((String)object).length() > 50) {
            u.d("user data key length over limit %d , will drop this new key %s", 50, object);
            object2 = ((String)object).substring(0, 50);
        }
        if ((object = NativeCrashHandler.getInstance()) != null) {
            ((NativeCrashHandler)object).putKeyValueToNative((String)object2, string2);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a((String)object2, string2);
        u.b("[param] set user data: %s - %s", object2, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String removeUserData(Context context, String string2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not remove user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            throw new BuglyHintException("removeUserData args context should not be null");
        }
        if (string2 == null) return null;
        if (string2.trim().length() <= 0) return null;
        boolean bl = false;
        if (bl) {
            return null;
        }
        u.b("[param] remove user data: %s", string2);
        return com.tencent.bugly.crashreport.common.info.a.a(context).f(string2);
    }

    public static void setAppVersion(Context context, String string2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set APP version because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)u.b, (String)"setAppVersion args context should not be null");
            return;
        }
        if (string2 == null) {
            Log.w((String)u.b, (String)"Version is null, will not set");
            return;
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).i = string2;
    }

    public static void setContext(Context context) {
        synchronized (CrashReport.class) {
            a = context;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setIsAppForeground(Context context, boolean bl) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set 'isAppForeground' because bugly is disable.");
            return;
        }
        if (context == null) {
            u.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            u.c("App is in foreground.", new Object[0]);
        } else {
            u.c("App is in background.", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a((Context)context).n = bl;
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean bl) {
        return CrashReport.setJavascriptMonitor(webView, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebView webView, boolean bl, boolean bl2) {
        H5JavaScriptInterface h5JavaScriptInterface;
        if (webView == null) {
            Log.w((String)u.b, (String)"Webview is null.");
            return false;
        }
        if (!CrashModule.hasInitialized()) {
            u.e("CrashReport has not been initialed! please to call method 'initCrashReport' first!", new Object[0]);
            return false;
        }
        u.a("Set Javascript exception monitor of webview.", new Object[0]);
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set JavaScript monitor because bugly is disable.");
            return false;
        }
        u.c("URL of webview is %s", webView.getUrl());
        if (webView.getUrl() == null) return false;
        if (!bl2 && Build.VERSION.SDK_INT < 19) {
            u.e("This interface is only available for Android 4.4 or later.", new Object[0]);
            return false;
        }
        WebSettings webSettings = webView.getSettings();
        if (!webSettings.getJavaScriptEnabled()) {
            u.a("Enable the javascript needed by webview monitor.", new Object[0]);
            webSettings.setJavaScriptEnabled(true);
        }
        if ((h5JavaScriptInterface = H5JavaScriptInterface.getInstance(webView)) != null) {
            u.a("Add a secure javascript interface to the webview.", new Object[0]);
            webView.addJavascriptInterface((Object)h5JavaScriptInterface, "exceptionUploader");
        }
        if (!bl) return true;
        u.a("Inject bugly.js(v%s) to the webview.", c.b());
        String string2 = c.a();
        if (string2 == null) {
            u.e("Failed to inject Bugly.js.", c.b());
            return false;
        }
        webView.loadUrl("javascript:" + string2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSdkExtraData(Context context, String string2, String iterator) {
        boolean bl = false;
        synchronized (CrashReport.class) {
            block11: {
                if (Bugly.enable) break block11;
                Log.w((String)u.b, (String)"Can not put SDK extra data because bugly is disable.");
                return;
            }
            if (context == null) return;
            if (string2 == null) return;
            if (string2.trim().length() <= 0) return;
            boolean bl2 = false;
            if (bl2) return;
            if (iterator == null) return;
            if (((String)((Object)iterator)).trim().length() <= 0) return;
            bl2 = bl;
            if (bl2) return;
            try {
                if (b == null) {
                    b = new HashMap<String, String>();
                }
                b.put(string2, (String)((Object)iterator));
                if (b.size() <= 0) return;
                iterator = b.entrySet().iterator();
                string2 = "";
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    string2 = string2 + "[" + entry.getKey() + "," + entry.getValue() + "] ";
                }
                CrashReport.putSdkData(context, "SDK_INFO", string2);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    public static void setSessionIntervalMills(long l2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set 'SessionIntervalMills' because bugly is disable.");
            return;
        }
        com.tencent.bugly.crashreport.biz.b.a(l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setUserId(String string2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set user ID because bugly is disable.");
            return;
        } else {
            if (!CrashModule.hasInitialized()) {
                throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
            }
            if (string2 == null) {
                u.d("userId should not be null", new Object[0]);
                return;
            }
            String string3 = string2;
            if (string2.length() > 100) {
                string3 = string2.substring(0, 100);
                u.d("userId %s length is over limit %d substring to %s", string2, 100, string3);
            }
            if (string3.equals(com.tencent.bugly.crashreport.common.info.a.a(a).f())) return;
            com.tencent.bugly.crashreport.common.info.a.a(a).b(string3);
            u.b("[user] set userId : %s", string3);
            com.tencent.bugly.crashreport.biz.b.a();
            return;
        }
    }

    public static void setUserSceneTag(Context context, int n2) {
        if (!Bugly.enable) {
            Log.w((String)u.b, (String)"Can not set tag caught because bugly is disable.");
            return;
        }
        if (context == null) {
            throw new BuglyHintException("setTag args context should not be null");
        }
        if (n2 <= 0) {
            u.d("setTag args tagId should > 0", new Object[0]);
        }
        com.tencent.bugly.crashreport.common.info.a.a(context).a(n2);
        u.b("[param] set user scene tag: %d", n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startCrashReport() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not start crash report because bugly is disable.");
            } else if (!CrashModule.hasInitialized()) {
                Log.w((String)u.b, (String)"Report has not been initialed! pls to call method 'initCrashReport' first!");
            } else {
                com.tencent.bugly.crashreport.crash.c.a().c();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void testANRCrash() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not test ANR crash because bugly is disable.");
            } else {
                if (!CrashModule.hasInitialized()) {
                    throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
                }
                u.a("start to create a anr crash for test!", new Object[0]);
                com.tencent.bugly.crashreport.crash.c.a().k();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void testJavaCrash() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not test Java crash because bugly is disable.");
                return;
            }
            if (!CrashModule.hasInitialized()) {
                throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
            }
            throw new RuntimeException("This Crash create for Test! You can go to Bugly see more detail!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void testNativeCrash() {
        synchronized (CrashReport.class) {
            if (!Bugly.enable) {
                Log.w((String)u.b, (String)"Can not test native crash because bugly is disable.");
            } else {
                if (!CrashModule.hasInitialized()) {
                    throw new BuglyHintException("Report has not been initialed! pls to call method 'initCrashReport' first!");
                }
                u.a("start to create a native crash for test!", new Object[0]);
                com.tencent.bugly.crashreport.crash.c.a().j();
            }
            return;
        }
    }

    public static class CrashHandleCallback
    extends BuglyStrategy.a {
    }

    public static class UserStrategy
    extends BuglyStrategy {
        private CrashHandleCallback a;

        public UserStrategy(Context context) {
        }

        @Override
        public CrashHandleCallback getCrashHandleCallback() {
            synchronized (this) {
                CrashHandleCallback crashHandleCallback = this.a;
                return crashHandleCallback;
            }
        }

        public void setCrashHandleCallback(CrashHandleCallback crashHandleCallback) {
            synchronized (this) {
                this.a = crashHandleCallback;
                return;
            }
        }
    }
}

