/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.cocos;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Cocos2dxAgent {
    private static final String TAG = "Cocos2dxAgent";
    private static final String VERSION = "1.2.0";
    private static boolean isDebug;
    private static Handler mHandler;
    private static String sAppChannel;
    private static String sAppVersion;
    private static long sDelayTime;
    public static String sdkPackageName;

    static {
        sdkPackageName = "com.tencent.bugly";
        isDebug = true;
        mHandler = null;
        sAppVersion = null;
        sAppChannel = null;
        sDelayTime = 0L;
    }

    private Cocos2dxAgent() {
        try {
            mHandler = new Handler(Looper.getMainLooper());
            return;
        }
        catch (Exception exception) {
            Cocos2dxAgent.printLog(2, "[cocos2d-x] Get the main looper handler Failed.");
            exception.printStackTrace();
            return;
        }
    }

    private static String convertToCanonicalName(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sdkPackageName == null) {
            sdkPackageName = "com.tencent.bugly";
        }
        stringBuilder.append(sdkPackageName);
        stringBuilder.append(".");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static void delayExit(long l2) {
        l2 = Math.max(0L, l2);
        if (mHandler != null) {
            mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Cocos2dxAgent.exitApplication();
                }
            }, l2);
            return;
        }
        try {
            Thread.sleep(l2);
            Cocos2dxAgent.exitApplication();
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return;
        }
    }

    public static void exitApplication() {
        int n2 = Process.myPid();
        Cocos2dxAgent.printLog(2, String.format("Exit application by kill process[%d]", n2));
        Process.killProcess((int)n2);
    }

    public static void initCrashReport(Context context, String string2, boolean bl) {
        Cocos2dxAgent.initCrashReport(context, string2, bl, sAppChannel, sAppVersion, null, sDelayTime);
    }

    /*
     * Unable to fully structure code
     */
    private static void initCrashReport(Context var0, String var1_1, boolean var2_2, String var3_3, String var4_6, String var5_7, long var6_8) {
        block10: {
            if (var0 == null) {
                Cocos2dxAgent.printLog(3, "context is null. bugly initialize terminated.");
            }
            Cocos2dxAgent.isDebug = var2_2;
            if (TextUtils.isEmpty((CharSequence)var1_1)) {
                Cocos2dxAgent.printLog(2, "Please input appid when initCrashReport.");
                return;
            }
            if (var0 == null || TextUtils.isEmpty((CharSequence)var1_1)) {
                Log.w((String)"Cocos2dxAgent", (String)"Fail to init the crash report");
                return;
            }
            if ((var4_6 = Cocos2dxAgent.newStrategy(var0, (String)var3_3, (String)var4_6, var6_8)) == null) break block10;
            try {
                var3_3 = Class.forName(Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport$UserStrategy"));
lbl15:
                // 3 sources

                ** while (var3_3 != null)
            }
            catch (ClassNotFoundException var3_4) {
                var3_4.printStackTrace();
                var3_3 = null;
                ** GOTO lbl15
            }
            catch (Exception var3_5) {
                var3_5.printStackTrace();
                var3_3 = null;
                ** GOTO lbl15
            }
lbl-1000:
            // 1 sources

            {
                var9_9 = Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport");
                var10_10 = Boolean.TYPE;
                Reflection.invokeStaticMethod(var9_9, "initCrashReport", new Object[]{var0, var1_1, var2_2, var4_6}, new Class[]{Context.class, String.class, var10_10, var3_3});
                var8_11 = true;
lbl21:
                // 2 sources

                while (true) {
                    if (!var8_11) {
                        var3_3 = Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport");
                        var4_6 = Boolean.TYPE;
                        Reflection.invokeStaticMethod((String)var3_3, "initCrashReport", new Object[]{var0, var1_1, var2_2}, new Class[]{Context.class, String.class, var4_6});
                    }
                    if (TextUtils.isEmpty((CharSequence)var5_7)) ** continue;
                    Reflection.invokeStaticMethod(Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport"), "setUserId", new Object[]{var5_7}, new Class[]{String.class});
                    return;
                }
lbl31:
                // 1 sources

            }
        }
        var8_11 = false;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object newStrategy(Context object, String string2, String string3, long l2) {
        if (object == null) return null;
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        object = Reflection.newInstance(Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport$UserStrategy"), new Object[]{object}, Context.class);
        if (object == null) return null;
        Class<?> clazz = object.getClass();
        try {
            clazz.getDeclaredMethod("setAppChannel", String.class).invoke(object, string2);
            clazz.getDeclaredMethod("setAppVersion", String.class).invoke(object, string3);
            clazz.getDeclaredMethod("setAppReportDelay", Long.TYPE).invoke(object, l2);
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void postException(int n2, String string2, String string3, String object, boolean bl) {
        Object object2;
        Object object3;
        block12: {
            Object object4;
            object3 = ((String)object).startsWith("stack traceback") ? ((String)object).substring(((String)object).indexOf("\n") + 1, ((String)object).length()).trim() : object;
            Object object5 = object3;
            int n3 = ((String)object3).indexOf("\n");
            object = object3;
            if (n3 > 0) {
                object5 = object3;
                object = ((String)object3).substring(n3 + 1, ((String)object3).length());
            }
            object5 = object;
            n3 = ((String)object).indexOf("\n");
            if (n3 > 0) {
                object5 = object;
                object4 = ((String)object).substring(0, n3);
            } else {
                object4 = object;
            }
            object5 = object;
            n3 = ((String)object4).indexOf("]:");
            if (string2 != null) {
                object2 = object;
                object3 = string2;
                object5 = object;
                if (string2.length() != 0) break block12;
            }
            if (n3 != -1) {
                object5 = object;
                object3 = ((String)object4).substring(0, n3 + 1);
                object2 = object;
                break block12;
            } else {
                object3 = string3;
                object2 = object;
            }
            break block12;
            {
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                object5 = object;
                if (string2 != null) {
                    object2 = object5;
                    object3 = string2;
                    if (string2.length() != 0) break block12;
                }
                object3 = string3;
                object2 = object5;
            }
        }
        string2 = Cocos2dxAgent.convertToCanonicalName("crashreport.inner.InnerAPI");
        object = Integer.TYPE;
        Reflection.invokeStaticMethod(string2, "postCocos2dxCrashAsync", new Object[]{n2, object3, string3, object2}, new Class[]{object, String.class, String.class, String.class});
        if (bl) {
            Cocos2dxAgent.delayExit(3000L);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void printLog(int n2, String string2) {
        block7: {
            block6: {
                if (TextUtils.isEmpty((CharSequence)string2)) break block6;
                if (isDebug && n2 == 0) {
                    Cocos2dxAgent.sdkLog("d", string2);
                }
                if (n2 == 1) {
                    Cocos2dxAgent.sdkLog("i", string2);
                }
                if (n2 == 2) {
                    Cocos2dxAgent.sdkLog("w", string2);
                }
                if (n2 >= 3) break block7;
            }
            return;
        }
        Cocos2dxAgent.sdkLog("e", string2);
    }

    public static void printLog(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        Cocos2dxAgent.printLog(2, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void putUserData(Context context, String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || context == null) {
            return;
        }
        Reflection.invokeStaticMethod(Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport"), "putUserData", new Object[]{context, string2, string3}, Context.class, String.class, String.class);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void removeUserData(Context context, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2) || context == null) {
            return;
        }
        Reflection.invokeStaticMethod(Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport"), "removeUserData", new Object[]{context, string2}, Context.class, String.class);
    }

    private static void sdkLog(String string2, String string3) {
        Reflection.invokeStaticMethod(Cocos2dxAgent.convertToCanonicalName("crashreport.BuglyLog"), string2, new Object[]{"", string3}, String.class, String.class);
    }

    public static void setAppChannel(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        sAppChannel = string2;
    }

    public static void setAppVersion(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        sAppVersion = string2;
    }

    public static void setDelayTime(long l2) {
        if (l2 <= 0L) {
            return;
        }
        sDelayTime = l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setLog(int n2, String string2, String string3) {
        String string4;
        block10: {
            block9: {
                if (TextUtils.isEmpty((CharSequence)string2)) break block9;
                string4 = null;
                switch (n2) {
                    case 0: {
                        string4 = "v";
                        break;
                    }
                    case 1: {
                        string4 = "d";
                        break;
                    }
                    case 2: {
                        string4 = "i";
                        break;
                    }
                    case 3: {
                        string4 = "w";
                        break;
                    }
                    case 4: {
                        string4 = "e";
                        break;
                    }
                }
                if (string4 != null) break block10;
            }
            return;
        }
        Reflection.invokeStaticMethod(Cocos2dxAgent.convertToCanonicalName("crashreport.BuglyLog"), string4, new Object[]{string2, string3}, String.class, String.class);
    }

    public static void setSDKPackagePrefixName(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        sdkPackageName = string2;
    }

    public static void setUserId(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        Reflection.invokeStaticMethod(Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport"), "setUserId", new Object[]{string2}, String.class);
    }

    public static void setUserSceneTag(Context context, int n2) {
        if (context != null) {
            String string2 = Cocos2dxAgent.convertToCanonicalName("crashreport.CrashReport");
            Class<Integer> clazz = Integer.TYPE;
            Reflection.invokeStaticMethod(string2, "setUserSceneTag", new Object[]{context, n2}, Context.class, clazz);
        }
    }

    public String getVersion() {
        return VERSION;
    }

    private static class Reflection {
        private Reflection() {
        }

        public static Object invokeStaticMethod(String object, String string2, Object[] objectArray, Class<?> ... classArray) {
            try {
                object = Class.forName((String)object).getDeclaredMethod(string2, classArray);
                ((Method)object).setAccessible(true);
                object = ((Method)object).invoke(null, objectArray);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Object newInstance(String clazz, Object[] objectArray, Class<?> ... classArray) {
            clazz = Class.forName(clazz);
            if (objectArray != null) return clazz.getConstructor(classArray).newInstance(objectArray);
            try {
                return clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                return null;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }
}

