/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsPrfParameterSpec;

public final class TlsPrfGenerator
extends KeyGeneratorSpi {
    private static final byte[] B0 = new byte[0];
    private static final byte[] HMAC_ipad;
    private static final byte[] HMAC_opad;
    static final byte[] LABEL_CLIENT_WRITE_KEY;
    static final byte[] LABEL_IV_BLOCK;
    static final byte[] LABEL_KEY_EXPANSION;
    static final byte[] LABEL_MASTER_SECRET;
    static final byte[] LABEL_SERVER_WRITE_KEY;
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    static final byte[][] SSL3_CONST;
    private TlsPrfParameterSpec spec;

    static {
        LABEL_MASTER_SECRET = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
        LABEL_KEY_EXPANSION = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
        LABEL_CLIENT_WRITE_KEY = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
        LABEL_SERVER_WRITE_KEY = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
        LABEL_IV_BLOCK = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
        HMAC_ipad = TlsPrfGenerator.genPad((byte)54, 64);
        HMAC_opad = TlsPrfGenerator.genPad((byte)92, 64);
        SSL3_CONST = TlsPrfGenerator.genConst();
    }

    public TlsPrfGenerator() {
        SunJCE.a(this.getClass());
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        byte[] byArray3 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        System.arraycopy(byArray2, 0, byArray3, n2, n3);
        return byArray3;
    }

    static final byte[] doPRF(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) throws NoSuchAlgorithmException, DigestException {
        return TlsPrfGenerator.doPRF(byArray, byArray2, byArray3, n2, MessageDigest.getInstance("MD5"), MessageDigest.getInstance("SHA1"));
    }

    static final byte[] doPRF(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, MessageDigest messageDigest, MessageDigest messageDigest2) throws DigestException {
        if (byArray == null) {
            byArray = B0;
        }
        int n3 = byArray.length >> 1;
        int n4 = n3 + (byArray.length & 1);
        byte[] byArray4 = new byte[n2];
        TlsPrfGenerator.expand(messageDigest, 16, byArray, 0, n4, byArray2, byArray3, byArray4);
        TlsPrfGenerator.expand(messageDigest2, 20, byArray, n3, n4, byArray2, byArray3, byArray4);
        return byArray4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void expand(MessageDigest messageDigest, int n2, byte[] byArray, int n3, int n4, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws DigestException {
        int n5;
        byte[] byArray5 = (byte[])HMAC_ipad.clone();
        byte[] byArray6 = (byte[])HMAC_opad.clone();
        for (n5 = 0; n5 < n4; ++n5) {
            byArray5[n5] = (byte)(byArray5[n5] ^ byArray[n5 + n3]);
            byArray6[n5] = (byte)(byArray6[n5] ^ byArray[n5 + n3]);
        }
        byte[] byArray7 = new byte[n2];
        n3 = byArray4.length;
        byArray = null;
        n4 = 0;
        while (n3 > 0) {
            messageDigest.update(byArray5);
            if (byArray == null) {
                messageDigest.update(byArray2);
                messageDigest.update(byArray3);
            } else {
                messageDigest.update(byArray);
            }
            messageDigest.digest(byArray7, 0, n2);
            messageDigest.update(byArray6);
            messageDigest.update(byArray7);
            byte[] byArray8 = byArray;
            if (byArray == null) {
                byArray8 = new byte[n2];
            }
            messageDigest.digest(byArray8, 0, n2);
            messageDigest.update(byArray5);
            messageDigest.update(byArray8);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            messageDigest.digest(byArray7, 0, n2);
            messageDigest.update(byArray6);
            messageDigest.update(byArray7);
            messageDigest.digest(byArray7, 0, n2);
            int n6 = Math.min(n2, n3);
            for (n5 = 0; n5 < n6; ++n5, ++n4) {
                byArray4[n4] = (byte)(byArray4[n4] ^ byArray7[n5]);
            }
            n3 -= n6;
            byArray = byArray8;
        }
        return;
    }

    private static byte[][] genConst() {
        byte[][] byArrayArray = new byte[10][];
        for (int i2 = 0; i2 < 10; ++i2) {
            byte[] byArray = new byte[i2 + 1];
            Arrays.fill(byArray, (byte)(i2 + 65));
            byArrayArray[i2] = byArray;
        }
        return byArrayArray;
    }

    static byte[] genPad(byte by, int n2) {
        byte[] byArray = new byte[n2];
        Arrays.fill(byArray, by);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        Object object = this.spec.getSecret();
        object = object == null ? null : (Object)object.getEncoded();
        try {
            byte[] byArray = this.spec.getLabel().getBytes("UTF8");
            int n2 = this.spec.getOutputLength();
            return new SecretKeySpec(TlsPrfGenerator.doPRF((byte[])object, byArray, this.spec.getSeed(), n2), "TlsPrf");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException("Could not generate PRF", generalSecurityException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ProviderException("Could not generate PRF", unsupportedEncodingException);
        }
    }

    @Override
    protected void engineInit(int n2, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec object, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(object instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsPrfParameterSpec)object;
        object = this.spec.getSecret();
        if (object != null && !"RAW".equals(object.getFormat())) {
            throw new InvalidAlgorithmParameterException("Key encoding format must be RAW");
        }
    }
}

