/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.TlsPrfGenerator;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.internal.interfaces.TlsMasterSecret;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;

public final class TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private int protocolVersion;
    private TlsMasterSecretParameterSpec spec;

    public TlsMasterSecretGenerator() {
        SunJCE.a(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SecretKey engineGenerateKey() {
        int n2;
        int n3;
        int n4 = 0;
        if (this.spec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        Object object = this.spec.getPremasterSecret();
        byte[] byArray = object.getEncoded();
        if (object.getAlgorithm().equals("TlsRsaPremasterSecret")) {
            n3 = byArray[0];
            n2 = byArray[1];
            n3 &= 0xFF;
            n2 &= 0xFF;
        } else {
            n2 = -1;
            n3 = -1;
        }
        try {
            byte[] byArray2 = this.spec.getClientRandom();
            byte[] byArray3 = this.spec.getServerRandom();
            if (this.protocolVersion >= 769) {
                object = TlsPrfGenerator.concat(byArray2, byArray3);
                object = TlsPrfGenerator.doPRF(byArray, TlsPrfGenerator.LABEL_MASTER_SECRET, (byte[])object, 48);
                return new TlsMasterSecretKey((byte[])object, n3, n2);
            } else {
                byte[] byArray4 = new byte[48];
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA");
                byte[] byArray5 = new byte[20];
                while (true) {
                    object = byArray4;
                    if (n4 >= 3) return new TlsMasterSecretKey((byte[])object, n3, n2);
                    messageDigest2.update(TlsPrfGenerator.SSL3_CONST[n4]);
                    messageDigest2.update(byArray);
                    messageDigest2.update(byArray2);
                    messageDigest2.update(byArray3);
                    messageDigest2.digest(byArray5, 0, 20);
                    messageDigest.update(byArray);
                    messageDigest.update(byArray5);
                    messageDigest.digest(byArray4, n4 << 4, 16);
                    ++n4;
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    @Override
    protected void engineInit(int n2, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
        if (!"RAW".equals(this.spec.getPremasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.protocolVersion < 768 || this.protocolVersion > 770) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, and TLS 1.1 supported");
        }
    }

    private static final class TlsMasterSecretKey
    implements TlsMasterSecret {
        private byte[] key;
        private final int majorVersion;
        private final int minorVersion;

        TlsMasterSecretKey(byte[] byArray, int n2, int n3) {
            this.key = byArray;
            this.majorVersion = n2;
            this.minorVersion = n3;
        }

        @Override
        public String getAlgorithm() {
            return "TlsMasterSecret";
        }

        @Override
        public byte[] getEncoded() {
            return (byte[])this.key.clone();
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public int getMajorVersion() {
            return this.majorVersion;
        }

        @Override
        public int getMinorVersion() {
            return this.minorVersion;
        }
    }
}

