/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.TlsPrfGenerator;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

final class SslMacCore {
    private boolean first;
    private final MessageDigest md;
    private final byte[] pad1;
    private final byte[] pad2;
    private byte[] secret;

    SslMacCore(String string2, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
        this.md = MessageDigest.getInstance(string2);
        this.pad1 = byArray;
        this.pad2 = byArray2;
        this.first = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] doFinal() {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
        } else {
            this.first = true;
        }
        try {
            byte[] byArray = this.md.digest();
            this.md.update(this.secret);
            this.md.update(this.pad2);
            this.md.update(byArray);
            this.md.digest(byArray, 0, byArray.length);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    int getDigestLength() {
        return this.md.getDigestLength();
    }

    void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("SslMac does not use parameters");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        this.secret = key.getEncoded();
        if (this.secret == null || this.secret.length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        this.reset();
    }

    void reset() {
        if (!this.first) {
            this.md.reset();
            this.first = true;
        }
    }

    void update(byte by) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(by);
    }

    void update(ByteBuffer byteBuffer) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(byteBuffer);
    }

    void update(byte[] byArray, int n2, int n3) {
        if (this.first) {
            this.md.update(this.secret);
            this.md.update(this.pad1);
            this.first = false;
        }
        this.md.update(byArray, n2, n3);
    }

    public static final class SslMacMD5
    extends MacSpi {
        static final byte[] md5Pad1 = TlsPrfGenerator.genPad((byte)54, 48);
        static final byte[] md5Pad2 = TlsPrfGenerator.genPad((byte)92, 48);
        private final SslMacCore core = new SslMacCore("MD5", md5Pad1, md5Pad2);

        static {
            SunJCE.a(SslMacMD5.class);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, algorithmParameterSpec);
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.core.update(by);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.core.update(byteBuffer);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.core.update(byArray, n2, n3);
        }
    }

    public static final class SslMacSHA1
    extends MacSpi {
        static final byte[] shaPad1 = TlsPrfGenerator.genPad((byte)54, 40);
        static final byte[] shaPad2 = TlsPrfGenerator.genPad((byte)92, 40);
        private final SslMacCore core = new SslMacCore("SHA", shaPad1, shaPad2);

        static {
            SunJCE.a(SslMacSHA1.class);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.core.doFinal();
        }

        @Override
        protected int engineGetMacLength() {
            return this.core.getDigestLength();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.init(key, algorithmParameterSpec);
        }

        @Override
        protected void engineReset() {
            this.core.reset();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.core.update(by);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.core.update(byteBuffer);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.core.update(byArray, n2, n3);
        }
    }
}

