/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class RC2Parameters
extends AlgorithmParametersSpi {
    private static final int[] a = new int[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
    private byte[] b;
    private int c = 0;
    private int d = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.d != 0) {
            derOutputStream2.putInteger(this.c);
            derOutputStream2.putOctetString(this.b);
            derOutputStream.write((byte)48, derOutputStream2);
            return derOutputStream.toByteArray();
        }
        derOutputStream.putOctetString(this.b);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string2) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (RC2ParameterSpec.class.isAssignableFrom(clazz)) {
            if (this.b == null) {
                return new RC2ParameterSpec(this.d);
            }
            return new RC2ParameterSpec(this.d, this.b);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        algorithmParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
        this.d = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits();
        if (this.d != 0) {
            if (this.d < 1 || this.d > 1024) {
                throw new InvalidParameterSpecException("RC2 effective key size must be between 1 and 1024 bits");
            }
            this.c = this.d < 256 ? a[this.d] : this.d;
        }
        this.b = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void engineInit(byte[] var1_1) throws IOException {
        block5: {
            block6: {
                var2_2 = 0;
                var1_1 = new DerValue((byte[])var1_1);
                if (var1_1.tag != 48) break block6;
                var1_1.data.reset();
                this.c = var1_1.data.getInteger();
                if (this.c < 0 || this.c > 1024) {
                    throw new IOException("RC2 parameter parsing error: version number out of legal range (0-1024): " + this.c);
                }
                if (this.c <= 255) ** GOTO lbl16
                this.d = this.c;
lbl10:
                // 3 sources

                while (true) {
                    this.b = var1_1.data.getOctetString();
lbl12:
                    // 2 sources

                    while (this.b.length != 8) {
                        throw new IOException("RC2 parameter parsing error: iv length must be 8 bits, actual: " + this.b.length);
                    }
                    break block5;
                    break;
                }
lbl-1000:
                // 1 sources

                {
                    ++var2_2;
lbl16:
                    // 2 sources

                    if (var2_2 >= RC2Parameters.a.length) ** GOTO lbl10
                    ** while (this.c != RC2Parameters.a[var2_2])
                }
lbl18:
                // 1 sources

                this.d = var2_2;
                ** while (true)
            }
            var1_1.data.reset();
            this.b = var1_1.getOctetString();
            this.c = 0;
            this.d = 0;
            ** GOTO lbl12
        }
        if (var1_1.data.available() != 0) {
            throw new IOException("RC2 parameter parsing error: extra data");
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string2) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        String string2 = System.getProperty("line.separator");
        Object object = new HexDumpEncoder();
        object = new StringBuilder(string2 + "    iv:" + string2 + "[" + object.encodeBuffer(this.b) + "]");
        if (this.c != 0) {
            ((StringBuilder)object).append(string2 + "version:" + string2 + this.c + string2);
        }
        return ((StringBuilder)object).toString();
    }
}

