/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SunJCE_ae;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;

public final class PBKDF2HmacSHA1Factory
extends SecretKeyFactorySpi {
    public PBKDF2HmacSHA1Factory() {
        if (!SunJCE.b(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return new SunJCE_ae((PBEKeySpec)keySpec, "HmacSHA1");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (secretKey instanceof PBEKey) {
            if (clazz != null && PBEKeySpec.class.isAssignableFrom(clazz)) {
                secretKey = (PBEKey)secretKey;
                return new PBEKeySpec(secretKey.getPassword(), secretKey.getSalt(), secretKey.getIterationCount(), secretKey.getEncoded().length * 8);
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("PBKDF2WithHmacSHA1") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
            if (secretKey instanceof SunJCE_ae) {
                return secretKey;
            }
            if (secretKey instanceof PBEKey) {
                secretKey = (PBEKey)secretKey;
                try {
                    secretKey = new SunJCE_ae(new PBEKeySpec(secretKey.getPassword(), secretKey.getSalt(), secretKey.getIterationCount(), secretKey.getEncoded().length * 8), "HmacSHA1");
                    return secretKey;
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    InvalidKeyException invalidKeyException = new InvalidKeyException("Invalid key component(s)");
                    invalidKeyException.initCause(invalidKeySpecException);
                    throw invalidKeyException;
                }
            }
        }
        throw new InvalidKeyException("Invalid key format/algorithm");
    }
}

