/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class PBEParameters
extends AlgorithmParametersSpi {
    private byte[] a = null;
    private int b = 0;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.a);
        derOutputStream2.putInteger(this.b);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string2) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (PBEParameterSpec.class.isAssignableFrom(clazz)) {
            return new PBEParameterSpec(this.a, this.b);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.a = (byte[])((PBEParameterSpec)algorithmParameterSpec).getSalt().clone();
        this.b = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(byte[] object) throws IOException {
        try {
            object = new DerValue((byte[])object);
            if (object.tag != 48) {
                throw new IOException("PBE parameter parsing error: not a sequence");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("iteration count too big");
        }
        {
            object.data.reset();
            this.a = object.data.getOctetString();
            this.b = object.data.getInteger();
            if (object.data.available() != 0) {
                throw new IOException("PBE parameter parsing error: extra data");
            }
            return;
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string2) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        String string2 = System.getProperty("line.separator");
        String string3 = string2 + "    salt:" + string2 + "[";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string3 = string3 + hexDumpEncoder.encodeBuffer(this.a);
        string3 = string3 + "]";
        return string3 + string2 + "    iterationCount:" + string2 + Debug.toHexString(BigInteger.valueOf(this.b)) + string2;
    }
}

