/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBEKey;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    private static HashSet<String> b = new HashSet(4);
    private String a;

    static {
        b.add("PBEWithMD5AndDES".toUpperCase());
        b.add("PBEWithSHA1AndDESede".toUpperCase());
        b.add("PBEWithSHA1AndRC2_40".toUpperCase());
        b.add("PBEWithMD5AndTripleDES".toUpperCase());
    }

    private PBEKeyFactory(String string2) {
        if (!SunJCE.b(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
        this.a = string2;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return new PBEKey((PBEKeySpec)keySpec, this.a);
    }

    protected KeySpec engineGetKeySpec(SecretKey object, Class object2) throws InvalidKeySpecException {
        if (object instanceof SecretKey && b.contains(object.getAlgorithm().toUpperCase()) && object.getFormat().equalsIgnoreCase("RAW")) {
            if (object2 != null && PBEKeySpec.class.isAssignableFrom((Class<?>)object2)) {
                object = object.getEncoded();
                object2 = new char[((Object)object).length];
                for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
                    object2[i2] = (char)(object[i2] & 0x7F);
                }
                PBEKeySpec pBEKeySpec = new PBEKeySpec((char[])object2);
                Arrays.fill((char[])object2, ' ');
                Arrays.fill((byte[])object, (byte)0);
                return pBEKeySpec;
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        block3: {
            if (secretKey == null) throw new InvalidKeyException("Invalid key format/algorithm");
            try {
                if (!b.contains(secretKey.getAlgorithm().toUpperCase()) || !secretKey.getFormat().equalsIgnoreCase("RAW")) throw new InvalidKeyException("Invalid key format/algorithm");
                if (!(secretKey instanceof PBEKey)) break block3;
                return secretKey;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
            }
        }
        return this.engineGenerateSecret((PBEKeySpec)this.engineGetKeySpec(secretKey, (Class)PBEKeySpec.class));
    }

    public static final class PBEWithMD5AndDES
    extends PBEKeyFactory {
        public PBEWithMD5AndDES() {
            super("PBEWithMD5AndDES");
        }
    }

    public static final class PBEWithMD5AndTripleDES
    extends PBEKeyFactory {
        public PBEWithMD5AndTripleDES() {
            super("PBEWithMD5AndTripleDES");
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends PBEKeyFactory {
        public PBEWithSHA1AndDESede() {
            super("PBEWithSHA1AndDESede");
        }
    }

    public static final class PBEWithSHA1AndRC2_40
    extends PBEKeyFactory {
        public PBEWithSHA1AndRC2_40() {
            super("PBEWithSHA1AndRC2_40");
        }
    }
}

