/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.KeyRep;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

final class PBEKey
implements SecretKey {
    static final long serialVersionUID = -2234768909660948176L;
    private byte[] key;
    private String type;

    PBEKey(PBEKeySpec object, String string2) throws InvalidKeySpecException {
        int n2;
        int n3 = 0;
        char[] cArray = ((PBEKeySpec)object).getPassword();
        object = cArray;
        if (cArray == null) {
            object = new char[0];
        }
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            if (object[n2] >= 32 && object[n2] <= 126) continue;
            throw new InvalidKeySpecException("Password is not ASCII");
        }
        this.key = new byte[((Object)object).length];
        for (n2 = n3; n2 < ((Object)object).length; ++n2) {
            this.key[n2] = (byte)(object[n2] & 0x7F);
        }
        Arrays.fill((char[])object, ' ');
        this.type = string2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.key = (byte[])this.key.clone();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (object == this) {
            return true;
        }
        boolean bl2 = bl;
        if (!(object instanceof SecretKey)) return bl2;
        object = (SecretKey)object;
        bl2 = bl;
        if (!object.getAlgorithm().equalsIgnoreCase(this.type)) return bl2;
        object = object.getEncoded();
        bl2 = Arrays.equals(this.key, (byte[])object);
        Arrays.fill((byte[])object, (byte)0);
        return bl2;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.type;
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return this.getAlgorithm().toLowerCase().hashCode() ^ n2;
    }
}

